/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.testprovider;

import com.pegacat.testprovider.Base64;
import com.pegacat.testprovider.DataTree;
import com.pegacat.testprovider.TestProviderEnumeration;
import com.pegacat.testprovider.TestProviderParser;
import com.pegacat.testprovider.TreeEntry;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class TestProviderContext
implements DirContext {
    private DataTree entries;
    private static String NEVER = "never";
    private static String SEARCHING = "searching";
    private static String FINDING = "finding";
    private static String ALWAYS = "always";
    private static String[] ALIASOPTIONS = new String[]{NEVER, SEARCHING, FINDING, ALWAYS};
    private static SearchControls DEFAULT_SEARCH_CONTROLS = new SearchControls();
    protected Hashtable environment;
    private String contextName = "";
    private boolean secureLogon = false;
    private static Logger log = Logger.getLogger(TestProviderContext.class.getName());

    private static boolean checkValidity(String[] options, String checkme) {
        if (checkme != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!options[i].equals(checkme)) continue;
                return true;
            }
        }
        return false;
    }

    private TestProviderContext() {
        log.setLevel(Level.FINEST);
    }

    public boolean isSecure() {
        return this.secureLogon;
    }

    public DataTree getEntries() {
        return this.entries;
    }

    private TestProviderContext(String baseDN, Hashtable env, DataTree tree) throws NamingException {
        log.setLevel(Level.FINEST);
        this.entries = tree;
        this.checkSecurity(env);
        this.contextName = baseDN == null ? "" : baseDN;
        this.environment = env;
    }

    private void checkSecurity(Hashtable env) throws AuthenticationException {
        if (env != null && "simple".equals(env.get("java.naming.security.authentication"))) {
            String userName = (String)env.get("java.naming.security.principal");
            String userPwd = (String)env.get("java.naming.security.credentials");
            this.checkUserNameAndPassword(userName, userPwd);
        } else {
            System.out.println("logged in anonymously");
        }
    }

    void checkUserNameAndPassword(String userName, String userPwd) throws AuthenticationException {
        this.secureLogon = false;
        if (userName != null) {
            if ((userName.equals("Chris") || userName.equals("cn=Chris,ou=research,o=pegacat,c=au")) && userPwd.equals("secret")) {
                this.secureLogon = true;
            } else {
                try {
                    Attributes atts = this.getAttributes(userName);
                    Attribute pwdAtt = atts.get("userPassword");
                    if (pwdAtt == null || pwdAtt.size() == 0) {
                        throw new AuthenticationException("no password for user " + userName + " in directory");
                    }
                    String pwd = pwdAtt.get().toString();
                    if (pwd.startsWith("{sha}") || pwd.startsWith("{SHA}")) {
                        if (!userPwd.startsWith("{sha}") && !userPwd.startsWith("{SHA}")) {
                            userPwd = TestProviderContext.shaEncode(userPwd);
                        }
                        if (pwd.substring(5).equals(userPwd.substring(5))) {
                            this.secureLogon = true;
                        }
                    } else if (pwd.equals(userPwd)) {
                        this.secureLogon = true;
                    }
                }
                catch (NamingException e) {
                    throw new AuthenticationException("no user '" + userName + "'");
                }
                catch (Exception e) {
                    throw new AuthenticationException("unable to authenticate user '" + userName + "' " + e.getMessage());
                }
            }
            if (this.secureLogon) {
                System.out.println("logged in as " + userName + " : " + userPwd);
            } else {
                throw new AuthenticationException("unable to authenticate user '" + userName + "' ");
            }
        }
    }

    private static String shaEncode(String s) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("sha");
            StringBuffer hexString = new StringBuffer("{sha}");
            md.reset();
            md.update(s.getBytes("UTF-8"));
            byte[] buff = md.digest();
            hexString.append(Base64.binaryToString(buff));
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.WARNING, "Unexpected error encoding password ", e);
            e.printStackTrace();
            throw new IOException("internal error encrypting password " + e.getMessage());
        }
    }

    TestProviderContext(Hashtable env, DataTree data) throws AuthenticationException {
        log.setLevel(Level.FINEST);
        this.entries = data;
        this.checkSecurity(env);
        this.environment = env == null ? new Hashtable() : env;
        log.fine("Created TestProviderContext");
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        ModificationItem[] mods = new ModificationItem[attrs.size()];
        NamingEnumeration<? extends Attribute> attObjects = attrs.getAll();
        int i = 0;
        while (attObjects.hasMoreElements()) {
            mods[i++] = new ModificationItem(mod_op, (Attribute)attObjects.nextElement());
        }
        this.modifyAttributes(name, mods);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException("TestProviderContext does not support reading schema (yet)");
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException("TestProviderContext does not support reading schema (yet)");
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException("TestProviderContext does not support reading schema (yet)");
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException("TestProviderContext does not support reading schema (yet)");
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        log.finest("getKeyValueList (" + name.toString() + ")");
        NamingEnumeration<SearchResult> en = this.doSearch(name.toString(), 0, SEARCHING, 0L, 0, false, "(objectClass=*)", attrIds);
        if (!en.hasMoreElements()) {
            return new BasicAttributes();
        }
        SearchResult result = en.next();
        return result.getAttributes();
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        String filter = TestProviderContext.getAttributePresentFilter(matchingAttributes);
        return this.doSearch(name, 2, SEARCHING, 0L, 0, false, filter, attributesToReturn);
    }

    static String getAttributePresentFilter(Attributes matchingAttributes) {
        int numbAtts;
        int n = numbAtts = matchingAttributes == null ? 0 : matchingAttributes.size();
        if (numbAtts == 0) {
            return "(objectClass=*)";
        }
        if (numbAtts == 1) {
            return "(" + (String)matchingAttributes.getIDs().nextElement() + "=*)";
        }
        StringBuffer filterBuffer = new StringBuffer("(&");
        NamingEnumeration<String> atts = matchingAttributes.getIDs();
        while (atts.hasMoreElements()) {
            filterBuffer.append("(").append((String)atts.nextElement()).append("=*)");
        }
        filterBuffer.append(")");
        return filterBuffer.toString();
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(name.toString(), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search(name, filter, null, cons);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.search(name, filter, null, cons);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        String aliasHandling;
        if (filterExpr == null) {
            throw new NamingException("null ldap filter in TestProviderContext search");
        }
        if (filterArgs != null && filterArgs.length > 0) {
            throw new NamingException("filter arguments not implemented in testprovider");
        }
        log.finest("search III (" + name + ") + filter: " + filterExpr);
        if (cons == null) {
            cons = DEFAULT_SEARCH_CONTROLS;
        }
        if ((aliasHandling = (String)this.environment.get("java.naming.ldap.derefAliases")) == null) {
            aliasHandling = "always";
        }
        NamingEnumeration<SearchResult> returnEnum = this.doSearch(name, cons.getSearchScope(), aliasHandling, cons.getCountLimit(), cons.getTimeLimit(), false, filterExpr, cons.getReturningAttributes());
        return returnEnum;
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filterExpr, filterArgs, cons);
    }

    @Override
    public void close() throws NamingException {
        log.finest("close()");
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        log.finest("getNameInNamespace()");
        return this.contextName;
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("TestProviderContext does not support storing java objects");
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("Storing java objects not supported");
    }

    @Override
    public Object lookup(String name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new LdapName(oldName), new LdapName(newName));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new InvalidAttributesException("cannot create directory object without attributes");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new InvalidAttributesException("cannot create directory object without attributes");
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return TestProviderParser.parser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return TestProviderParser.parser;
    }

    public NamingEnumeration list(String name) throws NamingException {
        log.finest("list (" + name.toString() + ")");
        return this.doSearch(name, 1, SEARCHING, 0L, 0, false, "(objectClass=*)", null);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects not supported");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        log.finest("addToEnvironment (" + propName + ": " + propVal.toString());
        if (propName == null) {
            return null;
        }
        if (propVal == null) {
            return this.environment.remove(propName);
        }
        return this.environment.put(propName, propVal);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("TestProviderContext does not support composing names - use LdapName directly");
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("TestProviderContext does not support composing names - use LdapName directly");
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        log.finest("modify Atts of (" + name + ")");
        TreeEntry modifyMe = this.entries.get(name);
        if (modifyMe == null) {
            throw new NameNotFoundException("unable to find entry '" + name + "'");
        }
        block5: for (ModificationItem mod : mods) {
            Attribute modificationAttribute = mod.getAttribute();
            String attributeID = modificationAttribute.getID();
            Attribute current = modifyMe.get(attributeID);
            switch (mod.getModificationOp()) {
                case 1: {
                    Object newVal;
                    NamingEnumeration<?> vals;
                    if (current != null) {
                        vals = modificationAttribute.getAll();
                        while (vals.hasMore()) {
                            newVal = vals.next();
                            if (!current.contains(newVal)) {
                                current.add(newVal);
                                continue;
                            }
                            throw new NamingException("Error adding Attribute " + attributeID + ".  Attribute already has value " + newVal);
                        }
                    } else {
                        current = modificationAttribute;
                    }
                    modifyMe.put(current);
                    continue block5;
                }
                case 2: {
                    modifyMe.put(modificationAttribute);
                    continue block5;
                }
                case 3: {
                    Object newVal;
                    NamingEnumeration<?> vals;
                    if (current != null) {
                        vals = modificationAttribute.getAll();
                        while (vals.hasMore()) {
                            newVal = vals.next();
                            if (current.contains(newVal)) {
                                current.remove(newVal);
                                continue;
                            }
                            throw new NamingException("Error deleting Attribute " + attributeID + "does not have value " + newVal);
                        }
                        if (current.size() > 0) {
                            modifyMe.put(current);
                            continue block5;
                        }
                        modifyMe.remove(current.getID());
                        continue block5;
                    }
                    throw new NamingException("Attribute " + attributeID);
                }
            }
        }
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        log.finest("createSubcontext (" + name + ")");
        this.checkEntry(name, attrs);
        this.entries.addEntry(new TreeEntry((Name)new LdapName(name), attrs));
        return new TestProviderContext(name, this.environment, this.entries);
    }

    protected void checkEntry(String name, Attributes attrs) throws NamingException {
        Attribute oc = attrs.get("objectClass");
        if (oc == null) {
            oc = attrs.get("objectclass");
        }
        if (oc == null) {
            throw new InvalidAttributesException("no object class found for entry: " + name);
        }
        if (oc.contains("person")) {
            if (attrs.get("cn") == null) {
                throw new InvalidAttributesException("person entry does not contain 'cn' attribute");
            }
            if (attrs.get("sn") == null) {
                throw new InvalidAttributesException("person entry does not contain 'sn' attribute");
            }
        }
        if (oc.contains("groupmindEntry")) {
            if (attrs.get("uid") == null) {
                throw new InvalidAttributesException("groupmindEntry entry does not contain 'uid' attribute");
            }
            if (attrs.get("title") == null) {
                throw new InvalidAttributesException("groupmindEntry entry does not contain 'title' attribute");
            }
            if (attrs.get("cn") == null) {
                throw new InvalidAttributesException("groupmindEntry entry does not contain 'cn' attribute");
            }
            String cn = attrs.get("cn").get().toString();
            if (!name.startsWith("cn=" + cn)) {
                throw new InvalidNameException("DAP: error code 64 - value of naming attribute 'cn' (" + cn + ") is not present in entry]; remaining name = " + name);
            }
        }
    }

    public DirContext createSubcontext(TreeEntry newEntry) throws NamingException {
        Name newName = newEntry.getName();
        log.finest("createSubcontext (" + newName + ")");
        this.checkEntry(newEntry.getName().toString(), newEntry);
        this.entries.addEntry(new TreeEntry(newName, newEntry));
        return new TestProviderContext(newName.toString(), this.environment, this.entries);
    }

    public NamingEnumeration<SearchResult> doSearch(String name, int searchScope, String aliasHandling, long sizeLimit, int timeLimit, boolean typesOnly, String filter, String[] attributesToReturn) throws NamingException {
        TestProviderEnumeration<SearchResult> returnEnumeration = new TestProviderEnumeration<SearchResult>();
        if (aliasHandling == null) {
            aliasHandling = (String)this.environment.get("java.naming.ldap.derefAliases");
        }
        TreeEntry entry = this.entries.get(name);
        int baseNameLength = name.length();
        if (baseNameLength > 0) {
            ++baseNameLength;
        }
        if (entry == null) {
            throw new NameNotFoundException(name);
        }
        switch (searchScope) {
            case 0: {
                if (!this.filterMatches(filter, entry)) break;
                returnEnumeration.add(new SearchResult("", (Object)null, (Attributes)entry.clone()));
                break;
            }
            case 1: {
                ArrayList<TreeEntry> children = entry.getChildren();
                for (TreeEntry child : children) {
                    if (!this.filterMatches(filter, child)) continue;
                    String childName = child.getStringName();
                    returnEnumeration.add(new SearchResult(childName.substring(0, childName.length() - baseNameLength), (Object)null, (Attributes)child.clone()));
                }
                break;
            }
            case 2: {
                this.getSubTree(entry, filter, returnEnumeration, baseNameLength);
            }
        }
        if (attributesToReturn != null) {
            this.stripExcessAttributes(returnEnumeration, attributesToReturn);
            this.addOperationalAttributes(returnEnumeration, attributesToReturn);
        }
        return returnEnumeration;
    }

    private void stripExcessAttributes(TestProviderEnumeration<SearchResult> returnEnumeration, String[] attributesToReturn) {
        for (SearchResult item : returnEnumeration) {
            if (attributesToReturn.length == 0 || attributesToReturn[0].equals("1.1")) {
                item.setAttributes(new BasicAttributes());
                continue;
            }
            Attributes existingAtts = item.getAttributes();
            BasicAttributes newAtts = new BasicAttributes();
            for (String returnAtt : attributesToReturn) {
                if (existingAtts.get(returnAtt) == null) continue;
                newAtts.put(existingAtts.get(returnAtt));
            }
            item.setAttributes(newAtts);
        }
    }

    private void addOperationalAttributes(TestProviderEnumeration<SearchResult> returnEnumeration, String[] attributesToReturn) {
        HashSet<String> returnAtts = new HashSet<String>(attributesToReturn.length);
        for (String att : attributesToReturn) {
            returnAtts.add(att.toLowerCase());
        }
        if (returnAtts.contains("namingcontexts")) {
            BasicAttribute namingContext = new BasicAttribute("namingContexts");
            namingContext.add("");
            for (SearchResult item : returnEnumeration) {
                if (item.getName().length() != 0) continue;
                item.getAttributes().put(namingContext);
            }
        }
        if (returnAtts.contains("subschemasubentry")) {
            BasicAttribute subschema = new BasicAttribute("subSchemaSubEntry", "cn=schema");
            for (SearchResult item : returnEnumeration) {
                if (item.getName().length() != 0) continue;
                item.getAttributes().put(subschema);
            }
        }
    }

    private void getSubTree(TreeEntry entry, String filter, TestProviderEnumeration<SearchResult> returnEnumeration, int baseNameLength) {
        if (this.filterMatches(filter, entry)) {
            String name = entry.getStringName();
            name = name.length() <= baseNameLength ? "" : name.substring(0, name.length() - baseNameLength);
            returnEnumeration.add(new SearchResult(name, (Object)null, (Attributes)entry.clone()));
        }
        for (TreeEntry child : entry.getChildren()) {
            this.getSubTree(child, filter, returnEnumeration, baseNameLength);
        }
    }

    public boolean filterMatches(String filter, TreeEntry candidate) {
        if (filter.equalsIgnoreCase("(objectclass=*)")) {
            return true;
        }
        if (this.isSimpleFilter(filter)) {
            return this.evaluateAtomicFilterElement(filter, candidate);
        }
        char operator = filter.charAt(1);
        String residualFilter = filter.substring(2, filter.length() - 1);
        switch (operator) {
            case '&': {
                String[] andComponents = this.splitFilterComponents(residualFilter);
                return this.filterMatches(andComponents[0], candidate) & this.filterMatches(andComponents[1], candidate);
            }
            case '|': {
                String[] orComponents = this.splitFilterComponents(residualFilter);
                return this.filterMatches(orComponents[0], candidate) | this.filterMatches(orComponents[1], candidate);
            }
            case '!': {
                return !this.filterMatches(residualFilter, candidate);
            }
        }
        return this.evaluateAtomicFilterElement(residualFilter, candidate);
    }

    public String[] splitFilterComponents(String filter) {
        int depth = 0;
        for (int i = 0; i < filter.length(); ++i) {
            if (filter.charAt(i) == '(') {
                ++depth;
            }
            if (filter.charAt(i) == ')') {
                --depth;
            }
            if (depth != 0) continue;
            if (i >= filter.length() - 1) {
                return new String[]{filter, ""};
            }
            return new String[]{filter.substring(0, i + 1), filter.substring(i + 1)};
        }
        log.severe("Error parsing search filter: (can't split into components) " + filter);
        return new String[]{null, null};
    }

    public boolean evaluateAtomicFilterElement(String filter, TreeEntry candidate) {
        if (filter.length() == 0) {
            return true;
        }
        int equalPos = filter.indexOf(61);
        String attributeName = filter.substring(1, equalPos);
        String searchValue = filter.substring(equalPos + 1, filter.length() - 1);
        Attribute testAtt = candidate.get(attributeName);
        if (testAtt == null) {
            return false;
        }
        if (searchValue.equals("*")) {
            return true;
        }
        if (testAtt.contains(searchValue)) {
            return true;
        }
        try {
            boolean endsWithStar = searchValue.endsWith("*");
            boolean startsWithStar = searchValue.startsWith("*");
            if (endsWithStar || startsWithStar) {
                String testVal = testAtt.get().toString();
                if (endsWithStar && searchValue.length() > 1) {
                    searchValue = searchValue.substring(0, searchValue.length() - 1);
                }
                if (startsWithStar && searchValue.length() > 1) {
                    searchValue = searchValue.substring(1);
                }
                if (startsWithStar && endsWithStar ? testVal.contains(searchValue) : (startsWithStar ? testVal.endsWith(searchValue) : testVal.startsWith(searchValue))) {
                    return true;
                }
            }
        }
        catch (NamingException e) {
            return false;
        }
        return false;
    }

    private boolean isSimpleFilter(String filter) {
        if (filter.indexOf(38) > -1) {
            return false;
        }
        if (filter.indexOf(124) > -1) {
            return false;
        }
        if (filter.indexOf(33) > -1) {
            return false;
        }
        if (filter.indexOf(61) > 0 && filter.indexOf(61) == filter.lastIndexOf("=")) {
            return true;
        }
        return true;
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        log.finest("destroySubcontext (" + name.toString() + ")");
        if (!this.entries.containsKey(name)) {
            LdapName test = new LdapName(name);
            test.remove(test.size() - 1);
            if (!this.entries.containsKey(test.toString())) {
                throw new NameNotFoundException("unable to find parent entry: " + test.toString());
            }
        }
        this.entries.deleteEntry(name);
    }

    @Override
    public void rename(Name oldName, Name rdn) throws NamingException {
        log.finest("rename (" + oldName + " to " + rdn);
        String oldNameString = oldName.toString();
        if (rdn.size() != 1) {
            throw new NamingException("cannot perform rename operation '" + rdn + "' is not an RDN \n");
        }
        if (oldName.size() < 2) {
            throw new NamingException("cannot rename root node in test provider");
        }
        TreeEntry entry = this.entries.get(oldNameString);
        Rdn myRdn = new Rdn(rdn.get(0));
        entry.put(myRdn.getType(), myRdn.getValue().toString());
        if (entry.getChildren().size() != 0) {
            throw new NamingException("renaming non-leaf entries not supported by test provider");
        }
        String newRDN = rdn.toString();
        Name newName = oldName.getPrefix(oldName.size() - 1).add(newRDN);
        this.entries.renameEntry(oldNameString, newName.toString());
        if (this.entries.get(newName.toString()) == null) {
            throw new NamingException("unable to modify test provider directory");
        }
    }
}

