/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer;

import com.ca.commons.cbutil.CBResourceLoader;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.directory.jxplorer.DataSink;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.broker.DataBrokerQueryInterface;
import com.ca.directory.jxplorer.viewer.HTMLTemplateDisplay;
import com.ca.directory.jxplorer.viewer.PluggableEditor;
import com.ca.directory.jxplorer.viewer.TableAttributeEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AttributeDisplay
extends JTabbedPane
implements DataSink,
Printable {
    public static final int HTMLRENDERER = 1;
    public static final int EDITOR = 2;
    protected JScrollPane viewHolder;
    protected JPanel view;
    protected DataBrokerQueryInterface dataSource;
    protected DXEntry entry = null;
    protected PluggableEditor currentEditor;
    protected HTMLTemplateDisplay templateDisplay;
    protected TableAttributeEditor tableDisplay;
    private Properties printprefs = new Properties();
    protected Hashtable editors = new Hashtable();
    protected Vector activeEditors = new Vector(8);
    protected JFrame owner;
    protected String oldOCSig = null;
    private JMenuBar registerMenu = null;
    private JToolBar registerButtons = null;
    private JTree registerTree = null;
    private JPopupMenu registerTreeMenu = null;
    private JFrame registerJX = null;
    protected ClassLoader myLoader = null;
    protected CBResourceLoader resourceLoader = null;
    public static String PACKAGEPREFIX = "com.ca.directory.jxplorer.viewer.";
    protected static final String NONE = "none";
    private Component printComponent = null;
    protected boolean ignoreChangeEvents = false;
    private static Logger log = Logger.getLogger(AttributeDisplay.class.getName());

    public static void setPackagePrefix(String prefix) {
        PACKAGEPREFIX = prefix;
    }

    public static String getPackagePrefix() {
        return PACKAGEPREFIX;
    }

    public AttributeDisplay(JFrame owner, CBResourceLoader resourceLoader) {
        if (JXConfig.getProperty("plugins.package") != null) {
            AttributeDisplay.setPackagePrefix(JXConfig.getProperty("plugins.package"));
            log.fine("SETTING PLUGIN PREFIX TO: " + PACKAGEPREFIX);
        } else {
            log.fine("PLUGIN PREFIX UNCHANGED: " + PACKAGEPREFIX);
        }
        this.resourceLoader = resourceLoader;
        this.owner = owner;
        this.initHTMLEditor();
        this.initTableEditor();
        this.addEditor(this.templateDisplay);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AttributeDisplay.this.ignoreChangeEvents) {
                    return;
                }
                int index = AttributeDisplay.this.getSelectedIndex();
                if (index >= 0 && AttributeDisplay.this.activeEditors.size() > index && AttributeDisplay.this.activeEditors.get(index) != null) {
                    AttributeDisplay.this.setCurrentEditor((PluggableEditor)AttributeDisplay.this.activeEditors.get(index));
                } else {
                    log.warning("internal error - unable to find editor # " + index + " in Attribute Display");
                }
            }
        });
    }

    public void registerClassLoader(ClassLoader loader) {
        this.myLoader = loader;
        if (this.tableDisplay == null) {
            this.initTableEditor();
        }
        this.tableDisplay.registerClassLoader(loader);
    }

    protected synchronized void initHTMLEditor() {
        if (this.templateDisplay != null) {
            return;
        }
        this.templateDisplay = new HTMLTemplateDisplay(this, this.resourceLoader);
        this.currentEditor = this.templateDisplay;
    }

    protected synchronized void initTableEditor() {
        if (this.tableDisplay != null) {
            return;
        }
        this.tableDisplay = new TableAttributeEditor(this.owner);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        Dimension d = this.printComponent.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.translate(0.0, (double)(-pageIndex) * pageHeight);
        g2.scale(scale, scale);
        this.printComponent.paint(g2);
        return 0;
    }

    public void print() {
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        final Component printMe = this.getPrintComponent();
        Thread worker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (job.printDialog()) {
                    try {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            AttributeDisplay.this.printComponent = printMe;
                            job.print();
                            AttributeDisplay.this.printComponent = null;
                        }
                    }
                    catch (Exception ex) {
                        log.warning("error printing: " + ex);
                    }
                }
            }
        };
        worker.start();
    }

    public void openDocumentURL(String docURL) {
        if (this.templateDisplay == null) {
            this.initHTMLEditor();
        }
        this.templateDisplay.openDocumentURL(docURL);
        this.setCurrentEditor(this.templateDisplay);
    }

    public void displaySpecialEntry(DXEntry entry, DataBrokerQueryInterface ds, String editorName) {
        PluggableEditor ed = this.getEditor(editorName);
        if (ed != null) {
            if (!ed.isUnique()) {
                this.setCurrentEditor(ed);
            } else {
                if (this.currentEditor != ed) {
                    this.addUniqueEditor(ed);
                }
                this.refreshEditors(entry, ds);
                this.oldOCSig = null;
            }
        }
    }

    @Override
    public void displayEntry(DXEntry dxentry, DataBrokerQueryInterface ds) {
        this.dataSource = ds;
        this.entry = dxentry;
        if (this.tableDisplay == null) {
            this.initTableEditor();
        }
        if (this.templateDisplay == null) {
            this.initHTMLEditor();
        }
        if (this.entry == null) {
            if (this.oldOCSig != null) {
                this.clearPluggableEditors();
                if (this.activeEditors.size() == 0) {
                    this.addEditor(this.templateDisplay);
                }
                this.oldOCSig = null;
            }
            this.refreshEditors(null, ds);
        } else {
            this.dataSource = ds;
            ArrayList<String> ocs = this.entry.getOrderedOCs();
            String newOCSig = new String();
            if (ocs != null) {
                for (int i = 0; i < ocs.size(); ++i) {
                    String ocSig = ocs.get(i);
                    if (ocSig == null) continue;
                    newOCSig = newOCSig + ocSig.toString();
                }
            }
            if (!newOCSig.equals(this.oldOCSig)) {
                this.setEditors(this.entry, ds, ocs);
                this.oldOCSig = newOCSig;
            }
            if (this.entry.getStatus() == 1) {
                this.trimNonNewEntryEditors();
                this.suggestPluggableEditor();
            } else if (!this.activeEditors.contains(this.templateDisplay) && !this.currentEditor.isUnique()) {
                this.add(this.templateDisplay, 0);
                if (this.currentEditor != null) {
                    this.setCurrentEditor(this.currentEditor);
                }
            }
            if (!this.activeEditors.contains(this.currentEditor)) {
                this.suggestPluggableEditor();
            }
            this.refreshEditors(this.entry, ds);
        }
    }

    private void trimNonNewEntryEditors() {
        int size = this.activeEditors.size();
        for (int i = size - 1; i >= 0; --i) {
            if (((DataSink)this.activeEditors.get(i)).canCreateEntry()) continue;
            this.remove(i);
        }
        this.suggestTableEditor();
    }

    public boolean suggestPluggableEditor() {
        for (int i = this.activeEditors.size() - 1; i >= 0; --i) {
            PluggableEditor ed = (PluggableEditor)this.activeEditors.get(i);
            if (ed == this.templateDisplay || ed == this.tableDisplay) continue;
            this.setCurrentEditor(ed);
            return true;
        }
        return false;
    }

    public boolean suggestTableEditor() {
        if (this.activeEditors.contains(this.tableDisplay)) {
            this.setCurrentEditor(this.tableDisplay);
            return true;
        }
        return false;
    }

    public boolean suggestHTMLEditor() {
        if (this.activeEditors.contains(this.templateDisplay)) {
            this.setCurrentEditor(this.templateDisplay);
            return true;
        }
        return false;
    }

    protected void setCurrentEditor(PluggableEditor makeCurrent) {
        int index;
        this.currentEditor = makeCurrent;
        if (this.currentEditor != null && this.currentEditor.getDataSink() != null) {
            this.currentEditor.getDataSink().displayEntry(this.entry, this.dataSource);
        }
        if ((index = this.activeEditors.indexOf(makeCurrent)) == -1) {
            this.clearPluggableEditors();
            this.addEditor(makeCurrent);
            this.setSelectedIndex(this.activeEditors.indexOf(makeCurrent));
        } else if (index != this.getSelectedIndex()) {
            this.setSelectedIndex(index);
        }
    }

    protected PluggableEditor getCurrentEditor() {
        return this.currentEditor;
    }

    protected void setEditors(DXEntry entry, DataBrokerQueryInterface ds, ArrayList<String> ocs) {
        try {
            PluggableEditor ed;
            String objectClass;
            int i;
            this.clearPluggableEditors();
            if ("false".equalsIgnoreCase(JXConfig.getProperty("plugins.ignoreUniqueness"))) {
                if (ocs == null) {
                    return;
                }
                int size = ocs.size();
                for (i = 0; i < size; ++i) {
                    objectClass = ocs.get(i);
                    if (objectClass == null || (ed = this.getEditor(objectClass.toString())) == null || !ed.isUnique()) continue;
                    this.addUniqueEditor(ed);
                    this.refreshEditors(entry, ds);
                    this.setCurrentEditor(ed);
                    return;
                }
            } else {
                log.warning("skipping uniqueness test for pluggable editors");
            }
            boolean newEdSet = false;
            for (i = 0; i < ocs.size(); ++i) {
                objectClass = ocs.get(i);
                if (objectClass == null || (ed = this.getEditor(objectClass.toString())) == null) continue;
                this.addEditor(ed);
                if (newEdSet) continue;
                this.setCurrentEditor(ed);
                newEdSet = true;
            }
            try {
                DXAttribute allOCs = entry.getAllObjectClasses();
                if (allOCs != null) {
                    NamingEnumeration<?> vals = allOCs.getAll();
                    while (vals.hasMoreElements()) {
                        PluggableEditor ed2;
                        String ocName;
                        Object oc = vals.nextElement();
                        if (oc == null || ocs.contains(ocName = oc.toString()) || (ed2 = this.getEditor(ocName)) == null) continue;
                        this.addEditor(ed2);
                        if (!ed2.isUnique()) continue;
                        log.warning("WARNING: Illegal unique editor defined for oc: " + ocName + " not allowed - (oc not in primary structural inheritance chain)");
                    }
                }
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "WARNING: non-fatal exception getting object classes for plugin editors. ", e);
            }
            this.addEditor(this.templateDisplay);
            if (entry.getStatus() != 1) {
                this.addEditor(this.tableDisplay);
            }
        }
        catch (Exception e) {
            log.warning("Unexpected Exception in AttributeDisplay\n" + e);
            e.printStackTrace();
        }
    }

    public void clearEditors() {
        this.removeAll();
        this.activeEditors.removeAllElements();
        this.templateDisplay.setToDefault();
        this.addEditor(this.templateDisplay);
        this.tableDisplay.displayEntry(null, null);
        this.addEditor(this.tableDisplay);
    }

    void clearPluggableEditors() {
        this.ignoreChangeEvents = true;
        for (int i = this.activeEditors.size() - 1; i >= 0; --i) {
            PluggableEditor ed = (PluggableEditor)this.activeEditors.get(i);
            if (ed == this.templateDisplay || ed == this.tableDisplay) continue;
            this.remove(i);
        }
        if (!this.activeEditors.contains(this.templateDisplay)) {
            this.addEditor(this.templateDisplay);
        }
        if (!this.activeEditors.contains(this.tableDisplay)) {
            this.addEditor(this.tableDisplay);
        }
        if (this.currentEditor != this.tableDisplay && this.currentEditor != this.templateDisplay) {
            this.suggestHTMLEditor();
        }
        this.ignoreChangeEvents = false;
    }

    public PluggableEditor getUniqueEditor(Attribute oc) {
        try {
            NamingEnumeration<?> values = oc.getAll();
            while (values.hasMoreElements()) {
                String objectClassName = (String)values.nextElement();
                PluggableEditor editor = this.getEditor(objectClassName);
                if (editor == null || !editor.isUnique()) continue;
                return editor;
            }
            return null;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Unable to find unique pluggable editor: ", e);
            return null;
        }
    }

    PluggableEditor getEditor(String ocName) {
        ocName = ocName.toLowerCase();
        Object editorFromHash = this.editors.get(PACKAGEPREFIX + ocName);
        if (editorFromHash != null) {
            return this.castToPluggableEditor(editorFromHash, ocName);
        }
        return this.loadEditorFromDisk(PACKAGEPREFIX + ocName);
    }

    private PluggableEditor castToPluggableEditor(Object rawEditor, String ocName) {
        if (rawEditor == NONE) {
            return null;
        }
        if (rawEditor instanceof PluggableEditor) {
            return (PluggableEditor)rawEditor;
        }
        log.warning("Unexpected Class Cast Error loading plugin editor '" + PACKAGEPREFIX + ocName + "' from hashtable");
        return null;
    }

    PluggableEditor loadEditorFromDisk(String ocName) {
        log.finer("looking for ocName: " + ocName);
        try {
            Class<?> c = this.myLoader.loadClass(ocName);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            PluggableEditor editor = (PluggableEditor)constructor.newInstance(new Object[0]);
            this.editors.put(ocName, editor);
            return editor;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                log.warning("unable to load special editor for: '" + ocName + "' " + e);
                if (JXConfig.debugLevel >= 1) {
                    log.warning("Error loading plugin class: ");
                    ((InvocationTargetException)e).getTargetException().printStackTrace();
                }
            }
            log.log(Level.FINEST, "'Expected' Error loading " + ocName, e);
            this.editors.put(ocName, NONE);
            return null;
        }
    }

    public void registerComponents(JMenuBar menu, JToolBar buttons, JTree tree, JPopupMenu treeMenu, JFrame jxplorer) {
        this.registerMenu = menu;
        this.registerButtons = buttons;
        this.registerTree = tree;
        this.registerTreeMenu = treeMenu;
        this.registerJX = jxplorer;
        for (int i = 0; i < this.activeEditors.size(); ++i) {
            ((PluggableEditor)this.activeEditors.get(i)).registerComponents(menu, buttons, tree, treeMenu, jxplorer);
        }
    }

    void addEditor(PluggableEditor ed) {
        if (!this.activeEditors.contains(ed)) {
            this.add(ed);
            ed.registerComponents(this.registerMenu, this.registerButtons, this.registerTree, this.registerTreeMenu, this.registerJX);
        }
    }

    void addUniqueEditor(PluggableEditor ed) {
        this.ignoreChangeEvents = true;
        this.removeAll();
        this.addEditor(ed);
        this.setCurrentEditor(ed);
        this.ignoreChangeEvents = false;
    }

    public void refreshEditors() {
        if (this.dataSource != null) {
            this.refreshEditors(this.entry, this.dataSource);
        }
    }

    public void refreshEditors(DXEntry entry, DataBrokerQueryInterface ds) {
        if (this.currentEditor != null) {
            this.entry = entry;
            this.dataSource = ds;
            this.currentEditor.getDataSink().displayEntry(entry, ds);
            JComponent display = this.currentEditor.getDisplayComponent();
            if (this.indexOfComponent(display) == -1) {
                String title = this.currentEditor.getName();
                ImageIcon icon = this.currentEditor.getIcon();
                String toolTip = this.currentEditor.getToolTip();
                int index = this.getSelectedIndex();
                super.remove(index);
                super.insertTab(title, icon, display, toolTip, index);
                super.setSelectedIndex(index);
            }
        } else {
            log.warning("internal error - no editor available in AttributeDisplay");
        }
    }

    public Component getPrintComponent() {
        return this.currentEditor.getPrintComponent();
    }

    @Override
    public boolean canCreateEntry() {
        return true;
    }

    public void add(PluggableEditor ed) {
        this.add(ed, this.getTabCount());
    }

    public void add(PluggableEditor ed, int index) {
        this.insertTab(ed.getName(), ed.getIcon(), ed.getDisplayComponent(), ed.getToolTip(), index);
        this.activeEditors.add(index, ed);
    }

    @Override
    public void remove(int index) {
        if (this.activeEditors.size() == 0) {
            return;
        }
        PluggableEditor ed = (PluggableEditor)this.activeEditors.remove(index);
        ed.unload();
        super.remove(index);
    }

    @Override
    public void removeAll() {
        int size = this.activeEditors.size();
        for (int i = size - 1; i >= 0; --i) {
            this.remove(i);
        }
        super.removeAll();
    }
}

