/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.LdifEntryType;
import com.ca.commons.naming.LdifModifyAttribute;
import com.ca.commons.naming.LdifModifyType;
import com.ca.commons.naming.LdifUtility;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;

public class LdifEntry
extends DXEntry {
    LdifEntryType changeType = LdifEntryType.normal;
    private static Logger log = Logger.getLogger(LdifEntryType.class.getName());
    public static final String DELETEOLDRDN = "deleteoldrdn";
    public static final String NEWSUPERIOR = "newsuperior";
    public static final String NEWRDN = "newrdn";
    public static final String LINENO = "linenumber";
    public static final String CHANGE_TYPE_ATTRIBUTE = "changetype";
    public static final String ERROR = "error";

    public LdifEntry() {
        this.commonInit();
    }

    public LdifEntry(DN dn) {
        super(dn);
        this.commonInit();
    }

    public LdifEntry(String stringName, Attribute[] atts) {
        super(LdifEntry.makeAtts(atts), new DN(stringName));
        this.commonInit();
    }

    public LdifEntry(DXAttributes baseAttributes) {
        this.basicCopy(baseAttributes);
        this.commonInit();
    }

    public LdifEntry(DXAttributes baseAttributes, DN dn) {
        this.basicCopy(baseAttributes);
        this.dn = dn;
        this.commonInit();
    }

    public LdifEntry(DXEntry baseEntry) {
        this.basicCopy(baseEntry);
        this.dn = baseEntry.dn;
        this.commonInit();
    }

    void basicCopy(DXAttributes baseAttributes) {
        this.id = ID++;
        this.atts = baseAttributes.atts;
        this.must = baseAttributes.must;
        if (this.atts.containsKey(CHANGE_TYPE_ATTRIBUTE)) {
            try {
                String val = ((DXAttribute)this.atts.get(CHANGE_TYPE_ATTRIBUTE)).get().toString();
                for (LdifEntryType entryType : LdifEntryType.values()) {
                    if (!val.equals(entryType.toString())) continue;
                    this.setChangeType(entryType);
                    System.out.println("SET TO: " + (Object)((Object)entryType));
                    return;
                }
            }
            catch (NamingException e) {
                log.warning("Unexpected internal error setting LDIF change entry type " + e.getMessage());
            }
        }
    }

    private void commonInit() {
        this.must.add(CHANGE_TYPE_ATTRIBUTE);
    }

    public void setChangeType(LdifEntryType type) {
        this.changeType = type;
        if (type != LdifEntryType.normal) {
            this.put(new BasicAttribute(CHANGE_TYPE_ATTRIBUTE, type.toString()));
        }
    }

    public LdifEntryType getChangeType() {
        return this.changeType;
    }

    @Override
    public String toString() {
        try {
            StringBuffer ldifData = new StringBuffer(1024);
            ldifData.append("dn" + LdifUtility.ldifEncode((Object)this.getStringName(), 2) + "\n");
            if (this.changeType != LdifEntryType.normal) {
                ldifData.append("changetype: ").append(this.changeType.toString()).append("\n");
            }
            switch (this.changeType) {
                case normal: 
                case add: {
                    ArrayList<String> objectClasses = this.getOrderedOCs();
                    if (objectClasses == null) {
                        return "objectclass:  error - no object class found";
                    }
                    for (String ocValue : objectClasses) {
                        ldifData.append(LdifUtility.ldifEncode(this.getAllObjectClasses().getID(), ocValue));
                    }
                    for (DXAttribute att : this.getAttArrayList()) {
                        if (att.isObjectClass() || att.getID().equals(CHANGE_TYPE_ATTRIBUTE)) continue;
                        for (Object value : att.getValues()) {
                            ldifData.append(LdifUtility.ldifEncode(att.getID(), value));
                        }
                    }
                    break;
                }
                case delete: {
                    break;
                }
                case modify: {
                    LdifModifyAttribute ldapAtt;
                    for (DXAttribute att : this.getAttArrayList()) {
                        if (att.getID().equals(CHANGE_TYPE_ATTRIBUTE)) continue;
                        ldapAtt = (LdifModifyAttribute)att;
                        if (ldapAtt.modifyType != LdifModifyType.replace) continue;
                        ldifData.append(ldapAtt.toString());
                    }
                    for (DXAttribute att : this.getAttArrayList()) {
                        if (att.getID().equals(CHANGE_TYPE_ATTRIBUTE)) continue;
                        ldapAtt = (LdifModifyAttribute)att;
                        if (ldapAtt.modifyType != LdifModifyType.add) continue;
                        ldifData.append(ldapAtt.toString());
                    }
                    for (DXAttribute att : this.getAttArrayList()) {
                        if (att.getID().equals(CHANGE_TYPE_ATTRIBUTE)) continue;
                        ldapAtt = (LdifModifyAttribute)att;
                        if (ldapAtt.modifyType != LdifModifyType.delete) continue;
                        ldifData.append(ldapAtt.toString());
                    }
                    break;
                }
                case moddn: 
                case modrdn: {
                    DXAttribute rdn = this.get(NEWRDN);
                    DXAttribute deleteOldRdn = this.get(DELETEOLDRDN);
                    DXAttribute newSuperior = this.get(NEWSUPERIOR);
                    if (rdn == null) {
                        ldifData.append("error: no 'newrdn' attribute found");
                        break;
                    }
                    if (deleteOldRdn == null) {
                        ldifData.append("error: no 'deleteoldrdn' attribute found");
                        break;
                    }
                    ldifData.append(LdifUtility.ldifEncode(rdn.getID(), rdn.get()));
                    ldifData.append(LdifUtility.ldifEncode(deleteOldRdn.getID(), deleteOldRdn.get()));
                    if (newSuperior == null) break;
                    ldifData.append(LdifUtility.ldifEncode(newSuperior.getID(), newSuperior.get()));
                }
            }
            ldifData.append("\n");
            return ldifData.toString();
        }
        catch (ClassCastException e) {
            log.warning("error trying to write out LDIF entry '" + this.dn + "'; LDIF change attribute not found when expected " + e.getMessage());
            return "";
        }
        catch (NamingException e) {
            log.warning("unexpected naming exception trying to write out LDIF entry '" + this.dn + "' " + e.getMessage());
            return "";
        }
    }
}

