/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class CBFileChooserButton
extends CBButton
implements ActionListener {
    static String globalLastDirectory = "";
    String localLastDirectory = "";
    boolean useLocal = false;
    JTextComponent myText;
    Component parent;
    FileFilter filter = null;
    int fileSelectionMode = 2;

    public CBFileChooserButton(JTextComponent text, Component GUIparent) {
        this(text, GUIparent, "File");
    }

    public CBFileChooserButton(JTextComponent text, Component GUIparent, String buttonName) {
        this(text, GUIparent, buttonName, "");
    }

    public CBFileChooserButton(JTextComponent text, Component GUIparent, String buttonName, String tooltip) {
        super(buttonName, tooltip, new ImageIcon("open.gif"));
        this.myText = text;
        this.parent = GUIparent;
        this.addActionListener(this);
    }

    public void setLocalDirectoryUse(boolean state) {
        this.useLocal = state;
    }

    public boolean getLocalDirectoryUse() {
        return this.useLocal;
    }

    public static void setGlobalDirectory(String dirString) {
        globalLastDirectory = dirString;
    }

    public void setLocalDirectory(String dirString) {
        this.localLastDirectory = dirString;
        this.useLocal = true;
    }

    public void setStartingDirectory(String dirString) {
        if (this.useLocal) {
            this.localLastDirectory = dirString;
        } else {
            CBFileChooserButton.setGlobalDirectory(dirString);
        }
    }

    public String getStartingDirectory() {
        return this.useLocal ? this.localLastDirectory : globalLastDirectory;
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = mode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option;
        String lastDirectory = this.useLocal ? this.localLastDirectory : globalLastDirectory;
        try {
            if (!new File(lastDirectory).exists()) {
                lastDirectory = null;
            }
        }
        catch (Exception ex) {
            lastDirectory = null;
        }
        JFileChooser chooser = new JFileChooser(lastDirectory);
        chooser.setFileSelectionMode(this.fileSelectionMode);
        if (this.filter != null) {
            chooser.addChoosableFileFilter(this.filter);
        }
        if ((option = chooser.showOpenDialog(this.parent)) == 0) {
            this.setStartingDirectory(chooser.getSelectedFile().getParent());
            File readFile = chooser.getSelectedFile();
            this.myText.setText(readFile.toString());
        }
    }
}

