pub use bindings::*;

#[cfg(feature = "regenerate-bindings")]
pub mod bindings {
    include!(concat!(env!("OUT_DIR"), "/igzip_lib.rs"));
}

// copy from target dir when updating bindings
#[cfg(not(feature = "regenerate-bindings"))]
pub mod bindings {
    /* automatically generated by rust-bindgen 0.69.4 */

    pub const _STDINT_H: u32 = 1;
    pub const _FEATURES_H: u32 = 1;
    pub const _DEFAULT_SOURCE: u32 = 1;
    pub const __GLIBC_USE_ISOC2X: u32 = 0;
    pub const __USE_ISOC11: u32 = 1;
    pub const __USE_ISOC99: u32 = 1;
    pub const __USE_ISOC95: u32 = 1;
    pub const __USE_POSIX_IMPLICITLY: u32 = 1;
    pub const _POSIX_SOURCE: u32 = 1;
    pub const _POSIX_C_SOURCE: u32 = 200809;
    pub const __USE_POSIX: u32 = 1;
    pub const __USE_POSIX2: u32 = 1;
    pub const __USE_POSIX199309: u32 = 1;
    pub const __USE_POSIX199506: u32 = 1;
    pub const __USE_XOPEN2K: u32 = 1;
    pub const __USE_XOPEN2K8: u32 = 1;
    pub const _ATFILE_SOURCE: u32 = 1;
    pub const __WORDSIZE: u32 = 64;
    pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
    pub const __SYSCALL_WORDSIZE: u32 = 64;
    pub const __TIMESIZE: u32 = 64;
    pub const __USE_TIME_BITS64: u32 = 1;
    pub const __USE_MISC: u32 = 1;
    pub const __USE_ATFILE: u32 = 1;
    pub const __USE_FORTIFY_LEVEL: u32 = 0;
    pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
    pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
    pub const __GLIBC_USE_C2X_STRTOL: u32 = 0;
    pub const _STDC_PREDEF_H: u32 = 1;
    pub const __STDC_IEC_559__: u32 = 1;
    pub const __STDC_IEC_60559_BFP__: u32 = 201404;
    pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
    pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
    pub const __STDC_ISO_10646__: u32 = 201706;
    pub const __GNU_LIBRARY__: u32 = 6;
    pub const __GLIBC__: u32 = 2;
    pub const __GLIBC_MINOR__: u32 = 39;
    pub const _SYS_CDEFS_H: u32 = 1;
    pub const __glibc_c99_flexarr_available: u32 = 1;
    pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
    pub const __HAVE_GENERIC_SELECTION: u32 = 1;
    pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
    pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
    pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
    pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
    pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
    pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
    pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
    pub const _BITS_TYPES_H: u32 = 1;
    pub const _BITS_TYPESIZES_H: u32 = 1;
    pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
    pub const __INO_T_MATCHES_INO64_T: u32 = 1;
    pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
    pub const __STATFS_MATCHES_STATFS64: u32 = 1;
    pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
    pub const __FD_SETSIZE: u32 = 1024;
    pub const _BITS_TIME64_H: u32 = 1;
    pub const _BITS_WCHAR_H: u32 = 1;
    pub const _BITS_STDINT_INTN_H: u32 = 1;
    pub const _BITS_STDINT_UINTN_H: u32 = 1;
    pub const _BITS_STDINT_LEAST_H: u32 = 1;
    pub const INT8_MIN: i32 = -128;
    pub const INT16_MIN: i32 = -32768;
    pub const INT32_MIN: i32 = -2147483648;
    pub const INT8_MAX: u32 = 127;
    pub const INT16_MAX: u32 = 32767;
    pub const INT32_MAX: u32 = 2147483647;
    pub const UINT8_MAX: u32 = 255;
    pub const UINT16_MAX: u32 = 65535;
    pub const UINT32_MAX: u32 = 4294967295;
    pub const INT_LEAST8_MIN: i32 = -128;
    pub const INT_LEAST16_MIN: i32 = -32768;
    pub const INT_LEAST32_MIN: i32 = -2147483648;
    pub const INT_LEAST8_MAX: u32 = 127;
    pub const INT_LEAST16_MAX: u32 = 32767;
    pub const INT_LEAST32_MAX: u32 = 2147483647;
    pub const UINT_LEAST8_MAX: u32 = 255;
    pub const UINT_LEAST16_MAX: u32 = 65535;
    pub const UINT_LEAST32_MAX: u32 = 4294967295;
    pub const INT_FAST8_MIN: i32 = -128;
    pub const INT_FAST16_MIN: i64 = -9223372036854775808;
    pub const INT_FAST32_MIN: i64 = -9223372036854775808;
    pub const INT_FAST8_MAX: u32 = 127;
    pub const INT_FAST16_MAX: u64 = 9223372036854775807;
    pub const INT_FAST32_MAX: u64 = 9223372036854775807;
    pub const UINT_FAST8_MAX: u32 = 255;
    pub const UINT_FAST16_MAX: i32 = -1;
    pub const UINT_FAST32_MAX: i32 = -1;
    pub const INTPTR_MIN: i64 = -9223372036854775808;
    pub const INTPTR_MAX: u64 = 9223372036854775807;
    pub const UINTPTR_MAX: i32 = -1;
    pub const PTRDIFF_MIN: i64 = -9223372036854775808;
    pub const PTRDIFF_MAX: u64 = 9223372036854775807;
    pub const SIG_ATOMIC_MIN: i32 = -2147483648;
    pub const SIG_ATOMIC_MAX: u32 = 2147483647;
    pub const SIZE_MAX: i32 = -1;
    pub const WINT_MIN: u32 = 0;
    pub const WINT_MAX: u32 = 4294967295;
    pub const IGZIP_K: u32 = 1024;
    pub const ISAL_DEF_MAX_HDR_SIZE: u32 = 328;
    pub const ISAL_DEF_MAX_CODE_LEN: u32 = 15;
    pub const ISAL_DEF_HIST_SIZE: u32 = 32768;
    pub const ISAL_DEF_MAX_HIST_BITS: u32 = 15;
    pub const ISAL_DEF_MAX_MATCH: u32 = 258;
    pub const ISAL_DEF_MIN_MATCH: u32 = 3;
    pub const ISAL_DEF_LIT_SYMBOLS: u32 = 257;
    pub const ISAL_DEF_LEN_SYMBOLS: u32 = 29;
    pub const ISAL_DEF_DIST_SYMBOLS: u32 = 30;
    pub const ISAL_DEF_LIT_LEN_SYMBOLS: u32 = 286;
    pub const ISAL_LOOK_AHEAD: u32 = 288;
    pub const IGZIP_HIST_SIZE: u32 = 32768;
    pub const IGZIP_HASH8K_HASH_SIZE: u32 = 8192;
    pub const IGZIP_HASH_HIST_SIZE: u32 = 32768;
    pub const IGZIP_HASH_MAP_HASH_SIZE: u32 = 32768;
    pub const IGZIP_LVL0_HASH_SIZE: u32 = 8192;
    pub const IGZIP_LVL1_HASH_SIZE: u32 = 8192;
    pub const IGZIP_LVL2_HASH_SIZE: u32 = 32768;
    pub const IGZIP_LVL3_HASH_SIZE: u32 = 32768;
    pub const IGZIP_HUFFTABLE_CUSTOM: u32 = 0;
    pub const IGZIP_HUFFTABLE_DEFAULT: u32 = 1;
    pub const IGZIP_HUFFTABLE_STATIC: u32 = 2;
    pub const NO_FLUSH: u32 = 0;
    pub const SYNC_FLUSH: u32 = 1;
    pub const FULL_FLUSH: u32 = 2;
    pub const FINISH_FLUSH: u32 = 0;
    pub const IGZIP_DEFLATE: u32 = 0;
    pub const IGZIP_GZIP: u32 = 1;
    pub const IGZIP_GZIP_NO_HDR: u32 = 2;
    pub const IGZIP_ZLIB: u32 = 3;
    pub const IGZIP_ZLIB_NO_HDR: u32 = 4;
    pub const COMP_OK: u32 = 0;
    pub const INVALID_FLUSH: i32 = -7;
    pub const INVALID_PARAM: i32 = -8;
    pub const STATELESS_OVERFLOW: i32 = -1;
    pub const ISAL_INVALID_OPERATION: i32 = -9;
    pub const ISAL_INVALID_STATE: i32 = -3;
    pub const ISAL_INVALID_LEVEL: i32 = -4;
    pub const ISAL_INVALID_LEVEL_BUF: i32 = -5;
    pub const ISAL_DECODE_LONG_BITS: u32 = 12;
    pub const ISAL_DECODE_SHORT_BITS: u32 = 10;
    pub const ISAL_DEFLATE: u32 = 0;
    pub const ISAL_GZIP: u32 = 1;
    pub const ISAL_GZIP_NO_HDR: u32 = 2;
    pub const ISAL_ZLIB: u32 = 3;
    pub const ISAL_ZLIB_NO_HDR: u32 = 4;
    pub const ISAL_ZLIB_NO_HDR_VER: u32 = 5;
    pub const ISAL_GZIP_NO_HDR_VER: u32 = 6;
    pub const ISAL_DECOMP_OK: u32 = 0;
    pub const ISAL_END_INPUT: u32 = 1;
    pub const ISAL_OUT_OVERFLOW: u32 = 2;
    pub const ISAL_NAME_OVERFLOW: u32 = 3;
    pub const ISAL_COMMENT_OVERFLOW: u32 = 4;
    pub const ISAL_EXTRA_OVERFLOW: u32 = 5;
    pub const ISAL_NEED_DICT: u32 = 6;
    pub const ISAL_INVALID_BLOCK: i32 = -1;
    pub const ISAL_INVALID_SYMBOL: i32 = -2;
    pub const ISAL_INVALID_LOOKBACK: i32 = -3;
    pub const ISAL_INVALID_WRAPPER: i32 = -4;
    pub const ISAL_UNSUPPORTED_METHOD: i32 = -5;
    pub const ISAL_INCORRECT_CHECKSUM: i32 = -6;
    pub const ISAL_DEF_MIN_LEVEL: u32 = 0;
    pub const ISAL_DEF_MAX_LEVEL: u32 = 3;
    pub const ISAL_DEF_LVL0_REQ: u32 = 0;
    pub const ISAL_DEF_LVL1_REQ: u32 = 20480;
    pub const ISAL_DEF_LVL1_TOKEN_SIZE: u32 = 4;
    pub const ISAL_DEF_LVL2_REQ: u32 = 69632;
    pub const ISAL_DEF_LVL2_TOKEN_SIZE: u32 = 4;
    pub const ISAL_DEF_LVL3_REQ: u32 = 86016;
    pub const ISAL_DEF_LVL3_TOKEN_SIZE: u32 = 4;
    pub const ISAL_DEF_LVL0_MIN: u32 = 0;
    pub const ISAL_DEF_LVL0_SMALL: u32 = 0;
    pub const ISAL_DEF_LVL0_MEDIUM: u32 = 0;
    pub const ISAL_DEF_LVL0_LARGE: u32 = 0;
    pub const ISAL_DEF_LVL0_EXTRA_LARGE: u32 = 0;
    pub const ISAL_DEF_LVL0_DEFAULT: u32 = 0;
    pub const ISAL_DEF_LVL1_MIN: u32 = 24576;
    pub const ISAL_DEF_LVL1_SMALL: u32 = 86016;
    pub const ISAL_DEF_LVL1_MEDIUM: u32 = 151552;
    pub const ISAL_DEF_LVL1_LARGE: u32 = 282624;
    pub const ISAL_DEF_LVL1_EXTRA_LARGE: u32 = 544768;
    pub const ISAL_DEF_LVL1_DEFAULT: u32 = 282624;
    pub const ISAL_DEF_LVL2_MIN: u32 = 73728;
    pub const ISAL_DEF_LVL2_SMALL: u32 = 135168;
    pub const ISAL_DEF_LVL2_MEDIUM: u32 = 200704;
    pub const ISAL_DEF_LVL2_LARGE: u32 = 331776;
    pub const ISAL_DEF_LVL2_EXTRA_LARGE: u32 = 593920;
    pub const ISAL_DEF_LVL2_DEFAULT: u32 = 331776;
    pub const ISAL_DEF_LVL3_MIN: u32 = 90112;
    pub const ISAL_DEF_LVL3_SMALL: u32 = 151552;
    pub const ISAL_DEF_LVL3_MEDIUM: u32 = 217088;
    pub const ISAL_DEF_LVL3_LARGE: u32 = 348160;
    pub const ISAL_DEF_LVL3_EXTRA_LARGE: u32 = 610304;
    pub const ISAL_DEF_LVL3_DEFAULT: u32 = 348160;
    pub const IGZIP_NO_HIST: u32 = 0;
    pub const IGZIP_HIST: u32 = 1;
    pub const IGZIP_DICT_HIST: u32 = 2;
    pub const IGZIP_DICT_HASH_SET: u32 = 3;
    pub const ISAL_L_REM: u32 = 9;
    pub const ISAL_S_REM: u32 = 5;
    pub const ISAL_L_DUP: u32 = 502;
    pub const ISAL_S_DUP: u32 = 26;
    pub const ISAL_L_UNUSED: u32 = 465;
    pub const ISAL_S_UNUSED: u32 = 21;
    pub const ISAL_L_SIZE: u32 = 1253;
    pub const ISAL_S_SIZE: u32 = 77;
    pub const ISAL_HUFF_CODE_LARGE_LONG_ALIGNED: u32 = 1264;
    pub const ISAL_HUFF_CODE_SMALL_LONG_ALIGNED: u32 = 80;
    pub type __u_char = ::std::os::raw::c_uchar;
    pub type __u_short = ::std::os::raw::c_ushort;
    pub type __u_int = ::std::os::raw::c_uint;
    pub type __u_long = ::std::os::raw::c_ulong;
    pub type __int8_t = ::std::os::raw::c_schar;
    pub type __uint8_t = ::std::os::raw::c_uchar;
    pub type __int16_t = ::std::os::raw::c_short;
    pub type __uint16_t = ::std::os::raw::c_ushort;
    pub type __int32_t = ::std::os::raw::c_int;
    pub type __uint32_t = ::std::os::raw::c_uint;
    pub type __int64_t = ::std::os::raw::c_long;
    pub type __uint64_t = ::std::os::raw::c_ulong;
    pub type __int_least8_t = __int8_t;
    pub type __uint_least8_t = __uint8_t;
    pub type __int_least16_t = __int16_t;
    pub type __uint_least16_t = __uint16_t;
    pub type __int_least32_t = __int32_t;
    pub type __uint_least32_t = __uint32_t;
    pub type __int_least64_t = __int64_t;
    pub type __uint_least64_t = __uint64_t;
    pub type __quad_t = ::std::os::raw::c_long;
    pub type __u_quad_t = ::std::os::raw::c_ulong;
    pub type __intmax_t = ::std::os::raw::c_long;
    pub type __uintmax_t = ::std::os::raw::c_ulong;
    pub type __dev_t = ::std::os::raw::c_ulong;
    pub type __uid_t = ::std::os::raw::c_uint;
    pub type __gid_t = ::std::os::raw::c_uint;
    pub type __ino_t = ::std::os::raw::c_ulong;
    pub type __ino64_t = ::std::os::raw::c_ulong;
    pub type __mode_t = ::std::os::raw::c_uint;
    pub type __nlink_t = ::std::os::raw::c_ulong;
    pub type __off64_t = ::std::os::raw::c_long;
    pub type __pid_t = ::std::os::raw::c_int;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct __fsid_t {
        pub __val: [::std::os::raw::c_int; 2usize],
    }
    #[test]
    fn bindgen_test_layout___fsid_t() {
        const UNINIT: ::std::mem::MaybeUninit<__fsid_t> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<__fsid_t>(),
            8usize,
            concat!("Size of: ", stringify!(__fsid_t))
        );
        assert_eq!(
            ::std::mem::align_of::<__fsid_t>(),
            4usize,
            concat!("Alignment of ", stringify!(__fsid_t))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).__val) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(__fsid_t),
                "::",
                stringify!(__val)
            )
        );
    }
    pub type __clock_t = ::std::os::raw::c_long;
    pub type __rlim_t = ::std::os::raw::c_ulong;
    pub type __rlim64_t = ::std::os::raw::c_ulong;
    pub type __id_t = ::std::os::raw::c_uint;
    pub type __useconds_t = ::std::os::raw::c_uint;
    pub type __suseconds_t = ::std::os::raw::c_long;
    pub type __suseconds64_t = ::std::os::raw::c_long;
    pub type __daddr_t = ::std::os::raw::c_int;
    pub type __key_t = ::std::os::raw::c_int;
    pub type __clockid_t = ::std::os::raw::c_int;
    pub type __timer_t = *mut ::std::os::raw::c_void;
    pub type __blksize_t = ::std::os::raw::c_long;
    pub type __blkcnt_t = ::std::os::raw::c_long;
    pub type __blkcnt64_t = ::std::os::raw::c_long;
    pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
    pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
    pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
    pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
    pub type __fsword_t = ::std::os::raw::c_long;
    pub type __ssize_t = ::std::os::raw::c_long;
    pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
    pub type __loff_t = __off64_t;
    pub type __caddr_t = *mut ::std::os::raw::c_char;
    pub type __intptr_t = ::std::os::raw::c_long;
    pub type __socklen_t = ::std::os::raw::c_uint;
    pub type __sig_atomic_t = ::std::os::raw::c_int;
    pub type int_least8_t = __int_least8_t;
    pub type int_least16_t = __int_least16_t;
    pub type int_least32_t = __int_least32_t;
    pub type int_least64_t = __int_least64_t;
    pub type uint_least8_t = __uint_least8_t;
    pub type uint_least16_t = __uint_least16_t;
    pub type uint_least32_t = __uint_least32_t;
    pub type uint_least64_t = __uint_least64_t;
    pub type int_fast8_t = ::std::os::raw::c_schar;
    pub type int_fast16_t = ::std::os::raw::c_long;
    pub type int_fast32_t = ::std::os::raw::c_long;
    pub type int_fast64_t = ::std::os::raw::c_long;
    pub type uint_fast8_t = ::std::os::raw::c_uchar;
    pub type uint_fast16_t = ::std::os::raw::c_ulong;
    pub type uint_fast32_t = ::std::os::raw::c_ulong;
    pub type uint_fast64_t = ::std::os::raw::c_ulong;
    pub type intmax_t = __intmax_t;
    pub type uintmax_t = __uintmax_t;
    pub const IGZIP_DIST_TABLE_SIZE: _bindgen_ty_1 = 2;
    pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
    pub const IGZIP_DECODE_OFFSET: _bindgen_ty_2 = 0;
    pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
    pub const IGZIP_LEN_TABLE_SIZE: _bindgen_ty_3 = 256;
    pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
    pub const IGZIP_LIT_TABLE_SIZE: _bindgen_ty_4 = 257;
    pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
    #[doc = "!< Header to be written"]
    pub const isal_zstate_state_ZSTATE_NEW_HDR: isal_zstate_state = 0;
    #[doc = "!< Header state"]
    pub const isal_zstate_state_ZSTATE_HDR: isal_zstate_state = 1;
    #[doc = "!< Header to be created"]
    pub const isal_zstate_state_ZSTATE_CREATE_HDR: isal_zstate_state = 2;
    #[doc = "!< Body state"]
    pub const isal_zstate_state_ZSTATE_BODY: isal_zstate_state = 3;
    #[doc = "!< Flush buffer"]
    pub const isal_zstate_state_ZSTATE_FLUSH_READ_BUFFER: isal_zstate_state = 4;
    pub const isal_zstate_state_ZSTATE_FLUSH_ICF_BUFFER: isal_zstate_state = 5;
    pub const isal_zstate_state_ZSTATE_TYPE0_HDR: isal_zstate_state = 6;
    #[doc = "!< Type0 block body to be written"]
    pub const isal_zstate_state_ZSTATE_TYPE0_BODY: isal_zstate_state = 7;
    #[doc = "!< Write sync flush block"]
    pub const isal_zstate_state_ZSTATE_SYNC_FLUSH: isal_zstate_state = 8;
    #[doc = "!< Flush bitbuf"]
    pub const isal_zstate_state_ZSTATE_FLUSH_WRITE_BUFFER: isal_zstate_state = 9;
    #[doc = "!< Trailer state"]
    pub const isal_zstate_state_ZSTATE_TRL: isal_zstate_state = 10;
    #[doc = "!< End state"]
    pub const isal_zstate_state_ZSTATE_END: isal_zstate_state = 11;
    #[doc = "!< Temporary Header to be written"]
    pub const isal_zstate_state_ZSTATE_TMP_NEW_HDR: isal_zstate_state = 12;
    #[doc = "!< Temporary Header state"]
    pub const isal_zstate_state_ZSTATE_TMP_HDR: isal_zstate_state = 13;
    #[doc = "!< Temporary Header to be created state"]
    pub const isal_zstate_state_ZSTATE_TMP_CREATE_HDR: isal_zstate_state = 14;
    #[doc = "!< Temporary Body state"]
    pub const isal_zstate_state_ZSTATE_TMP_BODY: isal_zstate_state = 15;
    #[doc = "!< Flush buffer"]
    pub const isal_zstate_state_ZSTATE_TMP_FLUSH_READ_BUFFER: isal_zstate_state = 16;
    pub const isal_zstate_state_ZSTATE_TMP_FLUSH_ICF_BUFFER: isal_zstate_state = 17;
    pub const isal_zstate_state_ZSTATE_TMP_TYPE0_HDR: isal_zstate_state = 18;
    #[doc = "!< Temporary Type0 block body to be written"]
    pub const isal_zstate_state_ZSTATE_TMP_TYPE0_BODY: isal_zstate_state = 19;
    #[doc = "!< Write sync flush block"]
    pub const isal_zstate_state_ZSTATE_TMP_SYNC_FLUSH: isal_zstate_state = 20;
    #[doc = "!< Flush bitbuf"]
    pub const isal_zstate_state_ZSTATE_TMP_FLUSH_WRITE_BUFFER: isal_zstate_state = 21;
    #[doc = "!< Temporary Trailer state"]
    pub const isal_zstate_state_ZSTATE_TMP_TRL: isal_zstate_state = 22;
    #[doc = "!< Temporary End state"]
    pub const isal_zstate_state_ZSTATE_TMP_END: isal_zstate_state = 23;
    #[doc = "  @enum isal_zstate_state\n  @brief Compression State please note ZSTATE_TRL only applies for GZIP compression"]
    pub type isal_zstate_state = ::std::os::raw::c_uint;
    pub const isal_block_state_ISAL_BLOCK_NEW_HDR: isal_block_state = 0;
    pub const isal_block_state_ISAL_BLOCK_HDR: isal_block_state = 1;
    pub const isal_block_state_ISAL_BLOCK_TYPE0: isal_block_state = 2;
    pub const isal_block_state_ISAL_BLOCK_CODED: isal_block_state = 3;
    pub const isal_block_state_ISAL_BLOCK_INPUT_DONE: isal_block_state = 4;
    pub const isal_block_state_ISAL_BLOCK_FINISH: isal_block_state = 5;
    pub const isal_block_state_ISAL_GZIP_EXTRA_LEN: isal_block_state = 6;
    pub const isal_block_state_ISAL_GZIP_EXTRA: isal_block_state = 7;
    pub const isal_block_state_ISAL_GZIP_NAME: isal_block_state = 8;
    pub const isal_block_state_ISAL_GZIP_COMMENT: isal_block_state = 9;
    pub const isal_block_state_ISAL_GZIP_HCRC: isal_block_state = 10;
    pub const isal_block_state_ISAL_ZLIB_DICT: isal_block_state = 11;
    pub const isal_block_state_ISAL_CHECKSUM_CHECK: isal_block_state = 12;
    pub type isal_block_state = ::std::os::raw::c_uint;
    #[doc = "/\n/** @brief Holds histogram of deflate symbols"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct isal_huff_histogram {
        #[doc = "!< Histogram of Literal/Len symbols\n!< seen"]
        pub lit_len_histogram: [u64; 286usize],
        #[doc = "!< Histogram of Distance Symbols seen"]
        pub dist_histogram: [u64; 30usize],
        #[doc = "!< Tmp space used as a hash table"]
        pub hash_table: [u16; 8192usize],
    }
    #[test]
    fn bindgen_test_layout_isal_huff_histogram() {
        const UNINIT: ::std::mem::MaybeUninit<isal_huff_histogram> =
            ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<isal_huff_histogram>(),
            18912usize,
            concat!("Size of: ", stringify!(isal_huff_histogram))
        );
        assert_eq!(
            ::std::mem::align_of::<isal_huff_histogram>(),
            8usize,
            concat!("Alignment of ", stringify!(isal_huff_histogram))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).lit_len_histogram) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_huff_histogram),
                "::",
                stringify!(lit_len_histogram)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dist_histogram) as usize - ptr as usize },
            2288usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_huff_histogram),
                "::",
                stringify!(dist_histogram)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hash_table) as usize - ptr as usize },
            2528usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_huff_histogram),
                "::",
                stringify!(hash_table)
            )
        );
    }
    #[doc = " @brief Holds modified histogram"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct isal_mod_hist {
        #[doc = "!< Distance"]
        pub d_hist: [u32; 30usize],
        pub ll_hist: [u32; 513usize],
    }
    #[test]
    fn bindgen_test_layout_isal_mod_hist() {
        const UNINIT: ::std::mem::MaybeUninit<isal_mod_hist> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<isal_mod_hist>(),
            2172usize,
            concat!("Size of: ", stringify!(isal_mod_hist))
        );
        assert_eq!(
            ::std::mem::align_of::<isal_mod_hist>(),
            4usize,
            concat!("Alignment of ", stringify!(isal_mod_hist))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).d_hist) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_mod_hist),
                "::",
                stringify!(d_hist)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).ll_hist) as usize - ptr as usize },
            120usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_mod_hist),
                "::",
                stringify!(ll_hist)
            )
        );
    }
    #[doc = " @brief Holds Bit Buffer information"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct BitBuf2 {
        #[doc = "!< bits in the bit buffer"]
        pub m_bits: u64,
        #[doc = "!< number of valid bits in the bit buffer"]
        pub m_bit_count: u32,
        #[doc = "!< current index of buffer to write to"]
        pub m_out_buf: *mut u8,
        #[doc = "!< end of buffer to write to"]
        pub m_out_end: *mut u8,
        #[doc = "!< start of buffer to write to"]
        pub m_out_start: *mut u8,
    }
    #[test]
    fn bindgen_test_layout_BitBuf2() {
        const UNINIT: ::std::mem::MaybeUninit<BitBuf2> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<BitBuf2>(),
            40usize,
            concat!("Size of: ", stringify!(BitBuf2))
        );
        assert_eq!(
            ::std::mem::align_of::<BitBuf2>(),
            8usize,
            concat!("Alignment of ", stringify!(BitBuf2))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).m_bits) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(BitBuf2),
                "::",
                stringify!(m_bits)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).m_bit_count) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(BitBuf2),
                "::",
                stringify!(m_bit_count)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).m_out_buf) as usize - ptr as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(BitBuf2),
                "::",
                stringify!(m_out_buf)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).m_out_end) as usize - ptr as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(BitBuf2),
                "::",
                stringify!(m_out_end)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).m_out_start) as usize - ptr as usize },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(BitBuf2),
                "::",
                stringify!(m_out_start)
            )
        );
    }
    #[doc = " @brief Holds Zlib header information"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct isal_zlib_header {
        #[doc = "!< base-2 logarithm of the LZ77 window size minus 8"]
        pub info: u32,
        #[doc = "!< Compression level (fastest, fast, default, maximum)"]
        pub level: u32,
        #[doc = "!< Dictionary id"]
        pub dict_id: u32,
        #[doc = "!< Whether to use a dictionary"]
        pub dict_flag: u32,
    }
    #[test]
    fn bindgen_test_layout_isal_zlib_header() {
        const UNINIT: ::std::mem::MaybeUninit<isal_zlib_header> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<isal_zlib_header>(),
            16usize,
            concat!("Size of: ", stringify!(isal_zlib_header))
        );
        assert_eq!(
            ::std::mem::align_of::<isal_zlib_header>(),
            4usize,
            concat!("Alignment of ", stringify!(isal_zlib_header))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zlib_header),
                "::",
                stringify!(info)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zlib_header),
                "::",
                stringify!(level)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dict_id) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zlib_header),
                "::",
                stringify!(dict_id)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dict_flag) as usize - ptr as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zlib_header),
                "::",
                stringify!(dict_flag)
            )
        );
    }
    #[doc = " @brief Holds Gzip header information"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct isal_gzip_header {
        #[doc = "!< Optional Text hint"]
        pub text: u32,
        #[doc = "!< Unix modification time in gzip header"]
        pub time: u32,
        #[doc = "!< xflags in gzip header"]
        pub xflags: u32,
        #[doc = "!< OS in gzip header"]
        pub os: u32,
        #[doc = "!< Extra field in gzip header"]
        pub extra: *mut u8,
        #[doc = "!< Length of extra buffer"]
        pub extra_buf_len: u32,
        #[doc = "!< Actual length of gzip header extra field"]
        pub extra_len: u32,
        #[doc = "!< Name in gzip header"]
        pub name: *mut ::std::os::raw::c_char,
        #[doc = "!< Length of name buffer"]
        pub name_buf_len: u32,
        #[doc = "!< Comments in gzip header"]
        pub comment: *mut ::std::os::raw::c_char,
        #[doc = "!< Length of comment buffer"]
        pub comment_buf_len: u32,
        #[doc = "!< Header crc or header crc flag"]
        pub hcrc: u32,
        #[doc = "!< Internal data"]
        pub flags: u32,
    }
    #[test]
    fn bindgen_test_layout_isal_gzip_header() {
        const UNINIT: ::std::mem::MaybeUninit<isal_gzip_header> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<isal_gzip_header>(),
            72usize,
            concat!("Size of: ", stringify!(isal_gzip_header))
        );
        assert_eq!(
            ::std::mem::align_of::<isal_gzip_header>(),
            8usize,
            concat!("Alignment of ", stringify!(isal_gzip_header))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).text) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(text)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).time) as usize - ptr as usize },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(time)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).xflags) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(xflags)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).os) as usize - ptr as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(os)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).extra) as usize - ptr as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(extra)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).extra_buf_len) as usize - ptr as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(extra_buf_len)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).extra_len) as usize - ptr as usize },
            28usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(extra_len)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(name)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).name_buf_len) as usize - ptr as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(name_buf_len)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).comment) as usize - ptr as usize },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(comment)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).comment_buf_len) as usize - ptr as usize },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(comment_buf_len)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hcrc) as usize - ptr as usize },
            60usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(hcrc)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_gzip_header),
                "::",
                stringify!(flags)
            )
        );
    }
    #[doc = " @brief Holds the internal state information for input and output compression streams"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct isal_zstate {
        #[doc = "!< Not used, may be replaced with something else"]
        pub total_in_start: u32,
        #[doc = "!< Start of current deflate block in the input"]
        pub block_next: u32,
        #[doc = "!< End of current deflate block in the input"]
        pub block_end: u32,
        #[doc = "!< Distance mask used."]
        pub dist_mask: u32,
        pub hash_mask: u32,
        #[doc = "!< Current state in processing the data stream"]
        pub state: isal_zstate_state,
        #[doc = "!< Bit Buffer"]
        pub bitbuf: BitBuf2,
        #[doc = "!< Current checksum without finalize step if any (adler)"]
        pub crc: u32,
        #[doc = "!< keeps track of wrapper header"]
        pub has_wrap_hdr: u8,
        #[doc = "!< keeps track of eob hdr (with BFINAL set)"]
        pub has_eob_hdr: u8,
        #[doc = "!< keeps track of eob on the last deflate block"]
        pub has_eob: u8,
        #[doc = "!< flag to track if there is match history"]
        pub has_hist: u8,
        #[doc = "!< flag to track if user supplied memory has been initialized."]
        pub has_level_buf_init: u16,
        #[doc = "!< used for partial header/trailer writes"]
        pub count: u32,
        #[doc = "!< temporary array"]
        pub tmp_out_buff: [u8; 16usize],
        #[doc = "!< temporary variable"]
        pub tmp_out_start: u32,
        #[doc = "!< temporary variable"]
        pub tmp_out_end: u32,
        #[doc = "!< number of valid bytes in buffer"]
        pub b_bytes_valid: u32,
        #[doc = "!< number of bytes processed in buffer"]
        pub b_bytes_processed: u32,
        #[doc = "!< Internal buffer"]
        pub buffer: [u8; 65824usize],
        #[doc = "!< Hash array"]
        pub head: [u16; 8192usize],
    }
    #[test]
    fn bindgen_test_layout_isal_zstate() {
        const UNINIT: ::std::mem::MaybeUninit<isal_zstate> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<isal_zstate>(),
            82320usize,
            concat!("Size of: ", stringify!(isal_zstate))
        );
        assert_eq!(
            ::std::mem::align_of::<isal_zstate>(),
            8usize,
            concat!("Alignment of ", stringify!(isal_zstate))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).total_in_start) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(total_in_start)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).block_next) as usize - ptr as usize },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(block_next)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).block_end) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(block_end)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dist_mask) as usize - ptr as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(dist_mask)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hash_mask) as usize - ptr as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(hash_mask)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
            20usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(state)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).bitbuf) as usize - ptr as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(bitbuf)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).crc) as usize - ptr as usize },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(crc)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).has_wrap_hdr) as usize - ptr as usize },
            68usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(has_wrap_hdr)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).has_eob_hdr) as usize - ptr as usize },
            69usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(has_eob_hdr)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).has_eob) as usize - ptr as usize },
            70usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(has_eob)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).has_hist) as usize - ptr as usize },
            71usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(has_hist)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).has_level_buf_init) as usize - ptr as usize },
            72usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(has_level_buf_init)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
            76usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(count)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).tmp_out_buff) as usize - ptr as usize },
            80usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(tmp_out_buff)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).tmp_out_start) as usize - ptr as usize },
            96usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(tmp_out_start)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).tmp_out_end) as usize - ptr as usize },
            100usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(tmp_out_end)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).b_bytes_valid) as usize - ptr as usize },
            104usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(b_bytes_valid)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).b_bytes_processed) as usize - ptr as usize },
            108usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(b_bytes_processed)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).buffer) as usize - ptr as usize },
            112usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(buffer)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).head) as usize - ptr as usize },
            65936usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstate),
                "::",
                stringify!(head)
            )
        );
    }
    #[doc = " @brief Holds the huffman tree used to huffman encode the input stream"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct isal_hufftables {
        #[doc = "!< deflate huffman tree header"]
        pub deflate_hdr: [u8; 328usize],
        #[doc = "!< Number of whole bytes in deflate_huff_hdr"]
        pub deflate_hdr_count: u32,
        #[doc = "!< Number of bits in the partial byte in header"]
        pub deflate_hdr_extra_bits: u32,
        #[doc = "!< bits 4:0 are the code length, bits 31:5 are\n!< the code"]
        pub dist_table: [u32; 2usize],
        #[doc = "!< bits 4:0 are the code length, bits 31:5 are\n!< the code"]
        pub len_table: [u32; 256usize],
        #[doc = "!< literal code"]
        pub lit_table: [u16; 257usize],
        #[doc = "!< literal code length"]
        pub lit_table_sizes: [u8; 257usize],
        #[doc = "!< distance code"]
        pub dcodes: [u16; 30usize],
        #[doc = "!< distance code length"]
        pub dcodes_sizes: [u8; 30usize],
    }
    #[test]
    fn bindgen_test_layout_isal_hufftables() {
        const UNINIT: ::std::mem::MaybeUninit<isal_hufftables> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<isal_hufftables>(),
            2232usize,
            concat!("Size of: ", stringify!(isal_hufftables))
        );
        assert_eq!(
            ::std::mem::align_of::<isal_hufftables>(),
            4usize,
            concat!("Alignment of ", stringify!(isal_hufftables))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).deflate_hdr) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(deflate_hdr)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).deflate_hdr_count) as usize - ptr as usize },
            328usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(deflate_hdr_count)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).deflate_hdr_extra_bits) as usize - ptr as usize },
            332usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(deflate_hdr_extra_bits)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dist_table) as usize - ptr as usize },
            336usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(dist_table)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).len_table) as usize - ptr as usize },
            344usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(len_table)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).lit_table) as usize - ptr as usize },
            1368usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(lit_table)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).lit_table_sizes) as usize - ptr as usize },
            1882usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(lit_table_sizes)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dcodes) as usize - ptr as usize },
            2140usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(dcodes)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dcodes_sizes) as usize - ptr as usize },
            2200usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_hufftables),
                "::",
                stringify!(dcodes_sizes)
            )
        );
    }
    #[doc = " @brief Holds stream information"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct isal_zstream {
        #[doc = "!< Next input byte"]
        pub next_in: *mut u8,
        #[doc = "!< number of bytes available at next_in"]
        pub avail_in: u32,
        #[doc = "!< total number of bytes read so far"]
        pub total_in: u32,
        #[doc = "!< Next output byte"]
        pub next_out: *mut u8,
        #[doc = "!< number of bytes available at next_out"]
        pub avail_out: u32,
        #[doc = "!< total number of bytes written so far"]
        pub total_out: u32,
        #[doc = "!< Huffman encoding used when compressing"]
        pub hufftables: *mut isal_hufftables,
        #[doc = "!< Compression level to use"]
        pub level: u32,
        #[doc = "!< Size of level_buf"]
        pub level_buf_size: u32,
        #[doc = "!< User allocated buffer required for different compression levels"]
        pub level_buf: *mut u8,
        #[doc = "!< non-zero if this is the last input buffer"]
        pub end_of_stream: u16,
        #[doc = "!< Flush type can be NO_FLUSH, SYNC_FLUSH or FULL_FLUSH"]
        pub flush: u16,
        #[doc = "!< Indicate if gzip compression is to be performed"]
        pub gzip_flag: u16,
        #[doc = "!< Log base 2 of maximum lookback distance, 0 is use default"]
        pub hist_bits: u16,
        #[doc = "!< Internal state for this stream"]
        pub internal_state: isal_zstate,
    }
    #[test]
    fn bindgen_test_layout_isal_zstream() {
        const UNINIT: ::std::mem::MaybeUninit<isal_zstream> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<isal_zstream>(),
            82384usize,
            concat!("Size of: ", stringify!(isal_zstream))
        );
        assert_eq!(
            ::std::mem::align_of::<isal_zstream>(),
            8usize,
            concat!("Alignment of ", stringify!(isal_zstream))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).next_in) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(next_in)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).avail_in) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(avail_in)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).total_in) as usize - ptr as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(total_in)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).next_out) as usize - ptr as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(next_out)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).avail_out) as usize - ptr as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(avail_out)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).total_out) as usize - ptr as usize },
            28usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(total_out)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hufftables) as usize - ptr as usize },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(hufftables)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(level)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).level_buf_size) as usize - ptr as usize },
            44usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(level_buf_size)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).level_buf) as usize - ptr as usize },
            48usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(level_buf)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).end_of_stream) as usize - ptr as usize },
            56usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(end_of_stream)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).flush) as usize - ptr as usize },
            58usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(flush)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).gzip_flag) as usize - ptr as usize },
            60usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(gzip_flag)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hist_bits) as usize - ptr as usize },
            62usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(hist_bits)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).internal_state) as usize - ptr as usize },
            64usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_zstream),
                "::",
                stringify!(internal_state)
            )
        );
    }
    #[doc = " @brief Large lookup table for decoding huffman codes"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct inflate_huff_code_large {
        #[doc = "!< Short code lookup table"]
        pub short_code_lookup: [u32; 4096usize],
        #[doc = "!< Long code lookup table"]
        pub long_code_lookup: [u16; 1264usize],
    }
    #[test]
    fn bindgen_test_layout_inflate_huff_code_large() {
        const UNINIT: ::std::mem::MaybeUninit<inflate_huff_code_large> =
            ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<inflate_huff_code_large>(),
            18912usize,
            concat!("Size of: ", stringify!(inflate_huff_code_large))
        );
        assert_eq!(
            ::std::mem::align_of::<inflate_huff_code_large>(),
            4usize,
            concat!("Alignment of ", stringify!(inflate_huff_code_large))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).short_code_lookup) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_huff_code_large),
                "::",
                stringify!(short_code_lookup)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).long_code_lookup) as usize - ptr as usize },
            16384usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_huff_code_large),
                "::",
                stringify!(long_code_lookup)
            )
        );
    }
    #[doc = " @brief Small lookup table for decoding huffman codes"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct inflate_huff_code_small {
        #[doc = "!< Short code lookup table"]
        pub short_code_lookup: [u16; 1024usize],
        #[doc = "!< Long code lookup table"]
        pub long_code_lookup: [u16; 80usize],
    }
    #[test]
    fn bindgen_test_layout_inflate_huff_code_small() {
        const UNINIT: ::std::mem::MaybeUninit<inflate_huff_code_small> =
            ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<inflate_huff_code_small>(),
            2208usize,
            concat!("Size of: ", stringify!(inflate_huff_code_small))
        );
        assert_eq!(
            ::std::mem::align_of::<inflate_huff_code_small>(),
            2usize,
            concat!("Alignment of ", stringify!(inflate_huff_code_small))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).short_code_lookup) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_huff_code_small),
                "::",
                stringify!(short_code_lookup)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).long_code_lookup) as usize - ptr as usize },
            2048usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_huff_code_small),
                "::",
                stringify!(long_code_lookup)
            )
        );
    }
    #[doc = " @brief Holds decompression state information"]
    #[repr(C)]
    #[derive(Copy, Clone)]
    pub struct inflate_state {
        #[doc = "!< Next output Byte"]
        pub next_out: *mut u8,
        #[doc = "!< Number of bytes available at next_out"]
        pub avail_out: u32,
        #[doc = "!< Total bytes written out so far"]
        pub total_out: u32,
        #[doc = "!< Next input byte"]
        pub next_in: *mut u8,
        #[doc = "!< Bits buffered to handle unaligned streams"]
        pub read_in: u64,
        #[doc = "!< Number of bytes available at next_in"]
        pub avail_in: u32,
        #[doc = "!< Bits in read_in"]
        pub read_in_length: i32,
        #[doc = "!< Structure for decoding lit/len symbols"]
        pub lit_huff_code: inflate_huff_code_large,
        #[doc = "!< Structure for decoding dist symbols"]
        pub dist_huff_code: inflate_huff_code_small,
        #[doc = "!< Current decompression state"]
        pub block_state: isal_block_state,
        #[doc = "!< Length of dictionary used"]
        pub dict_length: u32,
        #[doc = "!< Flag identifying final block"]
        pub bfinal: u32,
        #[doc = "!< Flag identifying whether to track of crc"]
        pub crc_flag: u32,
        #[doc = "!< Contains crc or adler32 of output if crc_flag is set"]
        pub crc: u32,
        #[doc = "!< Log base 2 of maximum lookback distance"]
        pub hist_bits: u32,
        pub __bindgen_anon_1: inflate_state__bindgen_ty_1,
        pub write_overflow_lits: i32,
        pub write_overflow_len: i32,
        #[doc = "!< Length left to copy when outbuffer overflow occurred"]
        pub copy_overflow_length: i32,
        #[doc = "!< Lookback distance when outbuffer overflow occurred"]
        pub copy_overflow_distance: i32,
        pub wrapper_flag: i16,
        #[doc = "!< Number of bytes in tmp_in_buffer"]
        pub tmp_in_size: i16,
        #[doc = "!< Number of bytes in tmp_out_buffer"]
        pub tmp_out_valid: i32,
        #[doc = "!< Number of bytes processed in tmp_out_buffer"]
        pub tmp_out_processed: i32,
        #[doc = "!< Temporary buffer containing data from the\n!< input stream"]
        pub tmp_in_buffer: [u8; 328usize],
        pub tmp_out_buffer: [u8; 65824usize],
    }
    #[repr(C)]
    #[derive(Copy, Clone)]
    pub union inflate_state__bindgen_ty_1 {
        #[doc = "!< Length left to read of type 0 block when outbuffer\n!< overflow occurred"]
        pub type0_block_len: i32,
        #[doc = "!< Count of bytes remaining to be parsed"]
        pub count: i32,
        pub dict_id: u32,
    }
    #[test]
    fn bindgen_test_layout_inflate_state__bindgen_ty_1() {
        const UNINIT: ::std::mem::MaybeUninit<inflate_state__bindgen_ty_1> =
            ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<inflate_state__bindgen_ty_1>(),
            4usize,
            concat!("Size of: ", stringify!(inflate_state__bindgen_ty_1))
        );
        assert_eq!(
            ::std::mem::align_of::<inflate_state__bindgen_ty_1>(),
            4usize,
            concat!("Alignment of ", stringify!(inflate_state__bindgen_ty_1))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).type0_block_len) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state__bindgen_ty_1),
                "::",
                stringify!(type0_block_len)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state__bindgen_ty_1),
                "::",
                stringify!(count)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dict_id) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state__bindgen_ty_1),
                "::",
                stringify!(dict_id)
            )
        );
    }
    #[test]
    fn bindgen_test_layout_inflate_state() {
        const UNINIT: ::std::mem::MaybeUninit<inflate_state> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<inflate_state>(),
            87368usize,
            concat!("Size of: ", stringify!(inflate_state))
        );
        assert_eq!(
            ::std::mem::align_of::<inflate_state>(),
            8usize,
            concat!("Alignment of ", stringify!(inflate_state))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).next_out) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(next_out)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).avail_out) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(avail_out)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).total_out) as usize - ptr as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(total_out)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).next_in) as usize - ptr as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(next_in)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).read_in) as usize - ptr as usize },
            24usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(read_in)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).avail_in) as usize - ptr as usize },
            32usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(avail_in)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).read_in_length) as usize - ptr as usize },
            36usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(read_in_length)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).lit_huff_code) as usize - ptr as usize },
            40usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(lit_huff_code)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dist_huff_code) as usize - ptr as usize },
            18952usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(dist_huff_code)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).block_state) as usize - ptr as usize },
            21160usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(block_state)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).dict_length) as usize - ptr as usize },
            21164usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(dict_length)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).bfinal) as usize - ptr as usize },
            21168usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(bfinal)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).crc_flag) as usize - ptr as usize },
            21172usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(crc_flag)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).crc) as usize - ptr as usize },
            21176usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(crc)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hist_bits) as usize - ptr as usize },
            21180usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(hist_bits)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).write_overflow_lits) as usize - ptr as usize },
            21188usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(write_overflow_lits)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).write_overflow_len) as usize - ptr as usize },
            21192usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(write_overflow_len)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).copy_overflow_length) as usize - ptr as usize },
            21196usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(copy_overflow_length)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).copy_overflow_distance) as usize - ptr as usize },
            21200usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(copy_overflow_distance)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).wrapper_flag) as usize - ptr as usize },
            21204usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(wrapper_flag)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).tmp_in_size) as usize - ptr as usize },
            21206usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(tmp_in_size)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).tmp_out_valid) as usize - ptr as usize },
            21208usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(tmp_out_valid)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).tmp_out_processed) as usize - ptr as usize },
            21212usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(tmp_out_processed)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).tmp_in_buffer) as usize - ptr as usize },
            21216usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(tmp_in_buffer)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).tmp_out_buffer) as usize - ptr as usize },
            21544usize,
            concat!(
                "Offset of field: ",
                stringify!(inflate_state),
                "::",
                stringify!(tmp_out_buffer)
            )
        );
    }
    extern "C" {
        #[doc = "/\n/**\n @brief Updates histograms to include the symbols found in the input\n stream. Since this function only updates the histograms, it can be called on\n multiple streams to get a histogram better representing the desired data\n set. When first using histogram it must be initialized by zeroing the\n structure.\n\n @param in_stream: Input stream of data.\n @param length: The length of start_stream.\n @param histogram: The returned histogram of lit/len/dist symbols."]
        pub fn isal_update_histogram(
            in_stream: *mut u8,
            length: ::std::os::raw::c_int,
            histogram: *mut isal_huff_histogram,
        );
    }
    extern "C" {
        #[doc = " @brief Creates a custom huffman code for the given histograms in which\n  every literal and repeat length is assigned a code and all possible lookback\n  distances are assigned a code.\n\n @param hufftables: the output structure containing the huffman code\n @param histogram: histogram containing frequency of literal symbols,\n        repeat lengths and lookback distances\n @returns Returns a non zero value if an invalid huffman code was created."]
        pub fn isal_create_hufftables(
            hufftables: *mut isal_hufftables,
            histogram: *mut isal_huff_histogram,
        ) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Creates a custom huffman code for the given histograms like\n isal_create_hufftables() except literals with 0 frequency in the histogram\n are not assigned a code\n\n @param hufftables: the output structure containing the huffman code\n @param histogram: histogram containing frequency of literal symbols,\n        repeat lengths and lookback distances\n @returns Returns a non zero value if an invalid huffman code was created."]
        pub fn isal_create_hufftables_subset(
            hufftables: *mut isal_hufftables,
            histogram: *mut isal_huff_histogram,
        ) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Initialize compression stream data structure\n\n @param stream Structure holding state information on the compression streams.\n @returns none"]
        pub fn isal_deflate_init(stream: *mut isal_zstream);
    }
    extern "C" {
        #[doc = " @brief Reinitialize compression stream data structure. Performs the same\n action as isal_deflate_init, but does not change user supplied input such as\n the level, flush type, compression wrapper (like gzip), hufftables, and\n end_of_stream_flag.\n\n @param stream Structure holding state information on the compression streams.\n @returns none"]
        pub fn isal_deflate_reset(stream: *mut isal_zstream);
    }
    extern "C" {
        #[doc = " @brief Set gzip header default values\n\n @param gz_hdr: Gzip header to initialize."]
        pub fn isal_gzip_header_init(gz_hdr: *mut isal_gzip_header);
    }
    extern "C" {
        #[doc = " @brief Set zlib header default values\n\n @param z_hdr: zlib header to initialize."]
        pub fn isal_zlib_header_init(z_hdr: *mut isal_zlib_header);
    }
    extern "C" {
        #[doc = " @brief Write gzip header to output stream\n\n Writes the gzip header to the output stream. On entry this function assumes\n that the output buffer has been initialized, so stream->next_out,\n stream->avail_out and stream->total_out have been set. If the output buffer\n contains insufficient space, stream is not modified.\n\n @param stream: Structure holding state information on the compression stream.\n @param gz_hdr: Structure holding the gzip header information to encode.\n\n @returns Returns 0 if the header is successfully written, otherwise returns\n the minimum size required to successfully write the gzip header to the output\n buffer."]
        pub fn isal_write_gzip_header(
            stream: *mut isal_zstream,
            gz_hdr: *mut isal_gzip_header,
        ) -> u32;
    }
    extern "C" {
        #[doc = " @brief Write zlib header to output stream\n\n Writes the zlib header to the output stream. On entry this function assumes\n that the output buffer has been initialized, so stream->next_out,\n stream->avail_out and stream->total_out have been set. If the output buffer\n contains insufficient space, stream is not modified.\n\n @param stream: Structure holding state information on the compression stream.\n @param z_hdr: Structure holding the zlib header information to encode.\n\n @returns Returns 0 if the header is successfully written, otherwise returns\n the minimum size required to successfully write the zlib header to the output\n buffer."]
        pub fn isal_write_zlib_header(
            stream: *mut isal_zstream,
            z_hdr: *mut isal_zlib_header,
        ) -> u32;
    }
    extern "C" {
        #[doc = " @brief Set stream to use a new Huffman code\n\n Sets the Huffman code to be used in compression before compression start or\n after the successful completion of a SYNC_FLUSH or FULL_FLUSH. If type has\n value IGZIP_HUFFTABLE_DEFAULT, the stream is set to use the default Huffman\n code. If type has value IGZIP_HUFFTABLE_STATIC, the stream is set to use the\n deflate standard static Huffman code, or if type has value\n IGZIP_HUFFTABLE_CUSTOM, the stream is set to sue the isal_hufftables\n structure input to isal_deflate_set_hufftables.\n\n @param stream: Structure holding state information on the compression stream.\n @param hufftables: new huffman code to use if type is set to\n IGZIP_HUFFTABLE_CUSTOM.\n @param type: Flag specifying what hufftable to use.\n\n @returns Returns INVALID_OPERATION if the stream was unmodified. This may be\n due to the stream being in a state where changing the huffman code is not\n allowed or an invalid input is provided."]
        pub fn isal_deflate_set_hufftables(
            stream: *mut isal_zstream,
            hufftables: *mut isal_hufftables,
            type_: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Initialize compression stream data structure\n\n @param stream Structure holding state information on the compression streams.\n @returns none"]
        pub fn isal_deflate_stateless_init(stream: *mut isal_zstream);
    }
    extern "C" {
        #[doc = " @brief Set compression dictionary to use\n\n This function is to be called after isal_deflate_init, or after completing a\n SYNC_FLUSH or FULL_FLUSH and before the next call do isal_deflate. If the\n dictionary is longer than IGZIP_HIST_SIZE, only the last IGZIP_HIST_SIZE\n bytes will be used.\n\n @param stream Structure holding state information on the compression streams.\n @param dict: Array containing dictionary to use.\n @param dict_len: Length of dict.\n @returns COMP_OK,\n          ISAL_INVALID_STATE (dictionary could not be set)"]
        pub fn isal_deflate_set_dict(
            stream: *mut isal_zstream,
            dict: *mut u8,
            dict_len: u32,
        ) -> ::std::os::raw::c_int;
    }
    #[doc = " @brief Structure for holding processed dictionary information"]
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct isal_dict {
        pub params: u32,
        pub level: u32,
        pub hist_size: u32,
        pub hash_size: u32,
        pub history: [u8; 32768usize],
        pub hashtable: [u16; 32768usize],
    }
    #[test]
    fn bindgen_test_layout_isal_dict() {
        const UNINIT: ::std::mem::MaybeUninit<isal_dict> = ::std::mem::MaybeUninit::uninit();
        let ptr = UNINIT.as_ptr();
        assert_eq!(
            ::std::mem::size_of::<isal_dict>(),
            98320usize,
            concat!("Size of: ", stringify!(isal_dict))
        );
        assert_eq!(
            ::std::mem::align_of::<isal_dict>(),
            4usize,
            concat!("Alignment of ", stringify!(isal_dict))
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).params) as usize - ptr as usize },
            0usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_dict),
                "::",
                stringify!(params)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).level) as usize - ptr as usize },
            4usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_dict),
                "::",
                stringify!(level)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hist_size) as usize - ptr as usize },
            8usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_dict),
                "::",
                stringify!(hist_size)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hash_size) as usize - ptr as usize },
            12usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_dict),
                "::",
                stringify!(hash_size)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).history) as usize - ptr as usize },
            16usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_dict),
                "::",
                stringify!(history)
            )
        );
        assert_eq!(
            unsafe { ::std::ptr::addr_of!((*ptr).hashtable) as usize - ptr as usize },
            32784usize,
            concat!(
                "Offset of field: ",
                stringify!(isal_dict),
                "::",
                stringify!(hashtable)
            )
        );
    }
    extern "C" {
        #[doc = " @brief Process dictionary to reuse later\n\n Processes a dictionary so that the generated output can be reused to reset a\n new deflate stream more quickly than isal_deflate_set_dict() alone. This\n function is paired with isal_deflate_reset_dict() when using the same\n dictionary on multiple deflate objects. The stream.level must be set prior to\n calling this function to process the dictionary correctly. If the dictionary\n is longer than IGZIP_HIST_SIZE, only the last IGZIP_HIST_SIZE bytes will be\n used.\n\n @param stream Structure holding state information on the compression streams.\n @param dict_str: Structure to hold processed dictionary info to reuse later.\n @param dict: Array containing dictionary to use.\n @param dict_len: Length of dict.\n @returns COMP_OK,\n          ISAL_INVALID_STATE (dictionary could not be processed)"]
        pub fn isal_deflate_process_dict(
            stream: *mut isal_zstream,
            dict_str: *mut isal_dict,
            dict: *mut u8,
            dict_len: u32,
        ) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Reset compression dictionary to use\n\n Similar to isal_deflate_set_dict() but on pre-processed dictionary\n data. Pairing with isal_deflate_process_dict() can reduce the processing time\n on subsequent compression with dictionary especially on small files.\n\n Like isal_deflate_set_dict(), this function is to be called after\n isal_deflate_init, or after completing a SYNC_FLUSH or FULL_FLUSH and before\n the next call do isal_deflate. Changing compression level between dictionary\n process and reset will cause return of ISAL_INVALID_STATE.\n\n @param stream Structure holding state information on the compression streams.\n @param dict_str: Structure with pre-processed dictionary info.\n @returns COMP_OK,\n          ISAL_INVALID_STATE or other (dictionary could not be reset)"]
        pub fn isal_deflate_reset_dict(
            stream: *mut isal_zstream,
            dict_str: *mut isal_dict,
        ) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Fast data (deflate) compression for storage applications.\n\n The call to isal_deflate() will take data from the input buffer (updating\n next_in, avail_in and write a compressed stream to the output buffer\n (updating next_out and avail_out). The function returns when either the input\n buffer is empty or the output buffer is full.\n\n On entry to isal_deflate(), next_in points to an input buffer and avail_in\n indicates the length of that buffer. Similarly next_out points to an empty\n output buffer and avail_out indicates the size of that buffer.\n\n The fields total_in and total_out start at 0 and are updated by\n isal_deflate(). These reflect the total number of bytes read or written so far.\n\n When the last input buffer is passed in, signaled by setting the\n end_of_stream, the routine will complete compression at the end of the input\n buffer, as long as the output buffer is big enough.\n\n The compression level can be set by setting level to any value between\n ISAL_DEF_MIN_LEVEL and ISAL_DEF_MAX_LEVEL. When the compression level is\n ISAL_DEF_MIN_LEVEL, hufftables can be set to a table trained for the the\n specific data type being compressed to achieve better compression. When a\n higher compression level is desired, a larger generic memory buffer needs to\n be supplied by setting level_buf and level_buf_size to represent the chunk of\n memory. For level x, the suggest size for this buffer this buffer is\n ISAL_DEFL_LVLx_DEFAULT. The defines ISAL_DEFL_LVLx_MIN, ISAL_DEFL_LVLx_SMALL,\n ISAL_DEFL_LVLx_MEDIUM, ISAL_DEFL_LVLx_LARGE, and ISAL_DEFL_LVLx_EXTRA_LARGE\n are also provided as other suggested sizes.\n\n The equivalent of the zlib FLUSH_SYNC operation is currently supported.\n Flush types can be NO_FLUSH, SYNC_FLUSH or FULL_FLUSH. Default flush type is\n NO_FLUSH. A SYNC_ OR FULL_ flush will byte align the deflate block by\n appending an empty stored block once all input has been compressed, including\n the buffered input. Checking that the out_buffer is not empty or that\n internal_state.state = ZSTATE_NEW_HDR is sufficient to guarantee all input\n has been flushed. Additionally FULL_FLUSH will ensure look back history does\n not include previous blocks so new blocks are fully independent. Switching\n between flush types is supported.\n\n If a compression dictionary is required, the dictionary can be set calling\n isal_deflate_set_dictionary before calling isal_deflate.\n\n If the gzip_flag is set to IGZIP_GZIP, a generic gzip header and the gzip\n trailer are written around the deflate compressed data. If gzip_flag is set\n to IGZIP_GZIP_NO_HDR, then only the gzip trailer is written. A full-featured\n header is supported by the isal_write_{gzip,zlib}_header() functions.\n\n @param  stream Structure holding state information on the compression streams.\n @return COMP_OK (if everything is ok),\n         INVALID_FLUSH (if an invalid FLUSH is selected),\n         ISAL_INVALID_LEVEL (if an invalid compression level is selected),\n         ISAL_INVALID_LEVEL_BUF (if the level buffer is not large enough)."]
        pub fn isal_deflate(stream: *mut isal_zstream) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Fast data (deflate) stateless compression for storage applications.\n\n Stateless (one shot) compression routine with a similar interface to\n isal_deflate() but operates on entire input buffer at one time. Parameter\n avail_out must be large enough to fit the entire compressed output. Max\n expansion is limited to the input size plus the header size of a stored/raw\n block.\n\n When the compression level is set to 1, unlike in isal_deflate(), level_buf\n may be optionally set depending on what what performance is desired.\n\n For stateless the flush types NO_FLUSH and FULL_FLUSH are supported.\n FULL_FLUSH will byte align the output deflate block so additional blocks can\n be easily appended.\n\n If the gzip_flag is set to IGZIP_GZIP, a generic gzip header and the gzip\n trailer are written around the deflate compressed data. If gzip_flag is set\n to IGZIP_GZIP_NO_HDR, then only the gzip trailer is written.\n\n @param  stream Structure holding state information on the compression streams.\n @return COMP_OK (if everything is ok),\n         INVALID_FLUSH (if an invalid FLUSH is selected),\n         ISAL_INVALID_LEVEL (if an invalid compression level is selected),\n         ISAL_INVALID_LEVEL_BUF (if the level buffer is not large enough),\n         STATELESS_OVERFLOW (if output buffer will not fit output)."]
        pub fn isal_deflate_stateless(stream: *mut isal_zstream) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = "/\n/**\n @brief Initialize decompression state data structure\n\n @param state Structure holding state information on the compression streams.\n @returns none"]
        pub fn isal_inflate_init(state: *mut inflate_state);
    }
    extern "C" {
        #[doc = " @brief Reinitialize decompression state data structure\n\n @param state Structure holding state information on the compression streams.\n @returns none"]
        pub fn isal_inflate_reset(state: *mut inflate_state);
    }
    extern "C" {
        #[doc = " @brief Set decompression dictionary to use\n\n This function is to be called after isal_inflate_init. If the dictionary is\n longer than IGZIP_HIST_SIZE, only the last IGZIP_HIST_SIZE bytes will be\n used.\n\n @param state: Structure holding state information on the decompression stream.\n @param dict: Array containing dictionary to use.\n @param dict_len: Length of dict.\n @returns COMP_OK,\n          ISAL_INVALID_STATE (dictionary could not be set)"]
        pub fn isal_inflate_set_dict(
            state: *mut inflate_state,
            dict: *mut u8,
            dict_len: u32,
        ) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Read and return gzip header information\n\n On entry state must be initialized and next_in pointing to a gzip compressed\n buffer. The buffers gz_hdr->extra, gz_hdr->name, gz_hdr->comments and the\n buffer lengths must be set to record the corresponding field, or set to NULL\n to disregard that gzip header information. If one of these buffers overflows,\n the user can reallocate a larger buffer and call this function again to\n continue reading the header information.\n\n @param state: Structure holding state information on the decompression stream.\n @param gz_hdr: Structure to return data encoded in the gzip header\n @returns ISAL_DECOMP_OK (header was successfully parsed)\n          ISAL_END_INPUT (all input was parsed),\n          ISAL_NAME_OVERFLOW (gz_hdr->name overflowed while parsing),\n          ISAL_COMMENT_OVERFLOW (gz_hdr->comment overflowed while parsing),\n          ISAL_EXTRA_OVERFLOW (gz_hdr->extra overflowed while parsing),\n          ISAL_INVALID_WRAPPER (invalid gzip header found),\n          ISAL_UNSUPPORTED_METHOD (deflate is not the compression method),\n          ISAL_INCORRECT_CHECKSUM (gzip header checksum was incorrect)"]
        pub fn isal_read_gzip_header(
            state: *mut inflate_state,
            gz_hdr: *mut isal_gzip_header,
        ) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Read and return zlib header information\n\n On entry state must be initialized and next_in pointing to a zlib compressed\n buffer.\n\n @param state: Structure holding state information on the decompression stream.\n @param zlib_hdr: Structure to return data encoded in the zlib header\n @returns ISAL_DECOMP_OK (header was successfully parsed),\n          ISAL_END_INPUT (all input was parsed),\n          ISAL_UNSUPPORTED_METHOD (deflate is not the compression method),\n          ISAL_INCORRECT_CHECKSUM (zlib header checksum was incorrect)"]
        pub fn isal_read_zlib_header(
            state: *mut inflate_state,
            zlib_hdr: *mut isal_zlib_header,
        ) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Fast data (deflate) decompression for storage applications.\n\n On entry to isal_inflate(), next_in points to an input buffer and avail_in\n indicates the length of that buffer. Similarly next_out points to an empty\n output buffer and avail_out indicates the size of that buffer.\n\n The field total_out starts at 0 and is updated by isal_inflate(). This\n reflects the total number of bytes written so far.\n\n The call to isal_inflate() will take data from the input buffer (updating\n next_in, avail_in and write a decompressed stream to the output buffer\n (updating next_out and avail_out). The function returns when the input buffer\n is empty, the output buffer is full, invalid data is found, or in the case of\n zlib formatted data if a dictionary is specified. The current state of the\n decompression on exit can be read from state->block-state.\n\n If the crc_flag is set to ISAL_GZIP_NO_HDR the gzip crc of the output is\n stored in state->crc. Alternatively, if the crc_flag is set to\n ISAL_ZLIB_NO_HDR the adler32 of the output is stored in state->crc (checksum\n may not be updated until decompression is complete). When the crc_flag is set\n to ISAL_GZIP_NO_HDR_VER or ISAL_ZLIB_NO_HDR_VER, the behavior is the same,\n except the checksum is verified with the checksum after immediately following\n the deflate data. If the crc_flag is set to ISAL_GZIP or ISAL_ZLIB, the\n gzip/zlib header is parsed, state->crc is set to the appropriate checksum,\n and the checksum is verified. If the crc_flag is set to ISAL_DEFLATE\n (default), then the data is treated as a raw deflate block.\n\n The element state->hist_bits has values from 0 to 15, where values of 1 to 15\n are the log base 2 size of the matching window and 0 is the default with\n maximum history size.\n\n If a dictionary is required, a call to isal_inflate_set_dict will set the\n dictionary.\n\n @param  state Structure holding state information on the compression streams.\n @return ISAL_DECOMP_OK (if everything is ok),\n         ISAL_INVALID_BLOCK,\n         ISAL_NEED_DICT,\n         ISAL_INVALID_SYMBOL,\n         ISAL_INVALID_LOOKBACK,\n         ISAL_INVALID_WRAPPER,\n         ISAL_UNSUPPORTED_METHOD,\n         ISAL_INCORRECT_CHECKSUM."]
        pub fn isal_inflate(state: *mut inflate_state) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = " @brief Fast data (deflate) stateless decompression for storage applications.\n\n Stateless (one shot) decompression routine with a similar interface to\n isal_inflate() but operates on entire input buffer at one time. Parameter\n avail_out must be large enough to fit the entire decompressed\n output. Dictionaries are not supported.\n\n @param  state Structure holding state information on the compression streams.\n @return ISAL_DECOMP_OK (if everything is ok),\n         ISAL_END_INPUT (if all input was decompressed),\n         ISAL_NEED_DICT,\n         ISAL_OUT_OVERFLOW (if output buffer ran out of space),\n         ISAL_INVALID_BLOCK,\n         ISAL_INVALID_SYMBOL,\n         ISAL_INVALID_LOOKBACK,\n         ISAL_INVALID_WRAPPER,\n         ISAL_UNSUPPORTED_METHOD,\n         ISAL_INCORRECT_CHECKSUM."]
        pub fn isal_inflate_stateless(state: *mut inflate_state) -> ::std::os::raw::c_int;
    }
    extern "C" {
        #[doc = "/\n/**\n @brief Calculate Adler-32 checksum, runs appropriate version.\n\n This function determines what instruction sets are enabled and selects the\n appropriate version at runtime.\n\n @param init: initial Adler-32 value\n @param buf: buffer to calculate checksum on\n @param len: buffer length in bytes\n\n @returns 32-bit Adler-32 checksum"]
        pub fn isal_adler32(init: u32, buf: *const ::std::os::raw::c_uchar, len: u64) -> u32;
    }
}
