/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import sbt.AttributeKey;
import sbt.AttributeKey$;
import sbt.FileFilter;
import sbt.FileFilter$;
import sbt.GlobFilter$;
import sbt.Logger;
import sbt.Path$;
import sbt.State;
import sbt.State$;
import sbt.cross.CrossVersionUtil$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import xsbti.compile.ScalaInstance;

public final class BuildPaths$ {
    public static final BuildPaths$ MODULE$;
    private final AttributeKey<File> globalBaseDirectory;
    private final AttributeKey<File> globalPluginsDirectory;
    private final AttributeKey<File> globalSettingsDirectory;
    private final AttributeKey<File> stagingDirectory;
    private final AttributeKey<File> dependencyBaseDirectory;
    private final String PluginsDirectoryName;
    private final String DefaultTargetName;
    private final String ConfigDirectoryName;
    private final String GlobalBaseProperty;
    private final String StagingProperty;
    private final String GlobalPluginsProperty;
    private final String GlobalSettingsProperty;
    private final String DependencyBaseProperty;

    static {
        new BuildPaths$();
    }

    public AttributeKey<File> globalBaseDirectory() {
        return this.globalBaseDirectory;
    }

    public AttributeKey<File> globalPluginsDirectory() {
        return this.globalPluginsDirectory;
    }

    public AttributeKey<File> globalSettingsDirectory() {
        return this.globalSettingsDirectory;
    }

    public AttributeKey<File> stagingDirectory() {
        return this.stagingDirectory;
    }

    public AttributeKey<File> dependencyBaseDirectory() {
        return this.dependencyBaseDirectory;
    }

    public File getGlobalBase(State state) {
        File file2 = this.defaultVersionedGlobalBase(this.binarySbtVersion(state));
        return this.getFileSetting(this.globalBaseDirectory(), "sbt.global.base", (Function0<File>)new Serializable(state, file2){
            public static final long serialVersionUID = 0L;
            private final State state$1;
            private final File default$1;

            public final File apply() {
                return BuildPaths$.MODULE$.sbt$BuildPaths$$getDefault$1(this.state$1, this.default$1);
            }
            {
                this.state$1 = state$1;
                this.default$1 = default$1;
            }
        }, state);
    }

    private void checkTransition(State state, File versioned) {
        boolean warnTransition;
        File unversioned = this.defaultGlobalBase();
        boolean bl = warnTransition = !this.globalDefined$1(versioned, state) && this.globalDefined$1(unversioned, state);
        if (warnTransition) {
            State$.MODULE$.stateOps(state).log().warn((Function0)new Serializable(versioned, unversioned){
                public static final long serialVersionUID = 0L;
                private final File versioned$1;
                private final File unversioned$1;

                public final String apply() {
                    return BuildPaths$.MODULE$.sbt$BuildPaths$$globalDirTransitionWarning(this.unversioned$1, this.versioned$1);
                }
                {
                    this.versioned$1 = versioned$1;
                    this.unversioned$1 = unversioned$1;
                }
            });
        }
    }

    public File getStagingDirectory(State state, File globalBase) {
        return this.fileSetting(this.stagingDirectory(), "sbt.global.staging", this.defaultStaging(globalBase), state);
    }

    public File getGlobalPluginsDirectory(State state, File globalBase) {
        return this.fileSetting(this.globalPluginsDirectory(), "sbt.global.plugins", this.defaultGlobalPlugins(globalBase), state);
    }

    public File getGlobalSettingsDirectory(State state, File globalBase) {
        return this.fileSetting(this.globalSettingsDirectory(), "sbt.global.settings", globalBase, state);
    }

    public File getDependencyDirectory(State state, File globalBase) {
        return this.fileSetting(this.dependencyBaseDirectory(), "sbt.dependency.base", this.defaultDependencyBase(globalBase), state);
    }

    private File fileSetting(AttributeKey<File> stateKey, String property, File file2, State state) {
        return this.getFileSetting(stateKey, property, (Function0<File>)new Serializable(file2){
            public static final long serialVersionUID = 0L;
            private final File default$2;

            public final File apply() {
                return this.default$2;
            }
            {
                this.default$2 = default$2;
            }
        }, state);
    }

    public File getFileSetting(AttributeKey<File> stateKey, String property, Function0<File> function0, State state) {
        return (File)State$.MODULE$.stateOps(state).get(stateKey).orElse((Function0)new Serializable(property){
            public static final long serialVersionUID = 0L;
            private final String property$1;

            public final Option<File> apply() {
                return BuildPaths$.MODULE$.getFileProperty(this.property$1);
            }
            {
                this.property$1 = property$1;
            }
        }).getOrElse(function0);
    }

    public Option<File> getFileProperty(String name2) {
        return Option$.MODULE$.apply((Object)System.getProperty(name2)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<File> apply(String path) {
                return path.isEmpty() ? None$.MODULE$ : new Some((Object)new File(path));
            }
        });
    }

    public File defaultVersionedGlobalBase(String sbtVersion) {
        return Path$.MODULE$.richFile(this.defaultGlobalBase()).$div(sbtVersion);
    }

    public File defaultGlobalBase() {
        return Path$.MODULE$.richFile(Path$.MODULE$.userHome()).$div(".sbt");
    }

    private String binarySbtVersion(State state) {
        return CrossVersionUtil$.MODULE$.binarySbtVersion(state.configuration().provider().id().version());
    }

    private File defaultStaging(File globalBase) {
        return Path$.MODULE$.richFile(globalBase).$div("staging");
    }

    private File defaultGlobalPlugins(File globalBase) {
        return Path$.MODULE$.richFile(globalBase).$div("plugins");
    }

    private File defaultDependencyBase(File globalBase) {
        return Path$.MODULE$.richFile(globalBase).$div("dependency");
    }

    public Seq<File> configurationSources(File base) {
        return Path$.MODULE$.singleFileFinder(base).$times((FileFilter)GlobFilter$.MODULE$.apply("*.sbt").$minus(FileFilter$.MODULE$.globFilter(".sbt"))).get();
    }

    public File pluginDirectory(File definitionBase) {
        return Path$.MODULE$.richFile(definitionBase).$div("plugins");
    }

    public File evalOutputDirectory(File base) {
        return Path$.MODULE$.richFile(this.outputDirectory(base)).$div("config-classes");
    }

    public File outputDirectory(File base) {
        return Path$.MODULE$.richFile(base).$div("target");
    }

    public File projectStandard(File base) {
        return Path$.MODULE$.richFile(base).$div("project");
    }

    public File projectHidden(File base) {
        return this.projectStandard(base);
    }

    public File selectProjectDir(File base, Logger log) {
        return this.projectStandard(base);
    }

    public final String PluginsDirectoryName() {
        return "plugins";
    }

    public final String DefaultTargetName() {
        return "target";
    }

    public final String ConfigDirectoryName() {
        return ".sbt";
    }

    public final String GlobalBaseProperty() {
        return "sbt.global.base";
    }

    public final String StagingProperty() {
        return "sbt.global.staging";
    }

    public final String GlobalPluginsProperty() {
        return "sbt.global.plugins";
    }

    public final String GlobalSettingsProperty() {
        return "sbt.global.settings";
    }

    public final String DependencyBaseProperty() {
        return "sbt.dependency.base";
    }

    public File crossPath(File base, ScalaInstance instance) {
        return Path$.MODULE$.richFile(base).$div(new StringBuilder().append((Object)"scala_").append((Object)instance.version()).toString());
    }

    public String sbt$BuildPaths$$globalDirTransitionWarning(File unversioned, File versioned) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The global sbt directory is now versioned and is located at ", ".\n  You are seeing this warning because there is global configuration in ", " but not in ", ".\n  The global sbt directory may be changed via the ", " system property.\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versioned, unversioned, versioned, "sbt.global.base"}));
    }

    public final File sbt$BuildPaths$$getDefault$1(State state$1, File default$1) {
        this.checkTransition(state$1, default$1);
        return default$1;
    }

    private final boolean globalDefined$1(File base, State state$2) {
        return this.getGlobalPluginsDirectory(state$2, base).exists() || this.configurationSources(this.getGlobalSettingsDirectory(state$2, base)).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.exists();
            }
        });
    }

    private BuildPaths$() {
        MODULE$ = this;
        this.globalBaseDirectory = AttributeKey$.MODULE$.apply("global-base-directory", "The base directory for global sbt configuration and staging.", 10000, ManifestFactory$.MODULE$.classType(File.class));
        this.globalPluginsDirectory = AttributeKey$.MODULE$.apply("global-plugins-directory", "The base directory for global sbt plugins.", 10000, ManifestFactory$.MODULE$.classType(File.class));
        this.globalSettingsDirectory = AttributeKey$.MODULE$.apply("global-settings-directory", "The base directory for global sbt settings.", 10000, ManifestFactory$.MODULE$.classType(File.class));
        this.stagingDirectory = AttributeKey$.MODULE$.apply("staging-directory", "The directory for staging remote projects.", 10000, ManifestFactory$.MODULE$.classType(File.class));
        this.dependencyBaseDirectory = AttributeKey$.MODULE$.apply("dependency-base-directory", "The base directory for caching dependency resolution.", 10000, ManifestFactory$.MODULE$.classType(File.class));
    }
}

