/*
 * VRT RULES
 *
 * Copyright (C) 2014-2022 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"
#include "detection_lib_meta.h"

/* declare detection functions */
int rule12759eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow for sid 12759 */
/* flow:established, to_server; */
static FlowFlags rule12759flow1 =
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule12759option1 =
{
    OPTION_TYPE_FLOWFLAGS,
    { &rule12759flow1 }
};

/* content for sid 12759 */
// content:"/carbo.dll", payload uri;
static ContentInfo rule12759content2 =
{
    (u_int8_t *)("63"), /* pattern (now in snort content format) */
    2, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule12759option2 =
{
    OPTION_TYPE_CONTENT,
    { &rule12759content2 }
};

// content:"icatcommand=", nocase;
static ContentInfo rule12759content3 =
{
    (u_int8_t *)("1"), /* pattern (now in snort content format) */
    1, /* depth */
    3, /* offset */
    CONTENT_NOCASE|CONTENT_BUF_NORMALIZED|CONTENT_RELATIVE, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule12759option3 =
{
    OPTION_TYPE_CONTENT,
    { &rule12759content3 }
};

// content:"icatcommand=", nocase;
static ContentInfo rule12759content4 =
{
    (u_int8_t *)("3"), /* pattern (now in snort content format) */
    1, /* depth */
    3, /* offset */
    NOT_FLAG|CONTENT_NOCASE|CONTENT_BUF_NORMALIZED|CONTENT_RELATIVE, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule12759option4 =
{
    OPTION_TYPE_CONTENT,
    { &rule12759content4 }
};


/* references for sid 12759 */
static RuleReference *rule12759refs[] =
{
    NULL
};

RuleOption *rule12759options[] =
{
    &rule12759option1,
    &rule12759option2,
    &rule12759option3,
    &rule12759option4,
    NULL
};

Rule rule12759 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "any", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "any", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   {
       RULE_GID,  /* genid (HARDCODED!!!) */
       12759, /* sigid */
       7, /* revision */

       "attempted-recon", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "Dynamic Pseudo-SSL test",     /* message */
       rule12759refs, /* ptr to references */
       NULL /* Meta data */
   },
   rule12759options, /* ptr to rule options */
    NULL, //&rule12759eval,                               /* Use internal eval func */
    0,                                  /* Not initialized */
    0,                                  /* Rule option count, used internally */
    0,                                  /* Flag with no alert, used internally */
    NULL /* ptr to internal data... setup during rule registration */
};



/* detection functions */

int rule12759eval(void *p) {
    /* cursors, formally known as doe_ptr */
    const u_int8_t *cursor_normal = 0;
    //const u_int8_t *cursor_uri = 0;

    /* flow:established, to_server; */
    if (checkFlow(p, rule12759options[0]->option_u.flowFlags)) {
        // content:"/carbo.dll", payload uri;
        if (contentMatch(p, rule12759options[1]->option_u.content, &cursor_normal) > 0) {
           // content:"icatcommand=", nocase;
            if (contentMatch(p, rule12759options[2]->option_u.content, &cursor_normal) > 0) {
              if (contentMatch(p, rule12759options[3]->option_u.content, &cursor_normal) > 0) {
                return RULE_MATCH;
              }
            }
        }
    }
    return RULE_NOMATCH;
}

