//  This file is part of par2cmdline (a PAR 2.0 compatible file verification and
//  repair tool). See http://parchive.sourceforge.net for details of PAR 2.0.
//
//  Copyright (c) 2003 Peter Brian Clements
//  Copyright (c) 2011 Andreas Moog
//
//  par2cmdline is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  par2cmdline is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#include "libpar2.h"

LibPar2::LibPar2(CommandLine* commandline) {
  commandLine = commandline;

  switch (commandLine->GetVersion())
    {
    case CommandLine::verPar1:
      {
	par1Repairer = new Par1Repairer;
	/*  repairer->sig_filename.connect( sigc::mem_fun(*this,&MainWindow::signal_filename));
	    repairer->sig_progress.connect( sigc::mem_fun(*this,&MainWindow::signal_progress));*/
      }
      break;
    case CommandLine::verPar2:
      {
	par2Repairer = new Par2Repairer;
	par2Repairer->sig_filename.
	  connect( sigc::mem_fun(*this, &LibPar2::signal_filename));
	par2Repairer->sig_progress.
	  connect( sigc::mem_fun(*this,&LibPar2::signal_progress));
	par2Repairer->sig_headers.
	  connect( sigc::mem_fun(*this,&LibPar2::signal_headers));
	par2Repairer->sig_done.
	  connect( sigc::mem_fun(*this,&LibPar2::signal_done));
	//par2Repairer->
      }
      break;
    case CommandLine::opNone:
      break;
    }
}

LibPar2::~LibPar2(void) {
  delete par1Repairer;
  delete par2Repairer;
}


Result LibPar2::PreProcess() {
  Result result = eSuccess;
  switch (commandLine->GetVersion())
    {
    case CommandLine::verPar1:
      {
	//result = par1Repairer->PreProcess(*commandLine);
      }
      break;
    case CommandLine::verPar2:
      {
	result = par2Repairer->PreProcess(*commandLine);
      }
      break;
    case CommandLine::opNone:
      break;
    }
  return result;
}

Result LibPar2::Process(bool dorepair) {
  Result result = eSuccess;
  switch (commandLine->GetVersion())
    {
    case CommandLine::verPar1:
      {
	result = par1Repairer->Process(*commandLine, dorepair);
      }
      break;
    case CommandLine::verPar2:
      {
	result = par2Repairer->Process(*commandLine, dorepair);
      }
      break;
    case CommandLine::opNone:
      break;
    }
  return result;
}

void LibPar2::signal_filename(std::string str) {
  sig_filename.emit(str);
};
void LibPar2::signal_progress(double value) {
  sig_progress.emit(value);
};

void LibPar2::signal_headers(ParHeaders* headers) {
  sig_headers.emit(headers);
}

void LibPar2::signal_done(std::string filename, int blocks_available, 
			  int blocks_total) {
  sig_done.emit(filename, blocks_available, blocks_total);
}
