# Contributing

Please take a moment to review this document in order to make the contribution process easy and effective for everyone involved.

Following these guidelines helps to communicate that you respect the time of the developers maintaining this project. In return, they should reciprocate that respect in addressing your issue or assessing patches and features.

## Support Requests

The [mailing list](https://discourse.drone.io) is the preferred channel for support requests. Please do not use the issue tracker for personal support requests.

## Feature Requests

Feature requests are welcome. But take a moment to find out whether your idea fits with the scope and aims of this project. It is up to you to make a strong case to convince the developers of the merits of this feature. Please provide as much detail and context as possible.

## Compatibility

This project maintains a strong commitment to backward compatibility. Changing the runtime behavior or configuration in a manner that breaks the public contract should always be avoided.

## Dependencies

This project does not attempt to track the latest version for each dependency. Please only apply the minimal dependency changes required for your patch to work. _If it ain't broke, don't fix it._

## Pull Requests

Please discuss on our [mailing list](https://discourse.drone.io) before embarking on any significant pull request, otherwise you risk spending time working on something the developers might not want to merge into the project.

Pull requests should remain focused in scope and avoid containing unrelated commits. For example, a pull request could add a feature, fix a bug, or format code; but not a mixture.

When you are ready to submit a pull request you can use the below checklist to to increase the likelihood of your pull request being accepted in a timely manner:

- Run the unit tests.
- Format the code.
- Include entry in [CHANGELOG.md](../CHANGELOG.md) that describes the change.
- Include unit tests when you contribute a new feature.
- Include unit tests when you contribute a bug fix to prevent regressions.
