/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.Consumer;

public class Verbose
extends Consumer {
    private int indent = 0;

    private String startLine(int del) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.indent + del; ++i) {
            ret.append("\t");
        }
        return ret.toString();
    }

    private String startLine() {
        return this.startLine(0);
    }

    private void beginCollection(String type) {
        System.out.println(this.startLine() + type + " = {");
        ++this.indent;
    }

    private void endCollection(String type) {
        --this.indent;
        System.out.println(this.startLine() + "} " + type);
    }

    private String beginArray(String type, int len) {
        if (len > 1) {
            this.beginCollection(type + " array");
            System.out.print(this.startLine());
            return "";
        }
        System.out.print(this.startLine() + type + "=");
        return "";
    }

    private void endArray(String type, int len) {
        if (len > 1) {
            System.out.println();
            this.endCollection(type + " array");
        } else {
            System.out.println();
        }
    }

    @Override
    public void listByte(byte[] data) {
        System.out.println(this.startLine() + "byte[] = '" + new String(data) + "'");
    }

    @Override
    public void listInt(int[] data) {
        String indent = this.beginArray("int", data.length);
        for (int i = 0; i < data.length; ++i) {
            System.out.print(indent + data[i] + ", ");
        }
        this.endArray("int", data.length);
    }

    @Override
    public void listFloat(float[] data) {
        String indent = this.beginArray("float", data.length);
        for (int i = 0; i < data.length; ++i) {
            System.out.print(indent + data[i] + ", ");
        }
        this.endArray("float", data.length);
    }

    @Override
    public void listLong(long[] data) {
        String indent = this.beginArray("long", data.length);
        for (int i = 0; i < data.length; ++i) {
            System.out.print(indent + data[i] + ", ");
        }
        this.endArray("long", data.length);
    }

    @Override
    public void listDouble(double[] data) {
        String indent = this.beginArray("double", data.length);
        for (int i = 0; i < data.length; ++i) {
            System.out.print(indent + data[i] + ", ");
        }
        this.endArray("double", data.length);
    }

    @Override
    public void listComment(String cmt) {
        System.out.println(this.startLine() + "//" + cmt + "");
    }

    @Override
    public void listSync(int syncCode) {
        switch (syncCode) {
            case 0x71100000: {
                this.beginCollection("array");
                break;
            }
            case 1913651200: {
                this.endCollection("array");
                break;
            }
            case 1897922560: {
                this.beginCollection("list");
                break;
            }
            case 0x72200000: {
                this.endCollection("list");
                break;
            }
            case 1898971136: {
                this.beginCollection("object");
                break;
            }
            case 1915748352: {
                this.endCollection("object");
                break;
            }
            case 1880227840: {
                System.out.println("\n" + this.startLine(-1) + "/* Index */");
                break;
            }
            case 0x70110000: {
                System.out.println(this.startLine(-1) + ",/* Element */");
                break;
            }
            case 0x79000000: {
                System.out.println(this.startLine() + ",/* --- end of system crap ---- */");
                break;
            }
            default: {
                System.out.println(this.startLine() + "  (sync=0x" + Integer.toHexString(syncCode) + ")");
            }
        }
    }
}

