# WARNING: Test output is dependent on the order these classes include
# certain modules; i.e. on the 'require' order.
require 'common/domain'
require 'common/user'
require 'mailshears_test'
require 'prune/plugins/davical'
require 'prune/plugins/dovecot'
require 'prune/plugins/postfixadmin'
require 'prune/plugins/roundcube'
require 'prune/prune_runner'


class TestPrune < MailshearsTest

  def check_assertions(actual)
    cfg = configuration()

    # Both of our tests have the same expected output / results, so
    # check them both using the same function.
    expected =
      "DavicalPrune - Removed user booger@example.com (Principal ID: 2).\n" +
      "DovecotPrune - Removed user booger@example.com " +
        "(#{cfg.dovecot_mail_root()}/example.com/booger).\n" +
      "DovecotPrune - Removed user jeremy@example.com " +
        "(#{cfg.dovecot_mail_root()}/example.com/jeremy).\n" +
      "RoundcubePrune - Removed user booger@example.com (User ID: 2).\n"

    assert_equal(expected, actual)

    # Now make sure the database has what we expect.

    dpr = DavicalPrune.new(cfg)
    actual = dpr.list_users()
    expected = [User.new('alice@example.com')]
    assert_equal(expected, actual)

    pfapr = PostfixadminPrune.new(cfg)
    actual = pfapr.list_users()
    expected = [User.new('alice@example.com'),
                User.new('bob@example.com'),
                User.new('adam@example.net'),
                User.new('beth@example.net'),
                User.new('carol@example.net')]
    assert_equal(expected, actual)

    actual = pfapr.list_domains()
    expected = [Domain.new('example.com'), Domain.new('example.net')]
    assert_equal(expected, actual)

    actual = pfapr.list_aliases()
    expected = [{'address' => 'adam@example.net',
                 'goto' => 'adam@example.net'},
                {'address' => 'alice@example.com',
                 'goto' => 'alice@example.com,' +
                           'adam@example.net,' +
                           'bob@example.com,' +
                           'carol@example.net'},
                {'address' => 'beth@example.net',
                 'goto' => 'beth@example.net'},
                {'address' => 'bob@example.com',
                 'goto' => 'bob@example.com'},
                {'address' => 'carol@example.net',
                 'goto' => 'carol@example.net'}]
    expected.each { |e| assert(actual.include?(e)) } # can't sort dicts
    actual.each { |a| assert(expected.include?(a)) } # can't sort dicts

    rpr = RoundcubePrune.new(cfg)
    actual = rpr.list_users()
    expected = [User.new('alice@example.com'), User.new('adam@example.net')]
    assert_equal(expected, actual)

    # Booger and Jeremy should get pruned.
    assert(maildir_exists('example.com/alice'))
    assert(maildir_exists('example.net/adam'))
    assert(!maildir_exists('example.com/booger'))
    assert(!maildir_exists('example.com/jeremy'))
  end


  def test_single_prune()
    # Run prune once and see what happens.
    cfg = configuration()

    output_buffer = StringIO.new()

    $stdout = output_buffer
    PrunePlugin.run(cfg)
    $stdout = STDOUT

    actual = output_buffer.string()

    check_assertions(actual)
  end


  def test_double_prune
    # Run prune twice. This should have the exact same output as
    # running it once, since the second time around, there's nothing
    # to prune.
    cfg = configuration()

    output_buffer = StringIO.new()

    $stdout = output_buffer
    PrunePlugin.run(cfg)
    PrunePlugin.run(cfg)
    $stdout = STDOUT

    actual = output_buffer.string()

    check_assertions(actual)
  end

end
