/* This is a magic record, always included as the first row of the
 * domain table.
 */
INSERT INTO domain (domain) VALUES ('ALL');

/* Create two domains, example.com, and example.net. */
INSERT INTO domain (domain) VALUES ('example.com');
INSERT INTO domain (domain) VALUES ('example.net');

/*
 * Now create their mailboxes, two in one domain, and three in the
 * other.
 */
INSERT INTO mailbox (username, domain, local_part)
             VALUES ('alice@example.com', 'example.com', 'alice');
INSERT INTO mailbox (username, domain, local_part)
             VALUES ('bob@example.com', 'example.com', 'bob');

INSERT INTO mailbox (username, domain, local_part)
  VALUES ('adam@example.net', 'example.net', 'adam');
INSERT INTO mailbox (username, domain, local_part)
  VALUES ('beth@example.net', 'example.net', 'beth');
INSERT INTO mailbox (username, domain, local_part)
  VALUES ('carol@example.net', 'example.net', 'carol');

/* Each mailbox has an alias pointing to (at least) itself. */
INSERT INTO alias (address, goto, domain)
  VALUES ('bob@example.com', 'bob@example.com', 'example.com');
INSERT INTO alias (address, goto, domain)
  VALUES ('adam@example.net', 'adam@example.net', 'example.net');
INSERT INTO alias (address, goto, domain)
  VALUES ('beth@example.net', 'beth@example.net', 'example.net');
INSERT INTO alias (address, goto, domain)
  VALUES ('carol@example.net', 'carol@example.net', 'example.net');

/* Alice is aliased to some other people, too. */
INSERT INTO alias (address, goto, domain)
  VALUES
    ('alice@example.com',
     'alice@example.com,adam@example.net,bob@example.com,carol@example.net',
     'example.com');

/* Create a domain admin for both example.com and example.net. */
INSERT INTO domain_admins (username, domain)
  VALUES ('admin@example.com', 'example.com');
INSERT INTO domain_admins (username, domain)
  VALUES ('admin@example.com', 'example.net');

