#!/bin/sh
#
# This script installs the test fixtures into the default databases on
# localhost assuming everything is configured just right. Don't worry
# about this, go play with something else.
#
rm -rf /tmp/mailshears-test
mkdir -p /tmp/mailshears-test/example.com/alice
mkdir -p /tmp/mailshears-test/example.com/booger
mkdir -p /tmp/mailshears-test/example.com/jeremy
mkdir -p /tmp/mailshears-test/example.net/adam

dropdb --if-exists -U postgres davical
createdb -U postgres davical
psql -U postgres -d davical < test/sql/davical.sql
psql -U postgres -d davical < test/sql/davical-fixtures.sql

dropdb --if-exists -U postgres postfixadmin
createdb -U postgres postfixadmin
psql -U postgres -d postfixadmin < test/sql/postfixadmin.sql
psql -U postgres -d postfixadmin < test/sql/postfixadmin-fixtures.sql

dropdb --if-exists -U postgres roundcube
createdb -U postgres roundcube
psql -U postgres -d roundcube < test/sql/roundcube.sql
psql -U postgres -d roundcube < test/sql/roundcube-fixtures.sql
