require 'fileutils'

require 'common/dovecot_plugin'
require 'rm/rm_plugin'


# Handle the removal of users and domains from the Dovecot mailstore
# (the filesystem).
#
class DovecotRm

  include DovecotPlugin
  include RmPlugin


  # Remove *domain* from the Dovecot mailstore. This just runs "rm -r"
  # on the domain directory if it exists.
  #
  # @param domain [Domain] the domain to remove.
  #
  def remove_domain(domain)
    domain_path = self.get_domain_path(domain)

    if not File.directory?(domain_path)
      raise NonexistentDomainError.new(domain.to_s())
    end

    FileUtils.rm_r(domain_path)
  end


  # Remove *user* from the Dovecot mailstore. This just runs "rm -r"
  # on the *user*'s mailbox directory, if it exists.
  #
  # @param user [User] the user whose mailbox directory we want to
  #   remove.
  #
  def remove_user(user)
    user_path = self.get_user_path(user)

    if not File.directory?(user_path)
      raise NonexistentUserError.new(user.to_s())
    end

    FileUtils.rm_r(user_path)
  end

end
