require 'common/runner'
require 'prune/plugins/postfixadmin'
require 'rm/rm_runner'

# Perform the pruning of users/domains using {PrunePlugin}s.
#
class PruneRunner
  include Runner

  # Run *plugin* to prune leftover users and directories.
  #
  # @param cfg [Configuration] configuration options passed to
  # {PostfixadminPrune}.
  #
  # @param plugin [Class] plugin class that will perform the pruning.
  #
  def run(cfg, plugin)
    # We don't want to check the PostfixAdmin database against itself.
    return if plugin.class == PostfixadminPrune

    pfa = PostfixadminPrune.new(cfg)

    db_users = pfa.list_users()
    db_domains = pfa.list_domains()

    leftovers  = plugin.get_leftover_users(db_users)
    leftovers += plugin.get_leftover_domains(db_domains)

    # We're counting on our PrunePlugin also being an RmPlugin here.
    rm_runner = RmRunner.new()
    rm_runner.run(cfg, plugin, *leftovers)
  end

end
