require 'common/runner'
require 'prune/plugins/postfixadmin'
require 'rm/rm_dummy_runner'

# Dummy implementation of a {PruneRunner}. Its <tt>run()</tt> method will
# tell you what would have been pruned, but will not actually perform
# the operation.
#
class PruneDummyRunner
  include Runner


  # Pretend to prune unused domains and users. Some "what if"
  # information will be output to stdout.
  #
  # The prune mode is the main application of the "dummy" runners,
  # since it performs some computation outside of the plugins
  # themselves. This lets the user know which users and domains would
  # be removed and can help prevent mistakes or even find bugs in the
  # prune code, if it looks like something will be removed that
  # shouldn't be!
  #
  # @param cfg [Configuration] the configuration options to pass to
  #   the *plugin* we're runnning.
  #
  # @param plugin [Class] plugin class that will do the pruning.
  #
  def run(cfg, plugin)
    # We don't want to check the PostfixAdmin database against itself.
    return if plugin.class == PostfixadminPrune

    pfa = PostfixadminPrune.new(cfg)

    db_users = pfa.list_users()
    db_domains = pfa.list_domains()

    leftovers  = plugin.get_leftover_users(db_users)
    leftovers += plugin.get_leftover_domains(db_domains)

    rm_dummy_runner = RmDummyRunner.new()
    rm_dummy_runner.run(cfg, plugin, *leftovers)
  end

end
