require 'pg'

require 'common/davical_plugin'
require 'mv/mv_plugin'

# Handle moving (renaming) DAViCal users in its database. DAViCal has
# no concept of domains.
#
class DavicalMv
  include DavicalPlugin
  include MvPlugin


  # Move the user *src* to *dst* within the DAViCal database. This
  # should "rename" him in _every_ table where he is referenced.
  # DAViCal uses foreign keys properly, so we let the ON UPDATE
  # CASCADE trigger handle most of the work.
  #
  # This can fail is *src* does not exist, or if *dst* already exists
  # before the move. It should also be an error if the destination
  # domain doesn't exist. But DAViCal doesn't know about domains, so
  # we let that slide.
  #
  # @param src [User] the source user to be moved.
  #
  # @param dst [User] the destination user being moved to.
  #
  def mv_user(src, dst)
    raise NonexistentUserError.new(src.to_s()) if not user_exists(src)
    raise UserAlreadyExistsError.new(dst.to_s()) if user_exists(dst)

    sql_query = 'UPDATE usr SET username = $1 WHERE username = $2;'

    connection = PG::Connection.new(@db_hash)
    begin
      connection.sync_exec_params(sql_query, [dst.to_s(), src.to_s()])
    ensure
      # Make sure the connection gets closed even if the query explodes.
      connection.close()
    end
  end

end
