require 'common/plugin.rb'

# Plugins for moving (renaming) users. Moving domains is not supported.
#
module MvPlugin

  # Absorb the subclass run() magic from the Plugin::Run module.
  extend Plugin::Run

  # The runner class associated with move plugins.
  #
  # @return [Class] the {MvRunner} class.
  #
  def self.runner()
    return MvRunner
  end


  # The "dummy" runner class associated with move plugins.
  #
  # @return [Class] the {MvDummyRunner} class.
  #
  def self.dummy_runner()
    return MvDummyRunner
  end


  # The interface for the "move a user" operation. Subclasses need to
  # implement this method so that it moves (renames) the user *src* to
  # the user *dst*.
  #
  # @param src [User] the source user to be moved.
  #
  # @param dst [User] the destination user to which we'll move *src*.
  #
  def mv_user(src, dst)
    raise NotImplementedError
  end

end
