# An error indicating that a username is syntactically invalid.
class InvalidUserError < StandardError; end

# An error indicating that a domain is syntactically invalid.
class InvalidDomainError < StandardError; end

# An error indicating that a user does not exist.
class NonexistentUserError < StandardError; end

# An error indicating that a domain does not exist.
class NonexistentDomainError < StandardError; end

# An error indicating that some user already exists. For example, if
# one tries to rename a user and the destination user already exists.
class UserAlreadyExistsError < StandardError; end
