package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAppTasks invokes the unimkt.QueryAppTasks API synchronously
func (client *Client) QueryAppTasks(request *QueryAppTasksRequest) (response *QueryAppTasksResponse, err error) {
	response = CreateQueryAppTasksResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAppTasksWithChan invokes the unimkt.QueryAppTasks API asynchronously
func (client *Client) QueryAppTasksWithChan(request *QueryAppTasksRequest) (<-chan *QueryAppTasksResponse, <-chan error) {
	responseChan := make(chan *QueryAppTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAppTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAppTasksWithCallback invokes the unimkt.QueryAppTasks API asynchronously
func (client *Client) QueryAppTasksWithCallback(request *QueryAppTasksRequest, callback func(response *QueryAppTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAppTasksResponse
		var err error
		defer close(result)
		response, err = client.QueryAppTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAppTasksRequest is the request struct for api QueryAppTasks
type QueryAppTasksRequest struct {
	*requests.RpcRequest
	TaskType  string           `position:"Query" name:"TaskType"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
	TaskId    requests.Integer `position:"Query" name:"TaskId"`
}

// QueryAppTasksResponse is the response struct for api QueryAppTasks
type QueryAppTasksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryAppTasksRequest creates a request to invoke QueryAppTasks API
func CreateQueryAppTasksRequest() (request *QueryAppTasksRequest) {
	request = &QueryAppTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryAppTasks", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryAppTasksResponse creates a response to parse from QueryAppTasks response
func CreateQueryAppTasksResponse() (response *QueryAppTasksResponse) {
	response = &QueryAppTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
