package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagHa invokes the smartag.ModifySagHa API synchronously
func (client *Client) ModifySagHa(request *ModifySagHaRequest) (response *ModifySagHaResponse, err error) {
	response = CreateModifySagHaResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagHaWithChan invokes the smartag.ModifySagHa API asynchronously
func (client *Client) ModifySagHaWithChan(request *ModifySagHaRequest) (<-chan *ModifySagHaResponse, <-chan error) {
	responseChan := make(chan *ModifySagHaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagHa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagHaWithCallback invokes the smartag.ModifySagHa API asynchronously
func (client *Client) ModifySagHaWithCallback(request *ModifySagHaRequest, callback func(response *ModifySagHaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagHaResponse
		var err error
		defer close(result)
		response, err = client.ModifySagHa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagHaRequest is the request struct for api ModifySagHa
type ModifySagHaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	VirtualIp            string           `position:"Query" name:"VirtualIp"`
	Mode                 string           `position:"Query" name:"Mode"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
	PortName             string           `position:"Query" name:"PortName"`
}

// ModifySagHaResponse is the response struct for api ModifySagHa
type ModifySagHaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagHaRequest creates a request to invoke ModifySagHa API
func CreateModifySagHaRequest() (request *ModifySagHaRequest) {
	request = &ModifySagHaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagHa", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySagHaResponse creates a response to parse from ModifySagHa response
func CreateModifySagHaResponse() (response *ModifySagHaResponse) {
	response = &ModifySagHaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
