package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGatewaySMBUser invokes the sgw.CreateGatewaySMBUser API synchronously
func (client *Client) CreateGatewaySMBUser(request *CreateGatewaySMBUserRequest) (response *CreateGatewaySMBUserResponse, err error) {
	response = CreateCreateGatewaySMBUserResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewaySMBUserWithChan invokes the sgw.CreateGatewaySMBUser API asynchronously
func (client *Client) CreateGatewaySMBUserWithChan(request *CreateGatewaySMBUserRequest) (<-chan *CreateGatewaySMBUserResponse, <-chan error) {
	responseChan := make(chan *CreateGatewaySMBUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGatewaySMBUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewaySMBUserWithCallback invokes the sgw.CreateGatewaySMBUser API asynchronously
func (client *Client) CreateGatewaySMBUserWithCallback(request *CreateGatewaySMBUserRequest, callback func(response *CreateGatewaySMBUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewaySMBUserResponse
		var err error
		defer close(result)
		response, err = client.CreateGatewaySMBUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewaySMBUserRequest is the request struct for api CreateGatewaySMBUser
type CreateGatewaySMBUserRequest struct {
	*requests.RpcRequest
	Password      string `position:"Query" name:"Password"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
	Username      string `position:"Query" name:"Username"`
}

// CreateGatewaySMBUserResponse is the response struct for api CreateGatewaySMBUser
type CreateGatewaySMBUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateCreateGatewaySMBUserRequest creates a request to invoke CreateGatewaySMBUser API
func CreateCreateGatewaySMBUserRequest() (request *CreateGatewaySMBUserRequest) {
	request = &CreateGatewaySMBUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CreateGatewaySMBUser", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGatewaySMBUserResponse creates a response to parse from CreateGatewaySMBUser response
func CreateCreateGatewaySMBUserResponse() (response *CreateGatewaySMBUserResponse) {
	response = &CreateGatewaySMBUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
