package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddEnterpriseMember invokes the rdc.AddEnterpriseMember API synchronously
// api document: https://help.aliyun.com/api/rdc/addenterprisemember.html
func (client *Client) AddEnterpriseMember(request *AddEnterpriseMemberRequest) (response *AddEnterpriseMemberResponse, err error) {
	response = CreateAddEnterpriseMemberResponse()
	err = client.DoAction(request, response)
	return
}

// AddEnterpriseMemberWithChan invokes the rdc.AddEnterpriseMember API asynchronously
// api document: https://help.aliyun.com/api/rdc/addenterprisemember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddEnterpriseMemberWithChan(request *AddEnterpriseMemberRequest) (<-chan *AddEnterpriseMemberResponse, <-chan error) {
	responseChan := make(chan *AddEnterpriseMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddEnterpriseMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddEnterpriseMemberWithCallback invokes the rdc.AddEnterpriseMember API asynchronously
// api document: https://help.aliyun.com/api/rdc/addenterprisemember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddEnterpriseMemberWithCallback(request *AddEnterpriseMemberRequest, callback func(response *AddEnterpriseMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddEnterpriseMemberResponse
		var err error
		defer close(result)
		response, err = client.AddEnterpriseMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddEnterpriseMemberRequest is the request struct for api AddEnterpriseMember
type AddEnterpriseMemberRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	StaffId    string `position:"Query" name:"StaffId"`
	Operator   string `position:"Query" name:"Operator"`
}

// AddEnterpriseMemberResponse is the response struct for api AddEnterpriseMember
type AddEnterpriseMemberResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateAddEnterpriseMemberRequest creates a request to invoke AddEnterpriseMember API
func CreateAddEnterpriseMemberRequest() (request *AddEnterpriseMemberRequest) {
	request = &AddEnterpriseMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "AddEnterpriseMember", "rdc", "openAPI")
	return
}

// CreateAddEnterpriseMemberResponse creates a response to parse from AddEnterpriseMember response
func CreateAddEnterpriseMemberResponse() (response *AddEnterpriseMemberResponse) {
	response = &AddEnterpriseMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
