package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HandleComplaint invokes the qualitycheck.HandleComplaint API synchronously
func (client *Client) HandleComplaint(request *HandleComplaintRequest) (response *HandleComplaintResponse, err error) {
	response = CreateHandleComplaintResponse()
	err = client.DoAction(request, response)
	return
}

// HandleComplaintWithChan invokes the qualitycheck.HandleComplaint API asynchronously
func (client *Client) HandleComplaintWithChan(request *HandleComplaintRequest) (<-chan *HandleComplaintResponse, <-chan error) {
	responseChan := make(chan *HandleComplaintResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HandleComplaint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HandleComplaintWithCallback invokes the qualitycheck.HandleComplaint API asynchronously
func (client *Client) HandleComplaintWithCallback(request *HandleComplaintRequest, callback func(response *HandleComplaintResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HandleComplaintResponse
		var err error
		defer close(result)
		response, err = client.HandleComplaint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HandleComplaintRequest is the request struct for api HandleComplaint
type HandleComplaintRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// HandleComplaintResponse is the response struct for api HandleComplaint
type HandleComplaintResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateHandleComplaintRequest creates a request to invoke HandleComplaint API
func CreateHandleComplaintRequest() (request *HandleComplaintRequest) {
	request = &HandleComplaintRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "HandleComplaint", "", "")
	request.Method = requests.POST
	return
}

// CreateHandleComplaintResponse creates a response to parse from HandleComplaint response
func CreateHandleComplaintResponse() (response *HandleComplaintResponse) {
	response = &HandleComplaintResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
