package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainStreamWaterLevel invokes the live.DescribeLiveDomainStreamWaterLevel API synchronously
func (client *Client) DescribeLiveDomainStreamWaterLevel(request *DescribeLiveDomainStreamWaterLevelRequest) (response *DescribeLiveDomainStreamWaterLevelResponse, err error) {
	response = CreateDescribeLiveDomainStreamWaterLevelResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainStreamWaterLevelWithChan invokes the live.DescribeLiveDomainStreamWaterLevel API asynchronously
func (client *Client) DescribeLiveDomainStreamWaterLevelWithChan(request *DescribeLiveDomainStreamWaterLevelRequest) (<-chan *DescribeLiveDomainStreamWaterLevelResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainStreamWaterLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainStreamWaterLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainStreamWaterLevelWithCallback invokes the live.DescribeLiveDomainStreamWaterLevel API asynchronously
func (client *Client) DescribeLiveDomainStreamWaterLevelWithCallback(request *DescribeLiveDomainStreamWaterLevelRequest, callback func(response *DescribeLiveDomainStreamWaterLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainStreamWaterLevelResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainStreamWaterLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainStreamWaterLevelRequest is the request struct for api DescribeLiveDomainStreamWaterLevel
type DescribeLiveDomainStreamWaterLevelRequest struct {
	*requests.RpcRequest
	LiveRegion string           `position:"Query" name:"LiveRegion"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainStreamWaterLevelResponse is the response struct for api DescribeLiveDomainStreamWaterLevel
type DescribeLiveDomainStreamWaterLevelResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	LiveUidWaterLevel        LiveUidWaterLevel        `json:"LiveUidWaterLevel" xml:"LiveUidWaterLevel"`
	LiveDomainWaterLevelList LiveDomainWaterLevelList `json:"LiveDomainWaterLevelList" xml:"LiveDomainWaterLevelList"`
}

// CreateDescribeLiveDomainStreamWaterLevelRequest creates a request to invoke DescribeLiveDomainStreamWaterLevel API
func CreateDescribeLiveDomainStreamWaterLevelRequest() (request *DescribeLiveDomainStreamWaterLevelRequest) {
	request = &DescribeLiveDomainStreamWaterLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainStreamWaterLevel", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainStreamWaterLevelResponse creates a response to parse from DescribeLiveDomainStreamWaterLevel response
func CreateDescribeLiveDomainStreamWaterLevelResponse() (response *DescribeLiveDomainStreamWaterLevelResponse) {
	response = &DescribeLiveDomainStreamWaterLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
