package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceByDomainName invokes the cloudcallcenter.GetInstanceByDomainName API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getinstancebydomainname.html
func (client *Client) GetInstanceByDomainName(request *GetInstanceByDomainNameRequest) (response *GetInstanceByDomainNameResponse, err error) {
	response = CreateGetInstanceByDomainNameResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceByDomainNameWithChan invokes the cloudcallcenter.GetInstanceByDomainName API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getinstancebydomainname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceByDomainNameWithChan(request *GetInstanceByDomainNameRequest) (<-chan *GetInstanceByDomainNameResponse, <-chan error) {
	responseChan := make(chan *GetInstanceByDomainNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceByDomainName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceByDomainNameWithCallback invokes the cloudcallcenter.GetInstanceByDomainName API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getinstancebydomainname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceByDomainNameWithCallback(request *GetInstanceByDomainNameRequest, callback func(response *GetInstanceByDomainNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceByDomainNameResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceByDomainName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceByDomainNameRequest is the request struct for api GetInstanceByDomainName
type GetInstanceByDomainNameRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
}

// GetInstanceByDomainNameResponse is the response struct for api GetInstanceByDomainName
type GetInstanceByDomainNameResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Instance       string `json:"Instance" xml:"Instance"`
}

// CreateGetInstanceByDomainNameRequest creates a request to invoke GetInstanceByDomainName API
func CreateGetInstanceByDomainNameRequest() (request *GetInstanceByDomainNameRequest) {
	request = &GetInstanceByDomainNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetInstanceByDomainName", "", "")
	request.Method = requests.POST
	return
}

// CreateGetInstanceByDomainNameResponse creates a response to parse from GetInstanceByDomainName response
func CreateGetInstanceByDomainNameResponse() (response *GetInstanceByDomainNameResponse) {
	response = &GetInstanceByDomainNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
