package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTransitRouter invokes the cbn.DeleteTransitRouter API synchronously
func (client *Client) DeleteTransitRouter(request *DeleteTransitRouterRequest) (response *DeleteTransitRouterResponse, err error) {
	response = CreateDeleteTransitRouterResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTransitRouterWithChan invokes the cbn.DeleteTransitRouter API asynchronously
func (client *Client) DeleteTransitRouterWithChan(request *DeleteTransitRouterRequest) (<-chan *DeleteTransitRouterResponse, <-chan error) {
	responseChan := make(chan *DeleteTransitRouterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTransitRouter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTransitRouterWithCallback invokes the cbn.DeleteTransitRouter API asynchronously
func (client *Client) DeleteTransitRouterWithCallback(request *DeleteTransitRouterRequest, callback func(response *DeleteTransitRouterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTransitRouterResponse
		var err error
		defer close(result)
		response, err = client.DeleteTransitRouter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTransitRouterRequest is the request struct for api DeleteTransitRouter
type DeleteTransitRouterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId      string           `position:"Query" name:"TransitRouterId"`
}

// DeleteTransitRouterResponse is the response struct for api DeleteTransitRouter
type DeleteTransitRouterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTransitRouterRequest creates a request to invoke DeleteTransitRouter API
func CreateDeleteTransitRouterRequest() (request *DeleteTransitRouterRequest) {
	request = &DeleteTransitRouterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeleteTransitRouter", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTransitRouterResponse creates a response to parse from DeleteTransitRouter response
func CreateDeleteTransitRouterResponse() (response *DeleteTransitRouterResponse) {
	response = &DeleteTransitRouterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
