package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDatasourceStatus invokes the aegis.SetDatasourceStatus API synchronously
// api document: https://help.aliyun.com/api/aegis/setdatasourcestatus.html
func (client *Client) SetDatasourceStatus(request *SetDatasourceStatusRequest) (response *SetDatasourceStatusResponse, err error) {
	response = CreateSetDatasourceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetDatasourceStatusWithChan invokes the aegis.SetDatasourceStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/setdatasourcestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetDatasourceStatusWithChan(request *SetDatasourceStatusRequest) (<-chan *SetDatasourceStatusResponse, <-chan error) {
	responseChan := make(chan *SetDatasourceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDatasourceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDatasourceStatusWithCallback invokes the aegis.SetDatasourceStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/setdatasourcestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetDatasourceStatusWithCallback(request *SetDatasourceStatusRequest, callback func(response *SetDatasourceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDatasourceStatusResponse
		var err error
		defer close(result)
		response, err = client.SetDatasourceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDatasourceStatusRequest is the request struct for api SetDatasourceStatus
type SetDatasourceStatusRequest struct {
	*requests.RpcRequest
	ProjectName  string           `position:"Query" name:"ProjectName"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	LogStoreName string           `position:"Query" name:"LogStoreName"`
	Status       requests.Integer `position:"Query" name:"Status"`
	RegionNo     string           `position:"Query" name:"RegionNo"`
}

// SetDatasourceStatusResponse is the response struct for api SetDatasourceStatus
type SetDatasourceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDatasourceStatusRequest creates a request to invoke SetDatasourceStatus API
func CreateSetDatasourceStatusRequest() (request *SetDatasourceStatusRequest) {
	request = &SetDatasourceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "SetDatasourceStatus", "vipaegis", "openAPI")
	return
}

// CreateSetDatasourceStatusResponse creates a response to parse from SetDatasourceStatus response
func CreateSetDatasourceStatusResponse() (response *SetDatasourceStatusResponse) {
	response = &SetDatasourceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
