package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWhiteListStrategyUuidCount invokes the aegis.DescribeWhiteListStrategyUuidCount API synchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategyuuidcount.html
func (client *Client) DescribeWhiteListStrategyUuidCount(request *DescribeWhiteListStrategyUuidCountRequest) (response *DescribeWhiteListStrategyUuidCountResponse, err error) {
	response = CreateDescribeWhiteListStrategyUuidCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWhiteListStrategyUuidCountWithChan invokes the aegis.DescribeWhiteListStrategyUuidCount API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategyuuidcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWhiteListStrategyUuidCountWithChan(request *DescribeWhiteListStrategyUuidCountRequest) (<-chan *DescribeWhiteListStrategyUuidCountResponse, <-chan error) {
	responseChan := make(chan *DescribeWhiteListStrategyUuidCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWhiteListStrategyUuidCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWhiteListStrategyUuidCountWithCallback invokes the aegis.DescribeWhiteListStrategyUuidCount API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategyuuidcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWhiteListStrategyUuidCountWithCallback(request *DescribeWhiteListStrategyUuidCountRequest, callback func(response *DescribeWhiteListStrategyUuidCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWhiteListStrategyUuidCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeWhiteListStrategyUuidCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWhiteListStrategyUuidCountRequest is the request struct for api DescribeWhiteListStrategyUuidCount
type DescribeWhiteListStrategyUuidCountRequest struct {
	*requests.RpcRequest
	SourceIp   string           `position:"Query" name:"SourceIp"`
	StrategyId requests.Integer `position:"Query" name:"StrategyId"`
	Lang       string           `position:"Query" name:"Lang"`
	Type       requests.Integer `position:"Query" name:"Type"`
}

// DescribeWhiteListStrategyUuidCountResponse is the response struct for api DescribeWhiteListStrategyUuidCount
type DescribeWhiteListStrategyUuidCountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	UuidCount int    `json:"UuidCount" xml:"UuidCount"`
}

// CreateDescribeWhiteListStrategyUuidCountRequest creates a request to invoke DescribeWhiteListStrategyUuidCount API
func CreateDescribeWhiteListStrategyUuidCountRequest() (request *DescribeWhiteListStrategyUuidCountRequest) {
	request = &DescribeWhiteListStrategyUuidCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeWhiteListStrategyUuidCount", "vipaegis", "openAPI")
	return
}

// CreateDescribeWhiteListStrategyUuidCountResponse creates a response to parse from DescribeWhiteListStrategyUuidCount response
func CreateDescribeWhiteListStrategyUuidCountResponse() (response *DescribeWhiteListStrategyUuidCountResponse) {
	response = &DescribeWhiteListStrategyUuidCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
