/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.AqlHelperBase;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;

public class PatternAqlHelper
extends AqlHelperBase {
    PatternAqlHelper(ArtifactoryDependenciesClient client, Log log, FileSpec file) throws IOException {
        super(client, log, file);
    }

    @Override
    public void convertFileSpecToAql(FileSpec file) throws IOException {
        super.buildQueryAdditionalParts(file);
        boolean recursive = !"false".equalsIgnoreCase(file.getRecursive());
        this.queryBody = this.buildAqlSearchQuery(file.getPattern(), file.getExcludePatterns(), recursive, file.getProps());
    }

    private String buildAqlSearchQuery(String searchPattern, String[] excludePatterns, boolean recursive, String props) {
        StringBuilder aqlQuery = new StringBuilder();
        searchPattern = this.prepareSearchPattern(searchPattern, true);
        int repoIndex = searchPattern.indexOf("/");
        String repo = searchPattern.substring(0, repoIndex);
        List<PathFilePair> pathFilePairs = this.createPathFilePairs(searchPattern = searchPattern.substring(repoIndex + 1), recursive);
        int pathFilePairsSize = pathFilePairs.size();
        String excludeQuery = this.buildExcludeQuery(excludePatterns, pathFilePairsSize == 0 || recursive, recursive);
        String nePath = this.buildNePathQuery(pathFilePairsSize == 0 || !searchPattern.contains("/"));
        aqlQuery.append("{\"repo\": \"").append(repo).append("\",").append(this.buildPropsQuery(props)).append(nePath).append(excludeQuery).append("\"$or\": [");
        if (pathFilePairsSize == 0) {
            aqlQuery.append(this.buildInnerQuery(".", searchPattern));
        } else {
            for (PathFilePair pair : pathFilePairs) {
                aqlQuery.append(this.buildInnerQuery(pair.getPath(), pair.getFile())).append(",");
            }
            aqlQuery.deleteCharAt(aqlQuery.length() - 1);
        }
        return aqlQuery.append("]}").toString();
    }

    private String prepareSearchPattern(String pattern, boolean startsWithRepo) {
        if (startsWithRepo && !pattern.contains("/")) {
            pattern = pattern + "/";
        }
        if (pattern.endsWith("/")) {
            pattern = pattern + "*";
        }
        return pattern.replaceAll("[()]", "");
    }

    private List<PathFilePair> createPathFilePairs(String pattern, boolean recursive) {
        String name;
        String path;
        String defaultPath = recursive ? "*" : ".";
        ArrayList<PathFilePair> pairs = new ArrayList<PathFilePair>();
        if (pattern.equals("*")) {
            pairs.add(new PathFilePair(defaultPath, "*"));
            return pairs;
        }
        int slashIndex = pattern.lastIndexOf("/");
        if (slashIndex < 0) {
            pairs.add(new PathFilePair(".", pattern));
            path = "";
            name = pattern;
        } else {
            path = pattern.substring(0, slashIndex);
            name = pattern.substring(slashIndex + 1);
            pairs.add(new PathFilePair(path, name));
        }
        if (!recursive) {
            return pairs;
        }
        if (name.equals("*")) {
            path = path + "/*";
            pairs.add(new PathFilePair(path, "*"));
            return pairs;
        }
        pattern = name;
        String[] sections = pattern.split("\\*", -1);
        int size = sections.length;
        for (int i = 0; i < size; ++i) {
            ArrayList<String> options = new ArrayList<String>();
            if (i + 1 < size) {
                options.add(sections[i] + "*/");
            }
            for (String option : options) {
                String str = "";
                for (int j = 0; j < size; ++j) {
                    if (j > 0) {
                        str = str + "*";
                    }
                    str = j == i ? str + option : str + sections[j];
                }
                String[] split = str.split("/", -1);
                String filePath = split[0];
                String fileName = split[1];
                if (fileName.equals("")) {
                    fileName = "*";
                }
                if (!path.equals("") && !path.endsWith("/")) {
                    path = path + "/";
                }
                pairs.add(new PathFilePair(path + filePath, fileName));
            }
        }
        return pairs;
    }

    private String buildExcludeQuery(String[] excludePatterns, boolean useLocalPath, boolean recursive) {
        if (excludePatterns == null) {
            return "";
        }
        ArrayList<PathFilePair> excludePairs = new ArrayList<PathFilePair>();
        for (String excludePattern : excludePatterns) {
            excludePairs.addAll(this.createPathFilePairs(this.prepareSearchPattern(excludePattern, false), recursive));
        }
        StringBuilder excludeQuery = new StringBuilder();
        for (PathFilePair singleExcludePattern : excludePairs) {
            String excludePath = singleExcludePattern.getPath();
            if (!useLocalPath && ".".equals(excludePath)) {
                excludePath = "*";
            }
            excludeQuery.append(String.format("\"$or\": [{\"path\": {\"$nmatch\": \"%s\"}, \"name\": {\"$nmatch\": \"%s\"}}],", excludePath, singleExcludePattern.getFile()));
        }
        return excludeQuery.toString();
    }

    private String buildNePathQuery(boolean includeRoot) {
        return includeRoot ? "" : "\"path\": {\"$ne\": \".\"}, ";
    }

    private String buildPropsQuery(String props) {
        if (props == null || props.equals("")) {
            return "";
        }
        String[] propList = props.split(";");
        StringBuilder query = new StringBuilder();
        for (String prop : propList) {
            String[] keyVal = prop.split("=");
            if (keyVal.length != 2) {
                System.out.print("Invalid props pattern: " + prop);
            }
            String key = keyVal[0];
            String value = keyVal[1];
            query.append("\"@").append(key).append("\": {\"$match\" : \"").append(value).append("\"},");
        }
        return query.toString();
    }

    private String buildInnerQuery(String path, String name) {
        return String.format("{\"$and\": [{\"path\": { \"$match\": \"%s\"},\"name\": { \"$match\": \"%s\"}}]}", path, name);
    }

    private class PathFilePair {
        private String path;
        private String file;

        private PathFilePair(String path, String file) {
            this.path = path;
            this.file = file;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }
}

