/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/

#ifndef VISUAL_H
#define VISUAL_H

#include <SDL.h>

#include "LList.h"
#include "Texture.h"
#include "Particle.h"
#include "Camera.h"
#include "Game.h"
#include "Mesh.h"

class Visual{
	LList<Texture> texturelist;
	LList<Mesh> meshlist;
	char curtex[128];
public:
	LList<Camera> cameralist;
	LList<Particle> particlelist;
	Visual(Game* newgame);
	~Visual();
	void ResetCams();
	void Draw();
	void ShowLoading(float howfar);
	int LoadTexture(char* filename);
	int LoadMesh(char* meshfile);
	void DrawMesh(char* filename);
	int UnLoadTexture(char* filename);
	int UnLoadMesh(char* filename);
	int UseTexture(char* filename);
	void NewParticle(Particle* newpart);
	void UpdateParticles();
	Camera* GetMainCam();
	int InitGL();
	char* HandleGlError(int errornumber);
	unsigned int MakeHash(char* source);
	int SDL_GL_LoadTexture(SDL_Surface *surface, float *texcoord);
	Game* game;

	int score; //the score displayed in the hud, updated from game->score
	
	int verbose;
	int texerrors; //counter used in UseTexture to stop trying to load after many failures.
	TTF_Font* scorefont;
	TTF_Font* menufont;
};

#endif //VISUAL_H
