/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <thrift/test/testset/gen-cpp2/testset_types.h>

namespace apache::thrift::test::testset {

using Types = testing::Types<
    struct_adapted_binary,
    struct_adapted_bool,
    struct_adapted_byte_op_encoded,
    struct_adapted_i32,
    struct_adapted_list_byte,
    struct_adapted_map_i64_bool,
    struct_adapted_map_i64_byte_op_encoded,
    struct_adapted_map_i64_float_op_encoded,
    struct_adapted_map_i64_i64_op_encoded,
    struct_adapted_map_i64_set_string,
    struct_adapted_map_i64_set_string_op_encoded,
    struct_adapted_map_i64_string_op_encoded,
    struct_adapted_map_string_binary,
    struct_adapted_map_string_string_op_encoded,
    struct_adapted_set_adapted_typedef_i64,
    struct_adapted_set_adapted_typedef_string,
    struct_adapted_set_i64,
    struct_adapted_set_string,
    struct_adapted_typedef_bool_alternative_custom_default,
    struct_adapted_typedef_bool_custom_default,
    struct_adapted_typedef_float_alternative_custom_default,
    struct_adapted_typedef_i16_custom_default,
    struct_double,
    struct_double_alternative_custom_default,
    struct_double_alternative_custom_default_op_encoded,
    struct_double_custom_default,
    struct_double_op_encoded,
    struct_empty,
    struct_empty_op_encoded,
    struct_field_adapted_adapted_typedef_byte,
    struct_field_adapted_adapted_typedef_i16,
    struct_field_adapted_adapted_typedef_i32,
    struct_field_adapted_binary_op_encoded,
    struct_field_adapted_bool_op_encoded,
    struct_field_adapted_i16_op_encoded,
    struct_field_adapted_i32_op_encoded,
    struct_field_adapted_i64,
    struct_field_adapted_list_adapted_typedef_string,
    struct_field_adapted_list_binary_op_encoded,
    struct_field_adapted_list_float_op_encoded,
    struct_field_adapted_list_i64,
    struct_field_adapted_map_adapted_typedef_i64_adapted_typedef_byte,
    struct_field_adapted_map_adapted_typedef_i64_adapted_typedef_i32,
    struct_field_adapted_map_adapted_typedef_string_adapted_typedef_double,
    struct_field_adapted_map_string_bool,
    struct_field_adapted_map_string_float_op_encoded,
    struct_field_adapted_map_string_i64,
    struct_field_adapted_set_i64_op_encoded,
    struct_field_adapted_set_string,
    struct_float,
    struct_float_custom_default,
    struct_i16_alternative_custom_default,
    struct_i32,
    struct_i64_op_encoded,
    struct_list_adapted_typedef_double,
    struct_list_bool_cpp_ref,
    struct_list_bool_shared_cpp_ref_op_encoded,
    struct_list_byte_cpp_ref_op_encoded,
    struct_list_double,
    struct_list_i32_cpp_ref,
    struct_list_i32_cpp_ref_op_encoded,
    struct_list_i64_cpp_ref_op_encoded,
    struct_map_adapted_typedef_string_adapted_typedef_byte,
    struct_map_adapted_typedef_string_adapted_typedef_i32,
    struct_map_i64_byte_cpp_ref_op_encoded,
    struct_map_i64_double_cpp_ref_op_encoded,
    struct_map_i64_double_lazy,
    struct_map_i64_double_shared_cpp_ref,
    struct_map_i64_i16_cpp_ref,
    struct_map_i64_i16_op_encoded,
    struct_map_i64_i16_shared_cpp_ref,
    struct_map_i64_i16_shared_cpp_ref_op_encoded,
    struct_map_i64_set_string_lazy,
    struct_map_string_binary_lazy_op_encoded,
    struct_map_string_binary_shared_cpp_ref,
    struct_map_string_bool_op_encoded,
    struct_map_string_i16_op_encoded,
    struct_map_string_i32_cpp_ref,
    struct_map_string_i32_cpp_ref_op_encoded,
    struct_map_string_i32_lazy,
    struct_map_string_i32_shared_cpp_ref_op_encoded,
    struct_map_string_i64,
    struct_map_string_i64_shared_cpp_ref_op_encoded,
    struct_map_string_set_i64_cpp_ref,
    struct_map_string_set_i64_lazy_op_encoded,
    struct_map_string_set_i64_shared_cpp_ref,
    struct_map_string_set_string_shared_cpp_ref_op_encoded,
    struct_map_string_string_lazy_op_encoded,
    struct_map_string_string_shared_cpp_ref_op_encoded,
    struct_optional_binary_custom_default_op_encoded,
    struct_optional_bool_alternative_custom_default,
    struct_optional_i64_alternative_custom_default,
    struct_optional_list_binary_shared_cpp_ref_op_encoded,
    struct_optional_list_bool_box,
    struct_optional_list_bool_cpp_ref,
    struct_optional_list_bool_cpp_ref_op_encoded,
    struct_optional_list_byte,
    struct_optional_list_float_box,
    struct_optional_list_float_box_op_encoded,
    struct_optional_list_float_cpp_ref_op_encoded,
    struct_optional_list_i16,
    struct_optional_list_i32_cpp_ref,
    struct_optional_list_i32_cpp_ref_op_encoded,
    struct_optional_list_string_cpp_ref_op_encoded,
    struct_optional_list_string_shared_cpp_ref_op_encoded,
    struct_optional_map_i64_bool_box_op_encoded,
    struct_optional_map_i64_bool_shared_cpp_ref_op_encoded,
    struct_optional_map_i64_byte_op_encoded,
    struct_optional_map_i64_byte_shared_cpp_ref,
    struct_optional_map_i64_double,
    struct_optional_map_i64_float_shared_cpp_ref,
    struct_optional_map_i64_i16_shared_cpp_ref_op_encoded,
    struct_optional_map_i64_i32_shared_cpp_ref,
    struct_optional_map_i64_i64_op_encoded,
    struct_optional_map_i64_i64_shared_cpp_ref,
    struct_optional_map_i64_set_i64_shared_cpp_ref_op_encoded,
    struct_optional_map_i64_string,
    struct_optional_map_i64_string_box_op_encoded,
    struct_optional_map_string_binary_shared_cpp_ref_op_encoded,
    struct_optional_map_string_bool_cpp_ref_op_encoded,
    struct_optional_map_string_double_cpp_ref_op_encoded,
    struct_optional_map_string_double_shared_cpp_ref_op_encoded,
    struct_optional_map_string_float_cpp_ref_op_encoded,
    struct_optional_map_string_i16_shared_cpp_ref,
    struct_optional_map_string_i64_box,
    struct_optional_map_string_i64_op_encoded,
    struct_optional_map_string_set_i64_op_encoded,
    struct_optional_map_string_set_i64_shared_cpp_ref,
    struct_optional_map_string_set_string_box,
    struct_optional_set_i64_box,
    struct_optional_set_i64_box_op_encoded,
    struct_optional_set_i64_shared_cpp_ref_op_encoded,
    struct_optional_set_string_box,
    struct_optional_set_string_shared_cpp_ref_op_encoded,
    struct_optional_string_custom_default,
    struct_required_binary_alternative_custom_default,
    struct_required_bool,
    struct_required_bool_op_encoded,
    struct_required_byte_custom_default_op_encoded,
    struct_required_double,
    struct_required_float_alternative_custom_default_op_encoded,
    struct_required_i16_custom_default,
    struct_required_i64,
    struct_required_i64_alternative_custom_default_op_encoded,
    struct_required_i64_custom_default,
    struct_required_i64_op_encoded,
    struct_required_list_binary_op_encoded,
    struct_required_list_binary_shared_cpp_ref,
    struct_required_list_binary_shared_cpp_ref_op_encoded,
    struct_required_list_byte,
    struct_required_list_float,
    struct_required_list_i16_cpp_ref_op_encoded,
    struct_required_list_i16_shared_cpp_ref,
    struct_required_list_i32_op_encoded,
    struct_required_list_i32_shared_cpp_ref_op_encoded,
    struct_required_list_string,
    struct_required_map_i64_binary_cpp_ref_op_encoded,
    struct_required_map_i64_binary_shared_cpp_ref_op_encoded,
    struct_required_map_i64_bool,
    struct_required_map_i64_byte_cpp_ref_op_encoded,
    struct_required_map_i64_double,
    struct_required_map_i64_float_shared_cpp_ref,
    struct_required_map_i64_float_shared_cpp_ref_op_encoded,
    struct_required_map_i64_i16_shared_cpp_ref,
    struct_required_map_i64_i32_shared_cpp_ref,
    struct_required_map_i64_i64,
    struct_required_map_i64_i64_cpp_ref_op_encoded,
    struct_required_map_i64_set_i64_op_encoded,
    struct_required_map_i64_set_string_cpp_ref,
    struct_required_map_i64_string_cpp_ref_op_encoded,
    struct_required_map_string_binary_shared_cpp_ref_op_encoded,
    struct_required_map_string_bool_shared_cpp_ref_op_encoded,
    struct_required_map_string_byte_cpp_ref,
    struct_required_map_string_double_op_encoded,
    struct_required_map_string_double_shared_cpp_ref_op_encoded,
    struct_required_map_string_float_op_encoded,
    struct_required_map_string_i16_cpp_ref,
    struct_required_map_string_i16_shared_cpp_ref,
    struct_required_map_string_i32,
    struct_required_map_string_i32_shared_cpp_ref_op_encoded,
    struct_required_map_string_set_string_shared_cpp_ref_op_encoded,
    struct_required_set_string_shared_cpp_ref_op_encoded,
    struct_required_string,
    struct_set_adapted_typedef_i64,
    struct_set_i64,
    struct_set_i64_cpp_ref_op_encoded,
    struct_set_string,
    struct_terse_byte_op_encoded,
    struct_terse_double,
    struct_terse_i32,
    struct_terse_list_binary_op_encoded,
    struct_terse_list_binary_shared_cpp_ref,
    struct_terse_list_byte_cpp_ref,
    struct_terse_list_byte_shared_cpp_ref_op_encoded,
    struct_terse_list_double,
    struct_terse_list_float_cpp_ref,
    struct_terse_list_i16,
    struct_terse_list_i16_cpp_ref,
    struct_terse_list_i32_cpp_ref_op_encoded,
    struct_terse_list_i64_cpp_ref,
    struct_terse_list_string_shared_cpp_ref,
    struct_terse_map_i64_binary,
    struct_terse_map_i64_bool,
    struct_terse_map_i64_bool_cpp_ref_op_encoded,
    struct_terse_map_i64_byte_shared_cpp_ref_op_encoded,
    struct_terse_map_i64_i64_shared_cpp_ref_op_encoded,
    struct_terse_map_i64_set_string_op_encoded,
    struct_terse_map_string_binary_cpp_ref_op_encoded,
    struct_terse_map_string_double_cpp_ref,
    struct_terse_map_string_double_shared_cpp_ref_op_encoded,
    struct_terse_map_string_float_op_encoded,
    struct_terse_map_string_i16_cpp_ref,
    struct_terse_map_string_i16_cpp_ref_op_encoded,
    struct_terse_map_string_i16_shared_cpp_ref_op_encoded,
    struct_terse_map_string_i32_cpp_ref,
    struct_terse_map_string_i32_shared_cpp_ref,
    struct_terse_map_string_i64_cpp_ref_op_encoded,
    struct_terse_map_string_set_string_cpp_ref,
    struct_terse_map_string_string_cpp_ref,
    struct_terse_set_i64_cpp_ref_op_encoded,
    struct_terse_set_i64_op_encoded,
    struct_terse_set_string,
    struct_terse_set_string_cpp_ref,
    union_adapted_typedef_bool,
    union_list_adapted_typedef_byte,
    union_list_adapted_typedef_string,
    union_list_bool_shared_cpp_ref_op_encoded,
    union_list_double_cpp_ref,
    union_list_double_op_encoded,
    union_list_string,
    union_map_adapted_typedef_string_adapted_typedef_binary,
    union_map_i64_bool_cpp_ref_op_encoded,
    union_map_i64_byte_shared_cpp_ref_op_encoded,
    union_map_i64_float_cpp_ref,
    union_map_i64_float_shared_cpp_ref,
    union_map_i64_i16_shared_cpp_ref,
    union_map_i64_i32_cpp_ref,
    union_map_i64_i64,
    union_map_i64_i64_shared_cpp_ref_op_encoded,
    union_map_string_bool_shared_cpp_ref,
    union_map_string_byte_op_encoded,
    union_map_string_i32,
    union_map_string_i32_shared_cpp_ref_op_encoded,
    union_map_string_i64,
    union_map_string_set_i64,
    union_map_string_set_i64_op_encoded,
    union_map_string_set_i64_shared_cpp_ref,
    union_map_string_string_cpp_ref_op_encoded,
    union_map_string_string_op_encoded,
    union_set_adapted_typedef_string,
    union_set_i64_shared_cpp_ref_op_encoded,
    union_set_string_shared_cpp_ref>;

#define THRIFT_INST_TESTSET_ALL(Test) \
  INSTANTIATE_TYPED_TEST_CASE_P(      \
      types, Test, apache::thrift::test::testset::Types)

} // namespace apache::thrift::test::testset
