/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.victory;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import megamek.common.IGame;
import megamek.common.Player;
import megamek.common.Report;
import megamek.server.victory.AbstractBVVictory;
import megamek.server.victory.SimpleNoResult;
import megamek.server.victory.Victory;
import megamek.server.victory.VictoryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BVRatioVictory
extends AbstractBVVictory {
    private static final long serialVersionUID = -6622529899835634696L;
    protected int ratio;

    public BVRatioVictory(int n) {
        this.ratio = n;
    }

    @Override
    public Victory.Result victory(IGame iGame, HashMap<String, Object> hashMap) {
        boolean bl = false;
        VictoryResult victoryResult = new VictoryResult(true);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Enumeration<Player> enumeration = iGame.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (player.isObserver()) continue;
            int n = 0;
            int n2 = 0;
            int n3 = player.getTeam();
            if (n3 != 0) {
                if (hashSet.contains(n3)) continue;
                hashSet.add(n3);
            }
            n = this.getFriendlyBV(iGame, player);
            n2 = this.getEnemyBV(iGame, player);
            if (n2 != 0 && 100 * n / n2 < this.ratio) continue;
            Report report = new Report(7100, 0);
            bl = true;
            if (n3 == 0) {
                report.add(player.getName());
                victoryResult.addPlayerScore(player.getId(), 1.0);
            } else {
                report.add("Team " + n3);
                victoryResult.addTeamScore(n3, 1.0);
            }
            report.add(n2 == 0 ? 9999 : 100 * n / n2);
            victoryResult.addReport(report);
        }
        if (bl) {
            return victoryResult;
        }
        return new SimpleNoResult();
    }
}

