/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.Messages;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.PMAreasGroup;
import megamek.client.ui.swing.widget.PMSimpleLabel;
import megamek.client.ui.swing.widget.PMSimplePolygonArea;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PMValueLabel;
import megamek.client.ui.swing.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.LargeSupportTank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LargeSupportTankMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private JComponent comp;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[15];
    private PMSimpleLabel[] labels = new PMSimpleLabel[16];
    private PMValueLabel[] vLabels = new PMValueLabel[16];
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private Polygon frontArmor = new Polygon(new int[]{0, 23, 157, 180, 157, 118, 62, 23}, new int[]{30, 7, 7, 30, 41, 25, 25, 41}, 8);
    private Polygon frontIS = new Polygon(new int[]{23, 62, 118, 157, 93, 93, 87, 87}, new int[]{41, 25, 25, 41, 73, 42, 42, 73}, 8);
    private Polygon leftFrontArmor = new Polygon(new int[]{0, 0, 23, 23}, new int[]{30, 109, 109, 41}, 4);
    private Polygon leftFrontIS = new Polygon(new int[]{23, 87, 87, 84, 80, 71, 59, 23}, new int[]{41, 73, 80, 80, 87, 87, 109, 109}, 8);
    private Polygon leftRearArmor = new Polygon(new int[]{0, 0, 23, 23}, new int[]{109, 187, 175, 109}, 4);
    private Polygon leftRearIS = new Polygon(new int[]{23, 23, 66, 59, 59}, new int[]{109, 175, 161, 149, 109}, 5);
    private Polygon rightFrontArmor = new Polygon(new int[]{157, 180, 180, 157}, new int[]{41, 30, 109, 109}, 4);
    private Polygon rightFrontIS = new Polygon(new int[]{93, 157, 157, 121, 109, 100, 96, 93}, new int[]{73, 41, 109, 109, 87, 87, 80, 80}, 8);
    private Polygon rightRearArmor = new Polygon(new int[]{157, 180, 180, 157}, new int[]{109, 109, 187, 175}, 4);
    private Polygon rightRearIS = new Polygon(new int[]{121, 157, 157, 114, 121, 121}, new int[]{109, 109, 175, 161, 149, 109}, 6);
    private Polygon rearArmor = new Polygon(new int[]{180, 152, 26, 0, 23, 59, 121, 157}, new int[]{187, 208, 208, 187, 175, 192, 192, 175}, 8);
    private Polygon rearIS = new Polygon(new int[]{157, 121, 59, 23, 66, 76, 105, 114}, new int[]{175, 192, 192, 175, 161, 177, 177, 161}, 8);
    private Polygon turretArmor = new Polygon(new int[]{87, 87, 84, 80, 71, 59, 59, 75, 90, 90, 80, 65, 65, 115, 115, 100, 90, 90, 105, 121, 121, 109, 100, 96, 93, 93}, new int[]{42, 80, 80, 87, 87, 109, 149, 177, 177, 165, 165, 142, 125, 125, 142, 165, 165, 177, 177, 149, 109, 87, 87, 80, 80, 42}, 26);
    private Polygon turretIS = new Polygon(new int[]{65, 65, 80, 100, 115, 115}, new int[]{125, 142, 165, 165, 142, 125}, 6);
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public LargeSupportTankMapSet(JComponent jComponent) {
        this.comp = jComponent;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.setContent();
    }

    public void setRest() {
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        int n;
        LargeSupportTank largeSupportTank = (LargeSupportTank)entity;
        int n2 = 1;
        int n3 = 1;
        for (n = 1; n < 8; ++n) {
            n2 = largeSupportTank.getArmor(n);
            n3 = largeSupportTank.getOArmor(n);
            this.vLabels[n].setValue(largeSupportTank.getArmorString(n));
            WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)n2 / (double)n3);
        }
        for (n = 8; n < 15; ++n) {
            n2 = largeSupportTank.getInternal(n - 8);
            n3 = largeSupportTank.getOInternal(n - 8);
            this.vLabels[n].setValue(largeSupportTank.getInternalString(n - 8));
            WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)n2 / (double)n3);
        }
        this.vLabels[15].setValue(String.valueOf(largeSupportTank.getBARRating()));
    }

    private void setContent() {
        for (int i = 1; i < 15; ++i) {
            this.content.addArea(this.areas[i]);
            this.content.addArea(this.labels[i]);
            this.content.addArea(this.vLabels[i]);
        }
        this.content.addArea(this.labels[15]);
        this.content.addArea(this.vLabels[15]);
    }

    private void setAreas() {
        this.areas[1] = new PMSimplePolygonArea(this.frontArmor);
        this.areas[2] = new PMSimplePolygonArea(this.rightFrontArmor);
        this.areas[3] = new PMSimplePolygonArea(this.leftFrontArmor);
        this.areas[4] = new PMSimplePolygonArea(this.rightRearArmor);
        this.areas[5] = new PMSimplePolygonArea(this.leftRearArmor);
        this.areas[6] = new PMSimplePolygonArea(this.rearArmor);
        this.areas[7] = new PMSimplePolygonArea(this.turretArmor);
        this.areas[8] = new PMSimplePolygonArea(this.frontIS);
        this.areas[9] = new PMSimplePolygonArea(this.rightFrontIS);
        this.areas[10] = new PMSimplePolygonArea(this.leftFrontIS);
        this.areas[11] = new PMSimplePolygonArea(this.rightRearIS);
        this.areas[12] = new PMSimplePolygonArea(this.leftRearIS);
        this.areas[13] = new PMSimplePolygonArea(this.rearIS);
        this.areas[14] = new PMSimplePolygonArea(this.turretIS);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[1] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.FrontArmor"), fontMetrics, Color.black, 85, 15);
        this.labels[2] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.FRS"), fontMetrics, Color.black, 170, 80);
        this.labels[3] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.FLS"), fontMetrics, Color.black, 10, 80);
        this.labels[4] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.RRS"), fontMetrics, Color.black, 170, 155);
        this.labels[5] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.RLS"), fontMetrics, Color.black, 10, 155);
        this.labels[6] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.RearArmor"), fontMetrics, Color.black, 85, 200);
        this.labels[7] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.TurretArmor"), fontMetrics, Color.black, 90, 104);
        this.labels[8] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.FrontIS"), fontMetrics, Color.black, 80, 30);
        this.labels[9] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.FRIS"), fontMetrics, Color.black, 120, 80);
        this.labels[10] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.FLIS"), fontMetrics, Color.black, 43, 80);
        this.labels[11] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.RRIS"), fontMetrics, Color.black, 140, 155);
        this.labels[12] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.RLIS"), fontMetrics, Color.black, 43, 155);
        this.labels[13] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.RearIS"), fontMetrics, Color.black, 85, 185);
        this.labels[14] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.TurretIS"), fontMetrics, Color.black, 90, 140);
        this.labels[15] = WidgetUtils.createLabel(Messages.getString("LargeSupportTankMapSet.BARRating"), fontMetrics, Color.white, 80, 220);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[1] = WidgetUtils.createValueLabel(115, 17, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(164, 70, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(6, 70, "", fontMetrics);
        this.vLabels[4] = WidgetUtils.createValueLabel(164, 140, "", fontMetrics);
        this.vLabels[5] = WidgetUtils.createValueLabel(6, 140, "", fontMetrics);
        this.vLabels[6] = WidgetUtils.createValueLabel(113, 202, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(93, 115, "", fontMetrics);
        this.vLabels[8] = WidgetUtils.createValueLabel(93, 151, "", fontMetrics);
        this.vLabels[9] = WidgetUtils.createValueLabel(140, 65, "", fontMetrics);
        this.vLabels[10] = WidgetUtils.createValueLabel(43, 65, "", fontMetrics);
        this.vLabels[11] = WidgetUtils.createValueLabel(145, 140, "", fontMetrics);
        this.vLabels[12] = WidgetUtils.createValueLabel(43, 140, "", fontMetrics);
        this.vLabels[13] = WidgetUtils.createValueLabel(113, 187, "", fontMetrics);
        this.vLabels[14] = WidgetUtils.createValueLabel(110, 32, "", fontMetrics);
        this.vLabels[15] = WidgetUtils.createValueLabel(110, 222, "", fontMetrics);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }
}

