/***************************************************************************
 *   copyright           : (C) 2004 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smifile.h"
#include <helper.h>
#include "opt.h"
#include <disclaimer.h>
#include <smspdu.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <locale.h>
#include <inttypes.h>

#define PROGRAM_NAME "smi"
#define PROGRAM_VERSION  "0.3"

void output_as_text (FILE* fp,
		     struct sms** messages)
{
  unsigned int i = 0;

  sms_statusreport_match(messages);
  sms_multipart_merge(messages);

  while (messages[i] != NULL) sms_pdu_print(fp,messages[i++],SMS_PRINT_ALL_HEADERS);
}

void output_as_csv (FILE* fp,
		    struct sms** messages)
{
  unsigned int i = 0;
  unsigned int k = 0;
  struct sms_pdu_raw* ptr = NULL;
  char pdu[(SMI_DATA_SIZE*2)+1];

  for (; messages[k] != NULL; ++k) {
    ptr = &messages[k]->encoded[k]->tpdu;
    for (i = 0; i < SMI_DATA_SIZE && i < ptr->size; ++i) {
      snprintf(pdu+(2*i),3,"%02X",ptr->data[i]);
    }
    fprintf(fp,"%s\n",pdu);
  }
}

void process (FILE* fp, char** files) {
  struct sms_slot_data** encoded = NULL;
  struct sms_tpdu* decoded = NULL;
  struct sms** s = NULL;
  unsigned int i = 0;
  unsigned int k = 0;
  struct args_t* args = smi_get_args();

  for (; files[i] != NULL; ++i) {
    encoded = smifile_read(files[i]);
    if (encoded) {
      for (k = 0; encoded[k] != NULL; ++k) {}
      s = mem_alloc((k+1)*sizeof(*s),1);
      for (k = 0; encoded[k] != NULL; ++k) {
	/* decode */
	decoded = sms_pdu_decode(encoded[k]);
	s[k] = mem_alloc(sizeof(**s),0);
	sms_init(s[k],encoded[k],decoded);
      }
      mem_realloc(encoded,0);
    }
    if (args->output == OUTPUT_CSV)
      output_as_csv(fp,s);
    else {
      fprintf(fp,"Content source: file %s\n",files[i]);
      output_as_text(fp,s);
    }

    for (k = 0; s[k] != NULL; ++k) {
      sms_delete(s[k]);
    }
    s = mem_realloc(s,0);
  }
}

int main (int argc, char** argv) {
  FILE* fp = stdout;
  char** files = NULL;
  struct args_t* args;
  int exit_code = EXIT_SUCCESS;

  //set program locale
  setlocale(LC_ALL,"");

  args_init();
  files = smi_args_parse(argc,argv);
  args = smi_get_args();

  if (args->version) {
    print_proginfo(PROGRAM_NAME,PROGRAM_VERSION);
    exit(EXIT_SUCCESS);
  } else if (files == NULL || files[0] == NULL) {
    exit_code = EXIT_FAILURE;
    args->help = 1;
  }
  
  //init charset lib
  charset_init(args->system_charset,1);

  if (args->help) {
    help(argv[0],args_type_list,args_list,"5F??.adr [7F??.adr]");
    fprintf(stderr,
	    "\n"
	    "Files are either .smi/.smo files or the SMS.dat file.\n"
	    "The .smi/.smo files can be found in the /SMS/ flexmem directory.\n"
	    "The SMS.dat file can be found in the /PersistentData/SMS/ flexmem directory.\n");
    exit(exit_code);
  } else {
    print_disclaimer();
  }

  process(fp,files);

  exit(EXIT_SUCCESS);
}
