#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <termios.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "compat.h"

#ifndef HAVE_STRDUP
char *strdup(const char *s)
{
	char *copy;
	if ((copy = malloc(1+strlen(s))))
		strcpy(copy, s);
	return copy;
}
#endif

#ifndef HAVE_GETPASS
void echo_off(void);
void echo_on(void);
int open_tty(void);

#define MAX_PASS_LEN 128
char GETPASS_BUFFER[MAX_PASS_LEN];
static struct termios stored;

void echo_off(void)
{
	struct termios new;
	tcgetattr(0,&stored);
	memcpy(&new, &stored, sizeof(struct termios));
	new.c_lflag &= (~ECHO);
	tcsetattr(0,TCSANOW,&new);
	return;
}

void echo_on(void)
{
	tcsetattr(0,TCSANOW,&stored);
	return;
}

/* TODO: disable signals (ctrl-c/ctrl-z) */
char *getpass(const char *prompt)
{
	char *newline;
	int fd = open_tty();

	fprintf(stderr, "%s", prompt);
	echo_off();
	if (-1==read(fd, GETPASS_BUFFER, MAX_PASS_LEN - 1)) {
		echo_on(); putchar('\n');
		goto error;
	}
	echo_on(); putchar('\n');
	newline = strchr(GETPASS_BUFFER, '\n');
	if (!newline)
		goto error;
	*newline = '\0';
	close(fd);
	return GETPASS_BUFFER;
error:
	GETPASS_BUFFER[0] = '\0';
	close(fd);
	return GETPASS_BUFFER;
}

int open_tty(void)
{
	int fd = open("/dev/tty", O_RDONLY);
	if (fd==-1)
		fd = STDIN_FILENO;
	return fd;
}
#endif
