/*
 * Decompiled with CFR 0.152.
 */
package util.ui.progress;

import devplugin.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.progress.Progress;

public class ProgressWindow
implements ProgressMonitor {
    private JLabel mLabel;
    private JDialog mDialog;
    private JProgressBar mBar;

    public ProgressWindow(Component parent, String msg) {
        this.mDialog = UiUtilities.createDialog(parent, true);
        JPanel content = (JPanel)this.mDialog.getContentPane();
        content.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        content.setLayout(new BorderLayout());
        this.mLabel = new JLabel(msg);
        this.mLabel.setHorizontalAlignment(0);
        content.add((Component)this.mLabel, "Center");
        this.mBar = new JProgressBar();
        this.mBar.setVisible(false);
        content.add((Component)this.mBar, "South");
        this.mDialog.setSize(500, 70);
        this.mDialog.setUndecorated(true);
        this.mDialog.setCursor(Cursor.getPredefinedCursor(3));
    }

    public ProgressWindow(Component parent) {
        this(parent, "");
    }

    public void run(Progress progress) {
        this.run(progress, 0);
    }

    public void run(final Progress progress, final int delaySeconds) {
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread thread = new Thread("Progress window"){

            @Override
            public void run() {
                progress.run();
                done.set(true);
                while (!ProgressWindow.this.mDialog.isVisible() && done.get()) {
                }
                ProgressWindow.this.mDialog.setVisible(false);
                ProgressWindow.this.mDialog.dispose();
            }
        };
        thread.start();
        if (delaySeconds > 0) {
            new Thread("Wait for progress window"){

                @Override
                public void run() {
                    int delayMilliSeconds = delaySeconds * 1000;
                    do {
                        try {
                            2.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while ((delayMilliSeconds -= 100) > 0);
                    if (!done.get()) {
                        UiUtilities.centerAndShow(ProgressWindow.this.mDialog);
                    } else {
                        done.set(false);
                    }
                }
            }.start();
        } else {
            UiUtilities.centerAndShow(this.mDialog);
        }
    }

    @Override
    public void setMaximum(int maximum) {
        UIThreadRunner.invokeLater(() -> {
            if (maximum == -1) {
                this.mBar.setVisible(false);
            } else {
                this.mBar.setMaximum(maximum);
                this.mBar.setVisible(true);
                this.mBar.setStringPainted(true);
            }
        });
    }

    @Override
    public void setValue(int value) {
        UIThreadRunner.invokeLater(() -> this.mBar.setValue(value));
    }

    public void incrementValue() {
        UIThreadRunner.invokeLater(() -> this.mBar.setValue(this.mBar.getValue() + 1));
    }

    @Override
    public void setMessage(String msg) {
        SwingUtilities.invokeLater(() -> this.mLabel.setText(msg));
    }
}

