/*
 * Decompiled with CFR 0.152.
 */
package util.ui.menu;

import devplugin.ActionMenu;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Plugin;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import util.ui.ScrollableMenu;
import util.ui.html.HTMLTextHelper;

public class MenuUtil {
    public static final Font CONTEXT_MENU_PLAINFONT = UIManager.getFont("MenuItem.font").deriveFont(0);
    public static final Font CONTEXT_MENU_BOLDFONT = UIManager.getFont("MenuItem.font").deriveFont(1);
    public static final Font CONTEXT_MENU_ITALICFONT = UIManager.getFont("MenuItem.font").deriveFont(2);
    public static final Font CONTEXT_MENU_BOLDITALICFONT = UIManager.getFont("MenuItem.font").deriveFont(2);

    public static JMenuItem createMenuItem(String title) {
        JMenuItem result = new JMenuItem(title);
        result.setFont(CONTEXT_MENU_PLAINFONT);
        return result;
    }

    public static JMenuItem createMenuItem(ActionMenu menu) {
        return MenuUtil.createMenuItem(menu, null);
    }

    public static JMenuItem createMenuItem(ActionMenu menu, HashSet<Integer> disabledItems) {
        return MenuUtil.createMenuItem(menu, true, disabledItems);
    }

    public static JMenuItem createMenuItem(ActionMenu menu, boolean setFont) {
        return MenuUtil.createMenuItem(menu, setFont, null);
    }

    public static JMenuItem createMenuItem(ActionMenu menu, boolean setFont, HashSet<Integer> disabledItems) {
        if (menu == null) {
            return null;
        }
        JMenuItem result = null;
        if (menu.hasSubItems()) {
            ActionMenu[] subItems;
            result = new ScrollableMenu(menu.getAction());
            for (ActionMenu subItem : subItems = menu.getSubItems()) {
                if (disabledItems != null && disabledItems.contains(subItem.getActionId())) continue;
                JMenuItem item = MenuUtil.createMenuItem(subItem, setFont, disabledItems);
                if (item == null) {
                    ((JMenu)result).addSeparator();
                    continue;
                }
                result.add(item);
            }
        } else {
            if (ContextMenuSeparatorAction.getInstance().equals(menu.getAction())) {
                return null;
            }
            if (menu.getAction() != null) {
                if (menu.isSelected()) {
                    result = new ColoredCheckBoxMenuItem(menu.getAction());
                    result.setSelected(true);
                } else {
                    result = new ColoredMenuItem(menu.getAction());
                }
            }
        }
        if (result != null && setFont) {
            result.setFont(CONTEXT_MENU_PLAINFONT);
        }
        return result;
    }

    private static final class ColoredCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private Color mBackground;
        private String mText = HTMLTextHelper.checkTextForTextFormatingTags(this.getText());

        public ColoredCheckBoxMenuItem(Action action) {
            super(action);
            Object o = action.getValue("MARK_PRIORITY");
            if (o != null && o instanceof Integer) {
                this.mBackground = Plugin.getPluginManager().getTvBrowserSettings().getColorForMarkingPriority((Integer)o);
            }
        }

        @Override
        public void setSelected(boolean b) {
            if (b) {
                this.setIcon(null);
            }
            super.setSelected(b);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isArmed() && this.mText.startsWith("<html>")) {
                this.setText("<html><div style=\"color:" + HTMLTextHelper.getCssRgbColorEntry(UIManager.getColor("MenuItem.selectionForeground")) + "\">" + this.mText.replace("<html>", "").replace("</html>", "<html>") + "</div><html>");
            } else if (this.mText.startsWith("<html>")) {
                this.setText(this.mText);
            }
            if (this.mBackground != null) {
                if (!this.isArmed()) {
                    this.setOpaque(false);
                    Color old = g.getColor();
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(this.mBackground);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(old);
                } else {
                    this.setOpaque(true);
                }
            }
            super.paintComponent(g);
        }
    }

    private static final class ColoredMenuItem
    extends JMenuItem {
        private Color mBackground;
        private String mText = HTMLTextHelper.checkTextForTextFormatingTags(this.getText());

        public ColoredMenuItem(Action action) {
            super(action);
            Object o = action.getValue("MARK_PRIORITY");
            if (o != null && o instanceof Integer) {
                this.mBackground = Plugin.getPluginManager().getTvBrowserSettings().getColorForMarkingPriority((Integer)o);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isArmed() && this.mText.startsWith("<html>")) {
                this.setText("<html><div style=\"color:" + HTMLTextHelper.getCssRgbColorEntry(UIManager.getColor("MenuItem.selectionForeground")) + "\">" + this.mText.replace("<html>", "").replace("</html>", "<html>") + "</div><html>");
            } else if (this.mText.startsWith("<html>")) {
                this.setText(this.mText);
            }
            if (this.mBackground != null) {
                if (!this.isArmed()) {
                    this.setOpaque(false);
                    Color old = g.getColor();
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(this.mBackground);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(old);
                } else {
                    this.setOpaque(true);
                }
            }
            super.paintComponent(g);
        }
    }
}

