/*
 * Decompiled with CFR 0.152.
 */
package util.ui.beanshell;

import java.awt.Color;
import java.util.HashSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class SyntaxDocument
extends DefaultStyledDocument {
    private DefaultStyledDocument doc = this;
    private Element rootElement = this.doc.getDefaultRootElement();
    private boolean multiLineComment;
    private MutableAttributeSet normal;
    private MutableAttributeSet keyword;
    private MutableAttributeSet comment;
    private MutableAttributeSet quote;
    private HashSet<String> keywords;

    public SyntaxDocument() {
        this.putProperty("__EndOfLine__", "\n");
        this.normal = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normal, Color.black);
        this.comment = new SimpleAttributeSet();
        StyleConstants.setForeground(this.comment, Color.gray);
        StyleConstants.setItalic(this.comment, true);
        this.keyword = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword, Color.blue);
        this.quote = new SimpleAttributeSet();
        StyleConstants.setForeground(this.quote, Color.red);
        this.keywords = new HashSet();
        this.keywords.add("abstract");
        this.keywords.add("boolean");
        this.keywords.add("break");
        this.keywords.add("byte");
        this.keywords.add("byvalue");
        this.keywords.add("case");
        this.keywords.add("cast");
        this.keywords.add("catch");
        this.keywords.add("char");
        this.keywords.add("class");
        this.keywords.add("const");
        this.keywords.add("continue");
        this.keywords.add("default");
        this.keywords.add("do");
        this.keywords.add("double");
        this.keywords.add("else");
        this.keywords.add("extends");
        this.keywords.add("false");
        this.keywords.add("final");
        this.keywords.add("finally");
        this.keywords.add("float");
        this.keywords.add("for");
        this.keywords.add("future");
        this.keywords.add("generic");
        this.keywords.add("goto");
        this.keywords.add("if");
        this.keywords.add("implements");
        this.keywords.add("import");
        this.keywords.add("inner");
        this.keywords.add("instanceof");
        this.keywords.add("int");
        this.keywords.add("interface");
        this.keywords.add("long");
        this.keywords.add("native");
        this.keywords.add("new");
        this.keywords.add("null");
        this.keywords.add("operator");
        this.keywords.add("outer");
        this.keywords.add("package");
        this.keywords.add("private");
        this.keywords.add("protected");
        this.keywords.add("public");
        this.keywords.add("rest");
        this.keywords.add("return");
        this.keywords.add("short");
        this.keywords.add("static");
        this.keywords.add("super");
        this.keywords.add("switch");
        this.keywords.add("synchronized");
        this.keywords.add("this");
        this.keywords.add("throw");
        this.keywords.add("throws");
        this.keywords.add("transient");
        this.keywords.add("true");
        this.keywords.add("try");
        this.keywords.add("var");
        this.keywords.add("void");
        this.keywords.add("volatile");
        this.keywords.add("while");
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        int offset = this.rootElement.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset && endDelimiter != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, this.comment, false);
        return true;
    }

    private void commentLinesAfter(String content, int line) {
        int offset = this.rootElement.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.doc.setCharacterAttributes(offset, endDelimiter - offset + 1, this.comment, false);
        }
    }

    private void highlightLinesAfter(String content, int line) throws BadLocationException {
        int delimiter;
        int offset = this.rootElement.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.rootElement.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this.rootElement.getElement(i);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(this.comment)) continue;
            this.applyHighlighting(content, i);
        }
    }

    private void applyHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.doc.setCharacterAttributes(startOffset, endOffset - startOffset + 1, this.comment, false);
            return;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, this.comment, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean value) {
        this.multiLineComment = value;
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this.quote, false);
        return endOfQuote + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        if (this.isKeyword(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.keyword, false);
        }
        return endOfToken + 1;
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character) {
        String operands = ";:{}()[]+-/%<=>!&|^~*";
        return Character.isWhitespace(character.charAt(0)) || operands.indexOf(character) != -1;
    }

    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"'";
        return quoteDelimiters.indexOf(character) >= 0;
    }

    protected boolean isKeyword(String token) {
        return this.keywords.contains(token);
    }

    protected String getStartDelimiter() {
        return "/*";
    }

    protected String getEndDelimiter() {
        return "*/";
    }

    protected String getSingleLineDelimiter() {
        return "//";
    }

    protected String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }
}

