/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Date;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import tvbrowser.core.Settings;
import util.i18n.Localizer;
import util.settings.ProgramPanelSettings;
import util.ui.ProgramPanel;

public class ProgramListCellRenderer
extends DefaultListCellRenderer {
    private static Color FIRST_ROW_COLOR = new Color(220, 220, 220, 150);
    private static Color FIRST_ROW_COLOR_EXPIRED = new Color(220, 220, 220, 55);
    private static Color SECOND_ROW_COLOR = new Color(220, 220, 220, 150);
    private static Color SECOND_ROW_COLOR_EXPIRED = new Color(220, 220, 220, 55);
    private JPanel mMainPanel;
    private JLabel mHeaderLb;
    private JPanel mCenterPanel;
    private ProgramPanel mProgramPanel;
    private HashSet<Program> mProgramSet = new HashSet();
    private JPanel mDateSeparator;
    private JLabel mDateLabel;
    private boolean mShowDateSeparators;

    public ProgramListCellRenderer() {
        this(new ProgramPanelSettings(0, -1, -1, false, true, 10));
    }

    public ProgramListCellRenderer(ProgramPanelSettings settings) {
        this(settings, false);
    }

    public ProgramListCellRenderer(ProgramPanelSettings settings, boolean showDateSeparators) {
        SECOND_ROW_COLOR = UIManager.getColor("List.foreground");
        SECOND_ROW_COLOR = new Color(SECOND_ROW_COLOR.getRed(), SECOND_ROW_COLOR.getGreen(), SECOND_ROW_COLOR.getBlue(), 30);
        SECOND_ROW_COLOR_EXPIRED = UIManager.getColor("List.foreground");
        SECOND_ROW_COLOR_EXPIRED = new Color(SECOND_ROW_COLOR_EXPIRED.getRed(), SECOND_ROW_COLOR_EXPIRED.getGreen(), SECOND_ROW_COLOR_EXPIRED.getBlue(), 15);
        FIRST_ROW_COLOR = UIManager.getColor("List.background");
        FIRST_ROW_COLOR = new Color(FIRST_ROW_COLOR.getRed(), FIRST_ROW_COLOR.getGreen(), FIRST_ROW_COLOR.getBlue(), 30);
        FIRST_ROW_COLOR_EXPIRED = UIManager.getColor("List.background");
        FIRST_ROW_COLOR_EXPIRED = new Color(FIRST_ROW_COLOR_EXPIRED.getRed(), FIRST_ROW_COLOR_EXPIRED.getGreen(), FIRST_ROW_COLOR_EXPIRED.getBlue(), 15);
        this.initializeSettings(settings, showDateSeparators);
    }

    private void initializeSettings(ProgramPanelSettings settings, boolean showDateSeparators) {
        this.mMainPanel = new JPanel(new BorderLayout());
        this.mMainPanel.setOpaque(true);
        this.mHeaderLb = new JLabel();
        this.mProgramPanel = new ProgramPanel(settings);
        this.mCenterPanel = new JPanel(new BorderLayout());
        this.mCenterPanel.setOpaque(true);
        this.mCenterPanel.add((Component)this.mHeaderLb, "North");
        this.mCenterPanel.add((Component)this.mProgramPanel, "Center");
        Settings.addFontChangeListener(e -> this.mProgramPanel.forceRepaint());
        this.mDateSeparator = new JPanel((LayoutManager)new FormLayout("0dlu:grow,default,0dlu:grow", "5dlu,default,5dlu"));
        this.mDateSeparator.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, UIManager.getColor("Label.foreground")));
        this.mDateLabel = new JLabel();
        this.mDateLabel.setFont(this.mDateLabel.getFont().deriveFont(this.mDateLabel.getFont().getSize2D() + 4.0f).deriveFont(1));
        this.mDateSeparator.add((Component)this.mDateLabel, new CellConstraints().xy(2, 2));
        this.mShowDateSeparators = showDateSeparators;
        this.mMainPanel.add((Component)this.mDateSeparator, "North");
        this.mMainPanel.add((Component)this.mCenterPanel, "Center");
    }

    public void setShowDateSeparators(boolean show) {
        this.mShowDateSeparators = show;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null && value instanceof Program) {
            Program program = (Program)value;
            boolean addDateSeparator = false;
            if (this.mShowDateSeparators) {
                Object test;
                Date d = program.getDate();
                addDateSeparator = index == 0 ? true : (test = list.getModel().getElementAt(index - 1)) instanceof Program && d.compareTo(((Program)test).getDate()) >= 1;
            }
            this.mProgramPanel.setWidth(list.getWidth());
            this.mProgramPanel.setProgram(program);
            this.mProgramPanel.setPaintExpiredProgramsPale(!isSelected);
            this.mProgramPanel.setBackground(label.getBackground());
            this.mProgramPanel.setSelectedInList(isSelected);
            if (!this.mProgramSet.contains(program)) {
                this.mProgramSet.add(program);
                program.addChangeListener(new ProgramListChangeListener(list));
            }
            StringBuilder labelString = new StringBuilder();
            int days = program.getDate().getNumberOfDaysSince(Date.getCurrentDate());
            switch (days) {
                case -1: {
                    labelString.append(Localizer.getLocalization("i18n_yesterday"));
                    labelString.append(", ").append(program.getDateString());
                    break;
                }
                case 0: {
                    labelString.append(Localizer.getLocalization("i18n_today"));
                    labelString.append(", ").append(program.getDateString());
                    break;
                }
                case 1: {
                    labelString.append(Localizer.getLocalization("i18n_tomorrow"));
                    labelString.append(", ").append(program.getDateString());
                    break;
                }
                default: {
                    labelString.append(program.getDate().toString());
                }
            }
            labelString.append(" - ").append(program.getChannel().getName());
            this.mHeaderLb.setText(labelString.toString());
            if (program.isExpired() && !isSelected) {
                this.mHeaderLb.setForeground(Color.gray);
            } else {
                this.mHeaderLb.setForeground(this.mProgramPanel.getForeground());
            }
            if (isSelected) {
                this.mCenterPanel.setBackground(Settings.ProgramPanel.COLOR_KEYBOARD_SELECTED.getColor());
            } else {
                this.mCenterPanel.setBackground(label.getBackground());
            }
            this.mCenterPanel.setEnabled(label.isEnabled());
            if (!isSelected && program.getMarkPriorityMax() < 0) {
                if ((index & 1) == 1) {
                    this.mCenterPanel.setBackground(program.isExpired() ? SECOND_ROW_COLOR_EXPIRED : SECOND_ROW_COLOR);
                } else {
                    this.mCenterPanel.setBackground(program.isExpired() ? FIRST_ROW_COLOR_EXPIRED : FIRST_ROW_COLOR);
                }
            }
            this.mDateSeparator.setVisible(addDateSeparator);
            if (addDateSeparator) {
                this.mDateLabel.setText(program.getDateString());
            }
            return this.mMainPanel;
        }
        return label;
    }

    private static final class ProgramListChangeListener
    implements ChangeListener {
        private final JList<?> mList;

        private ProgramListChangeListener(JList<?> list) {
            this.mList = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            Object source;
            if (this.mList == null || !((source = e.getSource()) instanceof Program)) return;
            Program program = (Program)source;
            ListDataListener[] model = (ListDataListener[])this.mList.getModel();
            ListDataListener[] listeners = model.getListDataListeners();
            int itemIndex = -1;
            ListDataListener[] listDataListenerArray = model;
            synchronized (model) {
                for (int i = 0; i < model.getSize(); ++i) {
                    if (model.getSize() >= i || model.getElementAt(i) != program) continue;
                    itemIndex = i;
                    break;
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                if (itemIndex < 0) return;
                for (ListDataListener listener : listeners) {
                    listener.contentsChanged(new ListDataEvent(program, 0, itemIndex, itemIndex));
                }
                return;
            }
        }
    }
}

