/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import util.io.IOUtilities;
import util.ui.ImageIconEnhanced;

public class ImageUtilities {
    private static final Logger mLog = Logger.getLogger(ImageUtilities.class.getName());
    private static JLabel HELPER_LABEL;

    public static Image createImage(String fileName, boolean waitUntilLoaded) {
        if (!new File(fileName).exists()) {
            mLog.warning("File does not exist: '" + fileName + "'");
            return null;
        }
        Image img = Toolkit.getDefaultToolkit().createImage(fileName);
        if (waitUntilLoaded) {
            ImageUtilities.waitForImageData(img, null);
        }
        return img;
    }

    public static Image createImage(String fileName) {
        return ImageUtilities.createImage(fileName, true);
    }

    public static Image createImageAsynchronous(String fileName) {
        return ImageUtilities.createImage(fileName, false);
    }

    public static ImageIcon createImageIconFromJar(String fileName, Class<?> srcClass) {
        Image img = ImageUtilities.createImageFromJar(fileName, srcClass);
        if (img == null) {
            return null;
        }
        return new ImageIconEnhanced(img);
    }

    public static Image createImageFromJar(String fileName, Class<?> srcClass) {
        Image image = null;
        try {
            byte[] data = IOUtilities.loadFileFromJar(fileName, srcClass);
            image = Toolkit.getDefaultToolkit().createImage(data);
        }
        catch (Throwable thr) {
            String msg = "Loading '" + fileName + "' failed!";
            mLog.log(Level.WARNING, msg, thr);
            return null;
        }
        if (image != null) {
            ImageUtilities.waitForImageData(image, null);
        }
        return image;
    }

    public static void waitForImageData(Image image, Component comp) {
        if (comp == null) {
            comp = HELPER_LABEL;
        }
        MediaTracker tracker = new MediaTracker(comp);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ImageIcon createImageIcon(Icon icon, Color background, int border) {
        if (icon != null) {
            BufferedImage img = new BufferedImage(icon.getIconWidth() + border, icon.getIconHeight() + border, 1);
            Graphics2D g = img.createGraphics();
            if (background != null) {
                g.setColor(background);
                g.fillRect(0, 0, icon.getIconWidth() + border, icon.getIconHeight() + border);
            }
            icon.paintIcon(null, g, border / 2, border / 2);
            return new ImageIconEnhanced(img);
        }
        return null;
    }

    static {
        SwingUtilities.invokeLater(() -> {
            HELPER_LABEL = new JLabel();
        });
    }
}

