/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import util.settings.Property;
import util.settings.PropertyManager;

public class StringProperty
extends Property {
    private static final String NULL_VALUE = "(null)";
    private String mDefaultValue;
    private String mCachedValue;

    public StringProperty(PropertyManager manager, String key, String defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
    }

    public String getDefault() {
        return this.mDefaultValue;
    }

    public String getString() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            this.mCachedValue = asString == null ? (this.mDefaultValue == null ? NULL_VALUE : this.getDefault()) : asString;
        }
        if (this.mCachedValue.equals(NULL_VALUE)) {
            return null;
        }
        return this.mCachedValue;
    }

    public void setString(String value) {
        if (value == null) {
            value = NULL_VALUE;
        }
        if (this.mDefaultValue == null ? value.equals(NULL_VALUE) : value.equals(this.mDefaultValue)) {
            this.setProperty(null);
        } else {
            this.setProperty(value);
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }

    public void setDefault(String defaultValue) {
        this.mDefaultValue = defaultValue;
    }

    public void resetToDefault() {
        this.setString(this.getDefault());
    }

    public String toString() {
        return this.getString();
    }
}

