/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import util.settings.Property;
import util.settings.PropertyManager;

public class BooleanProperty
extends Property {
    private boolean mDefaultValue;
    private boolean mIsCacheFilled;
    private boolean mCachedValue;

    public BooleanProperty(PropertyManager manager, String key, boolean defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mIsCacheFilled = false;
    }

    public boolean getDefault() {
        return this.mDefaultValue;
    }

    public boolean getBoolean() {
        if (!this.mIsCacheFilled) {
            String asString = this.getProperty();
            this.mCachedValue = asString == null ? this.mDefaultValue : (asString.equalsIgnoreCase("true") || asString.equalsIgnoreCase("yes") ? true : (asString.equalsIgnoreCase("false") || asString.equalsIgnoreCase("no") ? false : this.mDefaultValue));
            this.mIsCacheFilled = true;
        }
        return this.mCachedValue;
    }

    public void setBoolean(boolean value) {
        if (value == this.mDefaultValue) {
            this.setProperty(null);
        } else if (value) {
            this.setProperty("true");
        } else {
            this.setProperty("false");
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mIsCacheFilled = false;
    }
}

