/*
 * Decompiled with CFR 0.152.
 */
package util.paramhandler;

import devplugin.Program;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import util.i18n.Localizer;
import util.paramhandler.ParamLibrary;

public class ParamParser {
    private static final char ESCAPE_IN_STRING = '%';
    private static final char ESCAPE_OUT_STRING = '\\';
    private ParamLibrary mLibrary;
    private String mErrorString = "";
    private boolean mErrors = false;

    public ParamParser() {
        this.mLibrary = new ParamLibrary();
    }

    public ParamParser(ParamLibrary lib) {
        this.mLibrary = lib;
    }

    public boolean hasErrors() {
        return this.mErrors;
    }

    public String getErrorString() {
        return this.mErrorString;
    }

    public ParamLibrary getParamLibrary() {
        return this.mLibrary;
    }

    public void setParamLibrary(ParamLibrary lib) {
        this.mLibrary = lib;
    }

    public String analyse(String command, Program prg) {
        boolean escapemode = false;
        boolean commandmode = false;
        boolean stringmode = false;
        boolean stringescape = false;
        StringBuilder cmdBuffer = new StringBuilder();
        char[] chars = command.toCharArray();
        StringBuilder ret = new StringBuilder();
        for (int pos = 0; pos < chars.length; ++pos) {
            if (stringmode && stringescape) {
                cmdBuffer.append(chars[pos]);
                stringescape = false;
                continue;
            }
            if (stringmode && chars[pos] == '%') {
                cmdBuffer.append(chars[pos]);
                stringescape = true;
                continue;
            }
            if (escapemode) {
                ret.append(chars[pos]);
                escapemode = false;
                continue;
            }
            if (chars[pos] == '\\') {
                escapemode = true;
                continue;
            }
            if (commandmode && chars[pos] == '\"') {
                cmdBuffer.append(chars[pos]);
                stringmode = !stringmode;
                continue;
            }
            if (stringmode && commandmode) {
                cmdBuffer.append(chars[pos]);
                continue;
            }
            if (chars[pos] == '{') {
                commandmode = true;
                cmdBuffer = new StringBuilder();
                continue;
            }
            if (chars[pos] == '}') {
                String newCommand = cmdBuffer.toString().trim();
                String retu = this.analyseCommand(prg, newCommand, pos - cmdBuffer.length());
                if (retu == null) {
                    return null;
                }
                ret.append(retu);
                commandmode = false;
                continue;
            }
            if (commandmode) {
                cmdBuffer.append(chars[pos]);
                continue;
            }
            ret.append(chars[pos]);
        }
        if (commandmode) {
            this.setError("One \"{\" was not closed properly");
            return null;
        }
        return ret.toString();
    }

    private void setError(String message) {
        this.mErrors = true;
        this.mErrorString = message;
    }

    private String analyseCommand(Program prg, String newCommand, int pos) {
        String ret;
        boolean stringmode = false;
        if (newCommand.startsWith("\"") && newCommand.endsWith("\"")) {
            ret = newCommand.substring(1, newCommand.length() - 1);
            stringmode = true;
        } else if (newCommand.indexOf(40) > -1) {
            String funcRet = this.parseFunction(prg, newCommand, pos);
            if (funcRet == null) {
                return null;
            }
            ret = funcRet;
        } else {
            String cmdRet = this.mLibrary.getStringForKey(prg, newCommand.trim());
            if (cmdRet == null && !this.mLibrary.hasErrors()) {
                this.setError("Could not understand Param \"" + newCommand + "\" at Position " + pos + ".");
                return null;
            }
            if (cmdRet == null) {
                this.mErrors = this.mLibrary.hasErrors();
                this.mErrorString = this.mLibrary.getErrorString();
                return null;
            }
            ret = cmdRet;
        }
        boolean stringEscape = false;
        StringBuilder result = new StringBuilder();
        if (stringmode) {
            for (int i = 0; i < ret.length(); ++i) {
                char c = ret.charAt(i);
                if (stringEscape) {
                    result.append(c);
                    stringEscape = false;
                    continue;
                }
                if (c == '%') {
                    stringEscape = true;
                    continue;
                }
                result.append(c);
            }
            ret = result.toString();
        }
        return ret;
    }

    private String parseFunction(Program prg, String function, int pos) {
        String funcname = StringUtils.substringBefore((String)function, (String)"(").trim();
        if (StringUtils.isEmpty((CharSequence)funcname)) {
            this.setError("A ( without a function-name was found at Position " + pos);
            return null;
        }
        if (!function.endsWith(")")) {
            this.setError("Function-Call \"" + funcname + "\" doesn't end with \")\" at Position " + pos);
            return null;
        }
        String params = function.substring(function.indexOf(40) + 1, function.lastIndexOf(41));
        String[] splitparams = this.splitParams(params, pos);
        if (splitparams == null) {
            return null;
        }
        for (int i = 0; i < splitparams.length; ++i) {
            splitparams[i] = this.analyseCommand(prg, splitparams[i], pos);
            if (splitparams[i] != null) continue;
            return null;
        }
        String result = this.mLibrary.getStringForFunction(prg, funcname, splitparams);
        if (result == null) {
            this.mErrors = this.mLibrary.hasErrors();
            this.mErrorString = this.mLibrary.getErrorString();
        }
        return result;
    }

    private String[] splitParams(String params, int strpos) {
        int infunction = 0;
        boolean instring = false;
        StringBuilder curparam = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        boolean escape = false;
        for (int i = 0; i < params.length(); ++i) {
            char c = params.charAt(i);
            if (escape) {
                curparam.append('%');
                curparam.append(c);
                escape = false;
                continue;
            }
            if (c == '%') {
                escape = true;
                continue;
            }
            if (c == '\"') {
                instring = !instring;
                curparam.append(c);
            } else if (c == ')') {
                --infunction;
                curparam.append(c);
            } else if (c == '(') {
                ++infunction;
                curparam.append(c);
            } else if (infunction > 0 || instring) {
                curparam.append(c);
            } else if (c == ',') {
                list.add(curparam.toString().trim());
                curparam = new StringBuilder();
            } else {
                curparam.append(c);
            }
            if (infunction >= 0) continue;
            this.setError("One \")\" at the wrong Position found");
            return null;
        }
        if (instring) {
            this.setError("One \" was not closed properly");
            return null;
        }
        if (infunction > 0) {
            this.setError("One \"(\" was not closed properly");
            return null;
        }
        list.add(curparam.toString().trim());
        return list.toArray(new String[list.size()]);
    }

    public boolean showErrors(Window parent) {
        if (this.hasErrors()) {
            JOptionPane.showMessageDialog(parent, this.getErrorString(), Localizer.getLocalization("i18n_error"), 0);
            return true;
        }
        return false;
    }

    public boolean showErrors() {
        return this.showErrors(null);
    }
}

