/*
 * Decompiled with CFR 0.152.
 */
package util.misc;

import java.lang.reflect.Array;

public final class HashCodeUtilities {
    private static final int SEED = 23;
    private static final int ODD_PRIME_NUMBER = 37;

    public static int hash(int aSeed, boolean aBoolean) {
        return HashCodeUtilities.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(boolean value) {
        return HashCodeUtilities.hash(23, value);
    }

    public static int hash(int aSeed, char aChar) {
        return HashCodeUtilities.firstTerm(aSeed) + aChar;
    }

    public static int hash(char value) {
        return HashCodeUtilities.hash(23, value);
    }

    public static int hash(int aSeed, int aInt) {
        return HashCodeUtilities.firstTerm(aSeed) + aInt;
    }

    public static int hash(int value) {
        return HashCodeUtilities.hash(23, value);
    }

    public static int hash(int aSeed, long aLong) {
        return HashCodeUtilities.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    public static int hash(long value) {
        return HashCodeUtilities.hash(23, value);
    }

    public static int hash(int aSeed, float aFloat) {
        return HashCodeUtilities.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    public static int hash(float value) {
        return HashCodeUtilities.hash(23, value);
    }

    public static int hash(int aSeed, double aDouble) {
        return HashCodeUtilities.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    public static int hash(double value) {
        return HashCodeUtilities.hash(23, value);
    }

    public static int hash(int seed, Object object) {
        int result = seed;
        if (object == null) {
            result = HashCodeUtilities.hash(result, 0);
        } else if (!HashCodeUtilities.isArray(object)) {
            result = HashCodeUtilities.hash(result, object.hashCode());
        } else {
            int length = Array.getLength(object);
            for (int idx = 0; idx < length; ++idx) {
                Object item = Array.get(object, idx);
                result = HashCodeUtilities.hash(result, item);
            }
        }
        return result;
    }

    public static int hash(Object value) {
        return HashCodeUtilities.hash(23, value);
    }

    private static int firstTerm(int seed) {
        return 37 * seed;
    }

    private static boolean isArray(Object aObject) {
        return aObject.getClass().isArray();
    }
}

