/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import tvbrowser.ui.settings.channel.ChannelConfigDlg;
import util.i18n.Localizer;
import util.ui.ColorButton;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class MultiChannelConfigDlg
extends JDialog
implements ActionListener,
WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelConfigDlg.class);
    private Channel[] mChannel;
    private JButton mCloseBt;
    private JButton mOKBt;
    private JComboBox<String> mCorrectionCB;
    private JCheckBox mUseUserBackground;
    private ColorButton mSelectBackgroundColor;
    private boolean mBackgroundWasSelected;

    public MultiChannelConfigDlg(Window parent, Channel[] channel) {
        super(parent, mLocalizer.msg("configChannel", "Configure Channel"));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.mChannel = channel;
        this.createDialog();
    }

    private void createDialog() {
        UiUtilities.registerForClosing(this);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout((LayoutManager)new FormLayout("default, 3dlu, fill:default:grow", "default, 3dlu, default, 3dlu, default, 3dlu, fill:0dlu:grow, 3dlu, default, 3dlu"));
        CellConstraints cc = new CellConstraints();
        panel.setBorder(Borders.DLU4);
        this.mUseUserBackground = new JCheckBox(ChannelConfigDlg.LOCALIZER.msg("backgroundColorUse", "User defined background color"), false);
        this.mSelectBackgroundColor = new ColorButton(Color.white);
        this.mSelectBackgroundColor.setEnabled(this.mUseUserBackground.isSelected());
        this.mUseUserBackground.addItemListener(e -> {
            this.mBackgroundWasSelected = true;
            this.mSelectBackgroundColor.setEnabled(e.getStateChange() == 1);
        });
        panel.add((Component)this.mUseUserBackground, CC.xyw((int)1, (int)1, (int)3));
        panel.add((Component)this.mSelectBackgroundColor, CC.xyw((int)1, (int)3, (int)3));
        panel.add((Component)new JLabel(mLocalizer.msg("time", "Time zone correction")), cc.xy(1, 5));
        this.mCorrectionCB = new JComboBox<String>(new String[]{"-1:00", "-0:45", "-0:30", "-0:15", "0:00", "+0:15", "+0:30", "+0:45", "+1:00"});
        this.mCorrectionCB.setSelectedIndex(this.mChannel[0].getTimeZoneCorrectionMinutes() / 15 + 4);
        panel.add(this.mCorrectionCB, cc.xy(3, 5));
        JTextArea txt = UiUtilities.createHelpTextArea(mLocalizer.msg("DLSTNote", ""));
        panel.add((Component)txt, cc.xyw(1, 7, 3));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        JButton defaultButton = new JButton(Localizer.getLocalization("i18n_default"));
        defaultButton.addActionListener(e -> this.resetToDefaults());
        builder.addButton((JComponent)defaultButton);
        builder.addRelatedGap();
        builder.addGlue();
        this.mOKBt = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOKBt.addActionListener(this);
        this.getRootPane().setDefaultButton(this.mOKBt);
        this.mCloseBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCloseBt.addActionListener(this);
        builder.addButton((JComponent[])new JButton[]{this.mOKBt, this.mCloseBt});
        panel.add((Component)builder.getPanel(), cc.xyw(1, 9, 3));
    }

    private void resetToDefaults() {
        this.mCorrectionCB.setSelectedIndex(this.mCorrectionCB.getItemCount() / 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.mOKBt) {
            int minutes = (this.mCorrectionCB.getSelectedIndex() - 4) * 15;
            for (Channel element : this.mChannel) {
                element.setTimeZoneCorrectionMinutes(minutes);
                if (!this.mBackgroundWasSelected) continue;
                element.setUserBackgroundColor(this.mUseUserBackground.isSelected() ? this.mSelectBackgroundColor.getColor() : null);
            }
            this.setVisible(false);
        } else if (o == this.mCloseBt) {
            this.setVisible(false);
        }
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

