/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.channel.ChannelUtil;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.ui.CaretPositionCorrector;
import util.ui.ColorButton;
import util.ui.EnhancedPanelBuilder;
import util.ui.ExtensionFileFilter;
import util.ui.ImageIconEnhanced;
import util.ui.ImageUtilities;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ChannelConfigDlg
extends JDialog
implements ActionListener,
WindowClosingIf {
    static final Localizer LOCALIZER = Localizer.getLocalizerFor(ChannelConfigDlg.class);
    private Channel mChannel;
    private JButton mCloseBt;
    private JButton mOKBt;
    private JComboBox<String> mCorrectionCB;
    private File mIconFile;
    private JButton mChangeIcon;
    private JTextField mChannelName;
    private JTextField mWebPage;
    private JSpinner mStartTimeLimit;
    private JSpinner mEndTimeLimit;
    private JLabel mIconLabel;
    private JTextField mSortNumber;
    private JCheckBox mUseUserBackground;
    private ColorButton mSelectBackgroundColor;

    public ChannelConfigDlg(Window parent, Channel channel) {
        super(parent, LOCALIZER.msg("configChannel", "Configure Channel"));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.mChannel = channel;
        this.createDialog();
    }

    private void createDialog() {
        EnhancedPanelBuilder panel = new EnhancedPanelBuilder(new FormLayout("default, 3dlu, fill:default:grow"), "3dlu", (JPanel)this.getContentPane());
        UiUtilities.registerForClosing(this);
        panel.border(Borders.DLU4);
        panel.addLabelRow(false, LOCALIZER.msg("channelNumber", "Sort number:"), 1);
        this.mSortNumber = new JTextField(this.mChannel.getSortNumber());
        panel.add(this.mSortNumber, 3);
        panel.addLabelRow(LOCALIZER.msg("channelName", "Channel Name:"), 1);
        this.mChannelName = new JTextField(this.mChannel.getName());
        panel.add(this.mChannelName, 3);
        panel.addLabelRow(LOCALIZER.msg("provider", "Provided by:"), 1);
        panel.labelAdd(ChannelUtil.getProviderName(this.mChannel), 3);
        panel.addLabelRow(LOCALIZER.msg("channelLogo", "Channel Logo:"), 1);
        if (this.mChannel.getUserIconFileName() != null) {
            this.mIconFile = new File(IOUtilities.translateRelativePath(this.mChannel.getUserIconFileName()));
        }
        this.mIconLabel = new JLabel(this.createUserIcon());
        this.mChangeIcon = new JButton(LOCALIZER.msg("useIcon", "Select channel icon"));
        this.mChangeIcon.addActionListener(e -> this.changeIcon());
        panel.add(this.mIconLabel, 3);
        panel.addRow(this.mChangeIcon, 3);
        this.mUseUserBackground = new JCheckBox(LOCALIZER.msg("backgroundColorUse", "User defined background color"), this.mChannel.isUsingUserBackgroundColor());
        this.mSelectBackgroundColor = new ColorButton(this.mChannel.isUsingUserBackgroundColor() ? this.mChannel.getUserBackgroundColor() : Color.white);
        this.mSelectBackgroundColor.setEnabled(this.mUseUserBackground.isSelected());
        this.mUseUserBackground.addItemListener(e -> this.mSelectBackgroundColor.setEnabled(e.getStateChange() == 1));
        panel.addRow(this.mUseUserBackground, 3);
        panel.addRow(this.mSelectBackgroundColor, 3);
        panel.addLabelRow(LOCALIZER.msg("webAddress", "Web Address:"), 1);
        this.mWebPage = new JTextField(this.mChannel.getWebpage());
        panel.add(this.mWebPage, 3);
        panel.addLabelRow(LOCALIZER.msg("time", "Time zone correction:"), 1);
        this.mCorrectionCB = new JComboBox<String>(new String[]{"-1:00", "-0:45", "-0:30", "-0:15", "0:00", "+0:15", "+0:30", "+0:45", "+1:00"});
        this.mCorrectionCB.setSelectedIndex(this.mChannel.getTimeZoneCorrectionMinutes() / 15 + 4);
        panel.add(this.mCorrectionCB, 3);
        JTextArea txt = UiUtilities.createHelpTextArea(LOCALIZER.msg("DLSTNote", ""));
        txt.setMinimumSize(new Dimension(150, 20));
        panel.addRow(txt, 3);
        panel.addLabelRow(LOCALIZER.msg("timeLimits", "Time limits:"), 1);
        String timePattern = LOCALIZER.msg("timePattern", "hh:mm a");
        this.mStartTimeLimit = new JSpinner(new SpinnerDateModel());
        this.mStartTimeLimit.setEditor(new JSpinner.DateEditor(this.mStartTimeLimit, timePattern));
        this.setTimeDate(this.mStartTimeLimit, this.mChannel.getStartTimeLimit());
        this.mEndTimeLimit = new JSpinner(new SpinnerDateModel());
        this.mEndTimeLimit.setEditor(new JSpinner.DateEditor(this.mEndTimeLimit, timePattern));
        this.setTimeDate(this.mEndTimeLimit, this.mChannel.getEndTimeLimit());
        ((JSpinner.DateEditor)this.mStartTimeLimit.getEditor()).getTextField().setHorizontalAlignment(2);
        ((JSpinner.DateEditor)this.mEndTimeLimit.getEditor()).getTextField().setHorizontalAlignment(2);
        CaretPositionCorrector.createCorrector(((JSpinner.DateEditor)this.mStartTimeLimit.getEditor()).getTextField(), new char[]{':'}, -1);
        CaretPositionCorrector.createCorrector(((JSpinner.DateEditor)this.mEndTimeLimit.getEditor()).getTextField(), new char[]{':'}, -1);
        EnhancedPanelBuilder timeLimitPanel = new EnhancedPanelBuilder(new FormLayout("default:grow,10dlu,default:grow"), "2dlu");
        timeLimitPanel.addLabelRow(false, LOCALIZER.msg("startTime", "Start time:"), 1);
        timeLimitPanel.labelAdd(LOCALIZER.msg("endTime", "End time:"), 3);
        timeLimitPanel.addRow(this.mStartTimeLimit, 1);
        timeLimitPanel.add(this.mEndTimeLimit, 3);
        panel.add(timeLimitPanel.getPanel(), 3);
        JTextArea txt2 = UiUtilities.createHelpTextArea(LOCALIZER.msg("DLSTNote", ""));
        txt2.setMinimumSize(new Dimension(150, 20));
        panel.addRow(txt2, 3);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        JButton defaultButton = new JButton(Localizer.getLocalization("i18n_default"));
        defaultButton.addActionListener(e -> this.resetToDefaults());
        builder.addButton((JComponent)defaultButton);
        builder.addRelatedGap();
        builder.addGlue();
        this.mOKBt = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOKBt.addActionListener(this);
        this.getRootPane().setDefaultButton(this.mOKBt);
        this.mCloseBt = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCloseBt.addActionListener(this);
        builder.addButton((JComponent[])new JButton[]{this.mOKBt, this.mCloseBt});
        panel.addRow("fill:0dlu:grow", false);
        panel.addRowFull("5dlu,default", (Component)new JSeparator());
        panel.addRowFull(builder.getPanel());
        this.pack();
        Settings.layoutWindow("channelConfig", this, new Dimension(420, 420));
    }

    private void setTimeDate(JSpinner toSet, int time) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, time / 60);
        cal.set(12, time % 60);
        toSet.setValue(cal.getTime());
    }

    private int getTimeInMinutes(JSpinner toGet) {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)toGet.getValue());
        return cal.get(11) * 60 + cal.get(12);
    }

    private void resetToDefaults() {
        this.mSortNumber.setText("");
        this.mWebPage.setText(this.mChannel.getDefaultWebPage());
        this.mChannelName.setText(this.mChannel.getDefaultName());
        this.mIconFile = null;
        this.mIconLabel.setIcon(this.createUserIcon());
        this.mCorrectionCB.setSelectedIndex(this.mCorrectionCB.getItemCount() / 2);
        this.setTimeDate(this.mStartTimeLimit, 0);
        this.setTimeDate(this.mEndTimeLimit, 0);
    }

    private Icon createUserIcon() {
        Image img;
        ImageIcon icon = this.mIconFile != null && this.mIconFile.exists() ? ((img = ImageUtilities.createImageAsynchronous(this.mIconFile.getAbsolutePath())) != null ? UiUtilities.createChannelIcon(new ImageIconEnhanced(img)) : UiUtilities.createChannelIcon(this.mChannel.getIcon())) : UiUtilities.createChannelIcon(this.mChannel.getDefaultIcon());
        return icon;
    }

    private void changeIcon() {
        File selection;
        JFileChooser fileChooser = new JFileChooser(this.mIconFile);
        String[] extArr = new String[]{".jpg", ".jpeg", ".gif", ".png"};
        fileChooser.setFileFilter(new ExtensionFileFilter(extArr, ".jpg, .gif, .png"));
        if (fileChooser.showOpenDialog(this) == 0 && (selection = fileChooser.getSelectedFile()) != null) {
            this.mIconFile = selection;
            this.mIconLabel.setIcon(this.createUserIcon());
        }
    }

    public void centerAndShow() {
        UiUtilities.centerAndShow(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.mOKBt) {
            int minutes = (this.mCorrectionCB.getSelectedIndex() - 4) * 15;
            this.mChannel.setTimeZoneCorrectionMinutes(minutes);
            this.mChannel.useUserIcon(this.mIconFile != null);
            if (this.mIconFile != null) {
                this.mChannel.setUserIconFileName(IOUtilities.checkForRelativePath(this.mIconFile.getAbsolutePath()));
            } else {
                this.mChannel.setUserIconFileName(null);
            }
            this.mChannel.setUserChannelName(this.mChannelName.getText());
            this.mChannel.setUserWebPage(this.mWebPage.getText());
            this.mChannel.setStartTimeLimit(this.getTimeInMinutes(this.mStartTimeLimit));
            this.mChannel.setEndTimeLimit(this.getTimeInMinutes(this.mEndTimeLimit));
            this.mChannel.setSortNumber(this.mSortNumber.getText().trim());
            this.mChannel.setUserBackgroundColor(this.mUseUserBackground.isSelected() ? this.mSelectBackgroundColor.getColor() : null);
            Settings.updateChannelFilters(ChannelList.getSubscribedChannels());
            this.setVisible(false);
        } else if (o == this.mCloseBt) {
            this.setVisible(false);
        }
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

