/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import tvbrowser.ui.settings.TrayProgramsChannelsSettingsTab;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;

public class TrayNowSettingsTab
implements SettingsTab {
    private JCheckBox mIsEnabled;
    private JCheckBox mShowTime;
    private JCheckBox mShowToolTip;
    private JRadioButton mShowInSubMenu;
    private JRadioButton mShowInTray;
    private static final Localizer LOCALIZER = TrayBaseSettingsTab.LOCALIZER;
    private JLabel mIconSeparator;
    private JLabel mSeparator1;
    private JLabel mSeparator2;
    private JEditorPane mHelpLabel;
    private JRadioButton mShowIconAndName;
    private JRadioButton mShowName;
    private JRadioButton mShowIcon;
    private JCheckBox mShowSortNumber;
    private static boolean mTrayIsEnabled = Settings.Tray.ENABLED.getBoolean();
    private static TrayNowSettingsTab mInstance = null;

    @Override
    public JPanel createSettingsPanel() {
        mInstance = this;
        EnhancedPanelBuilder builder = new EnhancedPanelBuilder(new FormLayout("5dlu,12dlu,default:grow,5dlu"));
        builder.border(Borders.DIALOG);
        this.mIsEnabled = new JCheckBox(LOCALIZER.msg("nowEnabled", "Show Now running programs"), Settings.Tray.Now.ENABLED.getBoolean());
        ButtonGroup bg = new ButtonGroup();
        this.mShowInSubMenu = new JRadioButton(LOCALIZER.msg("inSubMenu", "in a sub menu"), Settings.Tray.Now.IN_SUB_MENU.getBoolean());
        this.mShowInTray = new JRadioButton(LOCALIZER.msg("inTray", "in the tray menu"), !this.mShowInSubMenu.isSelected());
        bg.add(this.mShowInSubMenu);
        bg.add(this.mShowInTray);
        this.mShowIconAndName = new JRadioButton(LOCALIZER.msg("showIconName", "Show channel icon and channel name"), Settings.Tray.Now.CONTAINS_NAME.getBoolean() && Settings.Tray.Now.CONTAINS_ICON.getBoolean());
        this.mShowIcon = new JRadioButton(LOCALIZER.msg("showIcon", "Show channel icon"), !Settings.Tray.Now.CONTAINS_NAME.getBoolean() && Settings.Tray.Now.CONTAINS_ICON.getBoolean());
        this.mShowName = new JRadioButton(LOCALIZER.msg("showName", "Show channel name"), Settings.Tray.Now.CONTAINS_NAME.getBoolean() && !Settings.Tray.Now.CONTAINS_ICON.getBoolean());
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.mShowIconAndName);
        bg1.add(this.mShowIcon);
        bg1.add(this.mShowName);
        this.mShowSortNumber = new JCheckBox(LOCALIZER.msg("showChannelNumber", "Show sort number"), Settings.Tray.Now.SORT_NUMBER_SHOW.getBoolean());
        this.mShowTime = new JCheckBox(LOCALIZER.msg("showTime", "Show start time"), Settings.Tray.Now.CONTAINS_TIME.getBoolean());
        this.mShowToolTip = new JCheckBox(LOCALIZER.msg("showToolTip", "Show additional information of the program in a tool tip"), Settings.Tray.Now.CONTAINS_TOOL_TIP.getBoolean());
        this.mShowToolTip.setToolTipText(LOCALIZER.msg("toolTipTip", "Tool tips are small helper to something, like this one."));
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "The Tray is deactivated. To activate these settings activate the option <b>Tray activated</b> in the <a href=\"#link\">Tray Base settings</a>."), e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SettingsDialog.getInstance().showSettingsTab("#tray");
            }
        });
        JPanel c = (JPanel)builder.addSeparatorRowFull(false, LOCALIZER.msg("now", "Now running programs"));
        builder.addRow(this.mIsEnabled, 2, 2);
        builder.addRow(false, (Component)this.mShowInTray, 3);
        builder.addRow(false, (Component)this.mShowInSubMenu, 3);
        JPanel c1 = (JPanel)builder.addParagraph(LOCALIZER.msg("iconNameSeparator", "Channel icons/channel name"));
        builder.addRow(this.mShowIconAndName, 2, 2);
        builder.addRow(false, (Component)this.mShowIcon, 2, 2);
        builder.addRow(false, (Component)this.mShowName, 2, 2);
        builder.addRow(this.mShowSortNumber, 2, 2);
        JPanel c2 = (JPanel)builder.addParagraph(LOCALIZER.msg("settings", "Settings"));
        builder.addRow(this.mShowTime, 2, 2);
        builder.addRow(false, (Component)this.mShowToolTip, 2, 2);
        builder.addRowFull("fill:10dlu:grow", (Component)this.mHelpLabel);
        this.mSeparator1 = (JLabel)c.getComponent(0);
        this.mIconSeparator = (JLabel)c1.getComponent(0);
        this.mSeparator2 = (JLabel)c2.getComponent(0);
        this.setEnabled(true);
        this.mIsEnabled.addActionListener(e -> this.setEnabled(false));
        return builder.getPanel();
    }

    private void setEnabled(boolean trayStateChange) {
        this.mHelpLabel.setVisible(!mTrayIsEnabled);
        if (trayStateChange) {
            this.mSeparator1.setEnabled(mTrayIsEnabled);
            this.mIsEnabled.setEnabled(mTrayIsEnabled);
        }
        TrayProgramsChannelsSettingsTab.setNowIsEnabled(this.mIsEnabled.isSelected());
        this.mIconSeparator.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSeparator2.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInSubMenu.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInTray.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIconAndName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIcon.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowTime.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowToolTip.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowSortNumber.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
    }

    @Override
    public void saveSettings() {
        if (this.mIsEnabled != null) {
            Settings.Tray.Now.ENABLED.setBoolean(this.mIsEnabled.isSelected());
        }
        if (this.mShowInSubMenu != null) {
            Settings.Tray.Now.IN_SUB_MENU.setBoolean(this.mShowInSubMenu.isSelected());
        }
        if (this.mShowIconAndName != null && this.mShowName != null && this.mShowIcon != null) {
            Settings.Tray.Now.CONTAINS_NAME.setBoolean(this.mShowIconAndName.isSelected() || this.mShowName.isSelected());
            Settings.Tray.Now.CONTAINS_ICON.setBoolean(this.mShowIconAndName.isSelected() || this.mShowIcon.isSelected());
        }
        if (this.mShowTime != null) {
            Settings.Tray.Now.CONTAINS_TIME.setBoolean(this.mShowTime.isSelected());
        }
        if (this.mShowToolTip != null) {
            Settings.Tray.Now.CONTAINS_TOOL_TIP.setBoolean(this.mShowToolTip.isSelected());
        }
        if (this.mShowSortNumber != null) {
            Settings.Tray.Now.SORT_NUMBER_SHOW.setBoolean(this.mShowSortNumber.isSelected());
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("now", "Now running programs");
    }

    protected static void setTrayIsEnabled(boolean value) {
        mTrayIsEnabled = value;
        if (mInstance != null) {
            mInstance.setEnabled(true);
        }
    }
}

