/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable.background;

import devplugin.Program;
import java.awt.Image;
import tvbrowser.core.Settings;
import tvbrowser.ui.programtable.background.AbstractCellBasedBackPainter;
import util.ui.ImageUtilities;

public class TimeOfDayBackPainter
extends AbstractCellBasedBackPainter {
    private static final int mEarlyTime = 360;
    private static final int mMiddayTime = 720;
    private static final int mAfternoonTime = 960;
    private static final int mEveningTime = 1200;
    private Image mBackgroundImageEdge = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EDGE.getString());
    private Image mBackgroundImageEarly = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EARLY.getString());
    private Image mBackgroundImageMidday = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_MIDDAY.getString());
    private Image mBackgroundImageAfternoon = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_AFTERNOON.getString());
    private Image mBackgroundImageEvening = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_OF_DAY_BACKGROUND_EVENING.getString());

    @Override
    protected Image getOuterBackgroundImage() {
        return this.mBackgroundImageEdge;
    }

    @Override
    protected Image getBackgroundImageFor(Program prog) {
        int startTime = prog.getHours() * 60 + prog.getMinutes();
        if (startTime >= 1200) {
            return this.mBackgroundImageEvening;
        }
        if (startTime >= 960) {
            return this.mBackgroundImageAfternoon;
        }
        if (startTime >= 720) {
            return this.mBackgroundImageMidday;
        }
        if (startTime >= 360) {
            return this.mBackgroundImageEarly;
        }
        return this.mBackgroundImageEvening;
    }
}

