/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable.background;

import devplugin.Date;
import devplugin.Program;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import tvbrowser.core.Settings;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import tvbrowser.ui.programtable.ProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import tvbrowser.ui.programtable.background.AbstractBackPainter;
import util.ui.ImageUtilities;
import util.ui.ProgramPanel;
import util.ui.TimeFormatter;

public class TimeBlockBackPainter
extends AbstractBackPainter {
    private static final Font TABLE_WEST_FONT = new Font("Dialog", 0, 14);
    private static final Color TABLE_WEST_FONT_COLOR = Color.DARK_GRAY;
    private Image mBackgroundImage1;
    private Image mBackgroundImage2;
    private Image mTableWestImage1;
    private Image mTableWestImage2;
    private int mBlockSize;
    private TimeBlock[] mBlockArr;
    private JComponent mTableWest;
    private TimeFormatter mFormatter = Settings.Locales.TWELVE_HOUR_FORMAT.getBoolean() ? new TimeFormatter("hh a") : new TimeFormatter("HH");

    public TimeBlockBackPainter() {
        this.mBackgroundImage1 = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_BLOCK_BACKGROUND1.getString());
        this.mBackgroundImage2 = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_BLOCK_BACKGROUND2.getString());
        this.mTableWestImage1 = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_BLOCK_WEST_IMAGE1.getString());
        this.mTableWestImage2 = ImageUtilities.createImageAsynchronous(Settings.ProgramTable.TIME_BLOCK_WEST_IMAGE2.getString());
        this.mTableWest = Settings.ProgramTable.TIME_BLOCK_SHOW_WEST.getBoolean() ? new TimeBlockTableWest() : null;
        this.mBlockSize = Settings.ProgramTable.TIME_BLOCK_SIZE.getInt();
    }

    @Override
    public void layoutChanged(ProgramTableLayout layout, ProgramTableModel model) {
        this.mBlockArr = this.createBlockArray(layout, model);
    }

    @Override
    public void paintBackground(Graphics grp, int columnWidth, int tableHeight, int minCol, int maxCol, Rectangle clipBounds, ProgramTableLayout layout, ProgramTableModel model) {
        int minY;
        TimeBlock[] blockArr = this.createBlockArray(layout, model);
        boolean toggleFlag = true;
        int maxY = -1;
        for (int i = 0; i < blockArr.length; ++i) {
            Image backImg = toggleFlag ? this.mBackgroundImage1 : this.mBackgroundImage2;
            minY = blockArr[i].mStartY;
            maxY = i + 1 < blockArr.length ? blockArr[i + 1].mStartY : tableHeight;
            int x = minCol * columnWidth;
            for (int col = minCol; col <= maxCol; ++col) {
                this.fillImage(grp, x, minY, columnWidth, maxY - minY, backImg, clipBounds);
                x += columnWidth;
            }
            toggleFlag = !toggleFlag;
        }
        if (maxY < tableHeight) {
            minY = maxY + 1;
            maxY = tableHeight;
            Image backImg = toggleFlag ? this.mBackgroundImage1 : this.mBackgroundImage2;
            int x = minCol * columnWidth;
            for (int col = minCol; col <= maxCol; ++col) {
                this.fillImage(grp, x, minY, columnWidth, maxY - minY, backImg, clipBounds);
                x += columnWidth;
            }
        }
        super.paintBackground(grp, columnWidth, tableHeight, minCol, maxCol, clipBounds, layout, model);
    }

    private TimeBlock[] createBlockArray(ProgramTableLayout layout, ProgramTableModel model) {
        int blockCount = 48 / this.mBlockSize;
        TimeBlock[] blocks = new TimeBlock[blockCount];
        for (int i = 0; i < blockCount; ++i) {
            blocks[i] = new TimeBlock(i * this.mBlockSize * 60);
        }
        Date mainDate = ((DefaultProgramTableModel)model).getDate();
        int columnCount = model.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            int y = layout.getColumnStart(col);
            int rowCount = model.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = model.getProgramPanel(col, row);
                if (panel == null) continue;
                Program prog = panel.getProgram();
                int startTime = prog.getStartTime();
                if (!mainDate.equals(prog.getDate())) {
                    startTime += 1440;
                }
                int blockIndex = startTime / (this.mBlockSize * 60);
                TimeBlock block = blocks[blockIndex];
                int blockY = block.mStartY;
                if (blockY == -1 || y < blockY) {
                    block.mStartY = y;
                }
                y += panel.getHeight();
            }
        }
        ArrayList<TimeBlock> list = new ArrayList<TimeBlock>();
        for (int i = 0; i < blockCount; ++i) {
            if (blocks[i].mStartY == -1) continue;
            list.add(blocks[i]);
        }
        return list.toArray(new TimeBlock[list.size()]);
    }

    @Override
    public JComponent getTableWest() {
        return this.mTableWest;
    }

    class TimeBlockTableWest
    extends JComponent {
        private FontMetrics mFontMetrics = this.getFontMetrics(TABLE_WEST_FONT);

        @Override
        public Dimension getPreferredSize() {
            int width = this.mFontMetrics.stringWidth(TimeBlockBackPainter.this.mFormatter.formatTime(23, 0)) + 4;
            int height = 1000000;
            return new Dimension(width, height);
        }

        @Override
        public void paintComponent(Graphics grp) {
            TimeBlock[] blockArr = TimeBlockBackPainter.this.mBlockArr;
            if (blockArr != null && blockArr.length > 0) {
                boolean toggleFlag = false;
                int width = this.getWidth();
                int height = this.getHeight();
                Rectangle clipBounds = grp.getClipBounds();
                grp.setFont(TABLE_WEST_FONT);
                grp.setColor(TABLE_WEST_FONT_COLOR);
                for (int i = 0; i < blockArr.length; ++i) {
                    toggleFlag = !toggleFlag;
                    int minY = blockArr[i].mStartY;
                    int maxY = i + 1 < blockArr.length ? blockArr[i + 1].mStartY : height;
                    if (!clipBounds.intersects(0.0, minY, width, maxY - minY)) continue;
                    Image backImg = toggleFlag ? TimeBlockBackPainter.this.mTableWestImage1 : TimeBlockBackPainter.this.mTableWestImage2;
                    TimeBlockBackPainter.this.fillImage(grp, 0, minY, width, maxY - minY, backImg, clipBounds);
                    String msg = TimeBlockBackPainter.this.mFormatter.formatTime(blockArr[i].mStartTime / 60 % 24, 0);
                    int msgWidth = this.mFontMetrics.stringWidth(msg);
                    int x = width - msgWidth - 2;
                    grp.drawString(msg, x, minY + TABLE_WEST_FONT.getSize());
                }
            }
        }
    }

    private static class TimeBlock {
        private int mStartTime;
        private int mStartY;

        public TimeBlock(int startTime) {
            this.mStartTime = startTime;
            this.mStartY = -1;
        }
    }
}

